/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.services.DynamicPageCache;
import com.googlecode.fascinator.portal.services.PortalManager;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import com.googlecode.fascinator.portal.services.VelocityService;
import com.googlecode.fascinator.portal.services.cache.JythonCacheEntryFactory;
import com.googlecode.fascinator.portal.services.impl.EhcacheDynamicPageCacheImpl;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.python.core.PyInstance;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhcacheDynamicPageCacheImpl
implements DynamicPageCache {
    private static final String SCRIPT_CACHE_ID = "scriptObjects";
    private static final String PATH_CACHE_ID = "pathLookup";
    private static final String DEFAULT_PROFILE = "default";
    private Logger log = LoggerFactory.getLogger(EhcacheDynamicPageCacheImpl.class);
    private PortalManager portalManager;
    private CacheManager cacheManager;
    private Ehcache scriptCache;
    private Ehcache pathCache;
    private boolean lastModifiedCheck;
    private Map<String, Long> lastModifiedMap;

    public EhcacheDynamicPageCacheImpl(PortalManager portalManager, VelocityService velocityService, ScriptingServices scriptingServices) {
        this.portalManager = portalManager;
        this.cacheManager = new CacheManager();
        this.cacheManager.addCache(SCRIPT_CACHE_ID);
        this.cacheManager.addCache(PATH_CACHE_ID);
        try {
            JsonSimpleConfig config = new JsonSimpleConfig();
            Map cacheProfiles = config.getJsonSimpleMap(new Object[]{"portal", "caching", "profiles"});
            Map cacheConfigs = config.getJsonSimpleMap(new Object[]{"portal", "caching", "caches"});
            for (String cacheId : cacheConfigs.keySet()) {
                Cache cache = this.cacheManager.getCache(cacheId);
                if (cache == null) {
                    this.log.warn("Cache '{}' does not exist!", (Object)cacheId);
                    continue;
                }
                JsonSimple jsonConfig = (JsonSimple)cacheConfigs.get(cacheId);
                String profileId = jsonConfig.getString(DEFAULT_PROFILE, new Object[]{"profile"});
                if (cacheProfiles.containsKey(profileId)) {
                    this.log.debug("Configuring cache '{}' with profile '{}'", (Object)cacheId, (Object)profileId);
                    JsonSimple profile = (JsonSimple)cacheProfiles.get(profileId);
                    CacheConfiguration cacheConfig = cache.getCacheConfiguration();
                    cacheConfig.setMaxElementsInMemory(profile.getInteger(Integer.valueOf(10000), new Object[]{"maxElementsInMemory"}).intValue());
                    cacheConfig.setEternal(profile.getBoolean(Boolean.valueOf(false), new Object[]{"eternal"}).booleanValue());
                    if (!cacheConfig.isEternal()) {
                        cacheConfig.setTimeToIdleSeconds((long)profile.getInteger(Integer.valueOf(120), new Object[]{"timeToIdleSeconds"}).intValue());
                        cacheConfig.setTimeToLiveSeconds((long)profile.getInteger(Integer.valueOf(120), new Object[]{"timeToLiveSeconds"}).intValue());
                    }
                    cacheConfig.setOverflowToDisk(profile.getBoolean(Boolean.valueOf(false), new Object[]{"overflowToDisk"}).booleanValue());
                    cacheConfig.setMaxElementsOnDisk(profile.getInteger(Integer.valueOf(10000), new Object[]{"maxElementsOnDisk"}).intValue());
                    cacheConfig.setMemoryStoreEvictionPolicy(profile.getString("LRU", new Object[]{"memoryStoreEvictionPolicy"}));
                    continue;
                }
                this.log.warn("Cache profile '{}' does not exist!", (Object)profileId);
            }
            this.lastModifiedCheck = config.getBoolean(Boolean.valueOf(false), new Object[]{"portal", "caching", "caches", SCRIPT_CACHE_ID, "lastModifiedCheck"});
            if (this.lastModifiedCheck) {
                this.lastModifiedMap = new HashMap();
            }
            this.scriptCache = new SelfPopulatingCache((Ehcache)this.cacheManager.getCache(SCRIPT_CACHE_ID), (CacheEntryFactory)new JythonCacheEntryFactory(portalManager, velocityService, scriptingServices));
            this.pathCache = this.cacheManager.getCache(PATH_CACHE_ID);
        }
        catch (IOException ioe) {
            this.log.warn("Failed to configure caches, using defaults...", (Throwable)ioe);
        }
    }

    public void registryDidShutdown() {
        if (this.cacheManager != null) {
            this.cacheManager.shutdown();
        }
    }

    public PyObject getScriptObject(String path) {
        Object objectValue;
        Element element;
        if (this.lastModifiedCheck) {
            File scriptFile = new File(this.portalManager.getHomeDir(), path);
            long lastModified = scriptFile.lastModified();
            if (this.lastModifiedMap.containsKey(path) && lastModified > (Long)this.lastModifiedMap.get(path)) {
                this.scriptCache.remove((Serializable)((Object)path));
            }
            this.lastModifiedMap.put(path, lastModified);
        }
        if ((element = this.scriptCache.get((Serializable)((Object)path))) != null && (objectValue = element.getObjectValue()) instanceof PyInstance) {
            return new LocalPyInstance(this, (PyInstance)objectValue);
        }
        return null;
    }

    public String getPath(String pathId) {
        Element element = this.pathCache.get((Serializable)((Object)pathId));
        if (element != null) {
            return element.getObjectValue().toString();
        }
        return null;
    }

    public void putPath(String pathId, String path) {
        this.pathCache.put(new Element((Serializable)((Object)pathId), (Serializable)((Object)path)));
    }
}

