/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.services.ByteRangeRequestCache;
import com.googlecode.fascinator.portal.services.impl.HouseKeepingManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteRangeRequestCacheImpl
implements ByteRangeRequestCache {
    private static int BUFFER_SIZE = 4096;
    private Logger log = LoggerFactory.getLogger(HouseKeepingManagerImpl.class);
    private JsonSimpleConfig sysConfig;
    private Storage storage;
    private boolean isValid = true;

    public ByteRangeRequestCacheImpl() {
        try {
            this.sysConfig = new JsonSimpleConfig();
        }
        catch (IOException ex) {
            this.isValid = false;
            this.log.error("Failed to access system config", (Throwable)ex);
            return;
        }
        boolean configured = this.sysConfig.getBoolean(Boolean.valueOf(false), new Object[]{"portal", "byteRangeSupported"});
        if (!configured) {
            this.log.info("Byte range support disabled by configuration!");
            this.isValid = false;
            return;
        }
        try {
            String storageType = this.sysConfig.getString(null, new Object[]{"storage", "type"});
            if (storageType == null) {
                this.log.error("Invalid system configuration. No storage type!");
            } else {
                this.storage = PluginManager.getStorage((String)storageType);
                this.storage.init(this.sysConfig.toString());
            }
        }
        catch (PluginException ex) {
            this.isValid = false;
            this.log.error("Failed to initialise storage", (Throwable)ex);
        }
    }

    public boolean processRequest(Request request, Response response, Payload payload) {
        if (!this.isValid) {
            return false;
        }
        String byteHeader = request.getHeader("Range");
        if (byteHeader == null) {
            return false;
        }
        if (payload.size() == null) {
            this.log.error("Range request received, but storage cannot support");
            return false;
        }
        String userAgent = request.getHeader("User-Agent");
        String[] parts = StringUtils.split((String)byteHeader, (String)"=");
        if (parts.length != 2) {
            this.log.error("Invalid byte range request received: '{}'", (Object)byteHeader);
            this.log.error("User Agent: '{}'", (Object)userAgent);
            return false;
        }
        String[] requests = StringUtils.split((String)parts[1], (String)",");
        if (requests.length == 1) {
            return this.processSingle(requests[0], userAgent, response, payload);
        }
        this.log.error("Non supported multi-part range request received: '{}'", (Object)byteHeader);
        this.log.error("User Agent: '{}'", (Object)userAgent);
        return false;
    }

    private boolean processSingle(String request, String agent, Response response, Payload payload) {
        long starts = -1L;
        long ends = -1L;
        long size = payload.size();
        String[] parts = StringUtils.split((String)request, (String)"-");
        if (parts.length != 2) {
            return this.logInvalid(request, agent);
        }
        if (!parts[0].equals("")) {
            starts = Long.parseLong(parts[0]);
        }
        if (starts > (ends = !parts[1].equals("") ? Long.parseLong(parts[1]) : size - 1L) || starts == -1L && ends < 1L) {
            return this.logInvalid(request, agent);
        }
        if (starts == -1L) {
            starts = size - 1L - ends;
            ends = size - 1L;
            if (starts < 0L) {
                starts = 0L;
            }
        }
        if (starts != -1L && starts >= size) {
            return this.outOfRange(request, agent, response);
        }
        if (ends == -1L || ends >= size) {
            ends = size - 1L;
        }
        return this.streamResponse(starts, ends, agent, response, payload);
    }

    private boolean streamResponse(long start, long end, String agent, Response response, Payload payload) {
        this.log.debug("Byte Range: {} - {}", (Object)start, (Object)end);
        this.log.debug("User Agent: {}", (Object)agent);
        long size = payload.size();
        long dataLength = end - start + 1L;
        String rangeResponse = "bytes " + start + "-" + end + "/" + size;
        try {
            InputStream in = payload.open();
            String mimeType = payload.getContentType();
            if (mimeType == null) {
                this.log.warn("Unknown MIME type! Using default");
                mimeType = "application/octet-stream";
            }
            mimeType = mimeType + "; name=\"" + payload.getId() + "\"";
            String disposition = "attachment; filename=\"" + payload.getId() + "\"";
            response.setStatus(206);
            response.setHeader("Accept-Ranges", "bytes");
            response.setHeader("Connection", "keep-alive");
            response.setHeader("Keep-Alive", "timeout=2, max=98");
            response.setHeader("Content-Description", "File Transfer");
            response.setHeader("Content-Disposition", disposition);
            response.setHeader("Content-Transfer-Encoding", "binary");
            response.setHeader("Content-Type", mimeType);
            OutputStream out = response.getOutputStream(mimeType);
            response.setHeader("Content-Range", rangeResponse);
            response.setContentLength((int)dataLength);
            byte[] buffer = new byte[BUFFER_SIZE];
            int index = 0;
            int read = 0;
            boolean success = false;
            boolean finished = false;
            try {
                int n = 0;
                while (-1 != (n = in.read(buffer)) && !finished) {
                    int i = 0;
                    int len = n;
                    if ((long)index < start && (long)(index + n) >= start) {
                        i = (int)(start - (long)index);
                        len -= i;
                    }
                    if ((long)index <= end && (long)(index + n) > end) {
                        len = (int)(end - (long)index - (long)i + 1L);
                        finished = true;
                    }
                    if ((long)(index + i) >= start && (long)(index + i + len - 1) <= end) {
                        out.write(buffer, i, len);
                        read += len;
                    }
                    index += n;
                }
                out.close();
                success = true;
            }
            catch (IOException ex) {
                if (read > 0) {
                    this.log.error("(!) Connection lost: {} - {} bytes of data sent", (Object)(read - BUFFER_SIZE), (Object)read);
                    success = true;
                }
                this.log.error("Bytes read: {}", (Object)read);
                this.log.error("Error accessing data", (Throwable)ex);
                return false;
            }
            payload.close();
            return success;
        }
        catch (IOException ex) {
            this.log.error("Error accessing response output", (Throwable)ex);
            return false;
        }
        catch (StorageException ex) {
            this.log.error("Error accessing data", (Throwable)ex);
            return false;
        }
    }

    private boolean outOfRange(String request, String agent, Response response) {
        this.log.error("Out-of-range byte range request received: '{}'", (Object)request);
        this.log.error("User Agent: '{}'", (Object)agent);
        response.setStatus(416);
        return true;
    }

    private boolean logInvalid(String request, String agent) {
        this.log.error("Invalid byte range request received: '{}'", (Object)request);
        this.log.error("User Agent: '{}'", (Object)agent);
        return false;
    }
}

