/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.portal.FormData;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.guitoolkit.GUIToolkit;
import com.googlecode.fascinator.portal.services.DynamicPageCache;
import com.googlecode.fascinator.portal.services.DynamicPageService;
import com.googlecode.fascinator.portal.services.HouseKeepingManager;
import com.googlecode.fascinator.portal.services.PortalManager;
import com.googlecode.fascinator.portal.services.PortalSecurityManager;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import com.googlecode.fascinator.portal.services.VelocityService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Response;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.python.core.Py;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingDynamicPageServiceImpl
implements DynamicPageService {
    private static final String DEFAULT_LAYOUT = "layout";
    private static final String AJAX_EXT = ".ajax";
    private static final String SCRIPT_EXT = ".script";
    private static final String SCRIPT_ACTIVATE_METHOD = "__activate__";
    private Logger log = LoggerFactory.getLogger(CachingDynamicPageServiceImpl.class);
    @Inject
    private RequestGlobals requestGlobals;
    @Inject
    private Request request;
    @Inject
    private Response response;
    @Inject
    private ScriptingServices scriptingServices;
    @Inject
    private HouseKeepingManager houseKeeping;
    @Inject
    private PortalSecurityManager security;
    @Inject
    private DynamicPageCache pageCache;
    private VelocityService velocityService;
    private JsonSimpleConfig config;
    private String layoutName;
    private String urlBase;
    private String portalPath;
    private GUIToolkit toolkit;
    private String defaultPortal;
    private String defaultDisplay;

    public CachingDynamicPageServiceImpl(PortalManager portalManager, VelocityService velocityService) {
        this.velocityService = velocityService;
        try {
            this.config = new JsonSimpleConfig();
            this.layoutName = this.config.getString(DEFAULT_LAYOUT, new Object[]{"portal", DEFAULT_LAYOUT});
            this.urlBase = this.config.getString(null, new Object[]{"urlBase"});
            this.toolkit = new GUIToolkit();
            this.portalPath = portalManager.getHomeDir().getAbsolutePath();
            this.defaultPortal = portalManager.getDefaultPortal();
            this.defaultDisplay = portalManager.getDefaultDisplay();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public InputStream getResource(String resourcePath) {
        this.log.warn("getResource() is deprecated, use VelocityService.getResource()  ({})", (Object)resourcePath);
        return this.velocityService.getResource(resourcePath);
    }

    @Deprecated
    public InputStream getResource(String portalId, String resourceName) {
        this.log.warn("getResource() is deprecated, use VelocityService.getResource()  ({}/{})", (Object)portalId, (Object)resourceName);
        return this.velocityService.getResource(portalId, resourceName);
    }

    @Deprecated
    public String resourceExists(String portalId, String resourceName) {
        String resourcePath = this.velocityService.resourceExists(portalId, resourceName);
        this.log.warn("resourceExists() is deprecated, use VelocityService.resourceExists() ({})", (Object)resourcePath);
        return resourcePath;
    }

    public String render(String portalId, String pageName, OutputStream out, FormData formData, JsonSessionState sessionState) {
        boolean committed;
        boolean isAjax = pageName.endsWith(AJAX_EXT);
        boolean isScript = pageName.endsWith(SCRIPT_EXT);
        if (isAjax || isScript) {
            pageName = FilenameUtils.removeExtension((String)pageName);
        }
        String contextPath = this.request.getContextPath();
        int serverPort = this.requestGlobals.getHTTPServletRequest().getServerPort();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("systemConfig", this.config);
        bindings.put("Services", this.scriptingServices);
        bindings.put("systemProperties", System.getProperties());
        bindings.put("request", this.request);
        bindings.put("response", this.response);
        bindings.put("formData", formData);
        bindings.put("sessionState", sessionState);
        bindings.put("security", this.security);
        bindings.put("contextPath", contextPath);
        bindings.put("scriptsPath", this.portalPath + "/" + portalId + "/scripts");
        bindings.put("portalDir", this.portalPath + "/" + portalId);
        bindings.put("portalId", portalId);
        bindings.put("urlBase", this.urlBase);
        bindings.put("portalPath", this.urlBase + portalId);
        bindings.put("defaultPortal", this.defaultPortal);
        bindings.put("pageName", pageName);
        bindings.put("serverPort", serverPort);
        bindings.put("toolkit", this.toolkit);
        bindings.put("log", this.log);
        bindings.put("notifications", this.houseKeeping.getUserMessages());
        bindings.put("bindings", bindings);
        HashSet messages = new HashSet();
        bindings.put("page", this.evalScript(portalId, this.layoutName, bindings, messages));
        bindings.put("self", this.evalScript(portalId, pageName, bindings, messages));
        String mimeType = "text/html";
        Object mimeTypeAttr = this.request.getAttribute("Content-Type");
        if (mimeTypeAttr != null) {
            mimeType = mimeTypeAttr.toString();
        }
        if (committed = this.response.isCommitted()) {
            return mimeType;
        }
        if (this.velocityService.resourceExists(portalId, pageName + ".vm") != null) {
            VelocityContext vc = new VelocityContext();
            for (String key : bindings.keySet()) {
                vc.put(key, bindings.get(key));
            }
            vc.put("velocityContext", (Object)vc);
            if (!messages.isEmpty()) {
                vc.put("renderMessages", messages);
            }
            try {
                this.log.debug("Rendering page {}/{}.vm...", (Object)portalId, (Object)pageName);
                StringWriter pageContentWriter = new StringWriter();
                this.velocityService.renderTemplate(portalId, pageName, (Context)vc, (Writer)pageContentWriter);
                if (isAjax || isScript) {
                    out.write(pageContentWriter.toString().getBytes());
                } else {
                    vc.put("pageContent", (Object)pageContentWriter.toString());
                }
            }
            catch (Exception e) {
                ByteArrayOutputStream eOut = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(eOut));
                String eMsg = eOut.toString();
                this.log.error("Failed to render page ({})!\n=====\n{}\n=====", (Object)(isAjax ? "ajax" : (isScript ? "script" : "html")), (Object)eMsg);
                String errorMsg = "<pre>Page content template error: " + pageName + "\n" + eMsg + "</pre>";
                if (isAjax || isScript) {
                    try {
                        out.write(errorMsg.getBytes());
                    }
                    catch (Exception e2) {
                        this.log.error("Failed to output error message!");
                    }
                }
                vc.put("pageContent", (Object)errorMsg);
            }
            if (!isAjax && !isScript) {
                try {
                    this.log.debug("Rendering layout {}/{}.vm for page {}.vm...", new Object[]{portalId, this.layoutName, pageName});
                    OutputStreamWriter pageWriter = new OutputStreamWriter(out, "UTF-8");
                    this.velocityService.renderTemplate(portalId, this.layoutName, (Context)vc, (Writer)pageWriter);
                    ((Writer)pageWriter).close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return mimeType;
    }

    public String renderObject(Context context, String template, SolrDoc metadata) {
        String previewType;
        String portalId = context.get("portalId").toString();
        String displayType = metadata.getString(this.defaultDisplay, new Object[]{"display_type"});
        if ("".equals(displayType)) {
            displayType = this.defaultDisplay;
        }
        if (template.startsWith("detail") && (previewType = metadata.getString(null, new Object[]{"preview_type"})) != null && !"".equals(previewType)) {
            this.log.debug("Preview template found: '{}'", (Object)previewType);
            displayType = previewType;
        }
        String templateName = "display/" + displayType + "/" + template;
        Object parentPageObject = null;
        VelocityContext objectContext = new VelocityContext(context);
        parentPageObject = objectContext.containsKey((Object)"parent") ? objectContext.get("parent") : objectContext.get("self");
        objectContext.put("pageName", (Object)template);
        objectContext.put("displayType", (Object)displayType);
        objectContext.put("parent", parentPageObject);
        objectContext.put("metadata", (Object)metadata);
        Set<String> messages = null;
        if (objectContext.containsKey((Object)"renderMessages")) {
            messages = (Set)objectContext.get("renderMessages");
        } else {
            messages = new HashSet();
            context.put("renderMessages", messages);
        }
        Map bindings = (Map)objectContext.get("bindings");
        bindings.put("metadata", metadata);
        objectContext.put("self", (Object)this.evalScript(portalId, templateName, bindings, messages));
        String content = "";
        try {
            this.log.debug("Rendering display page {}/{}.vm...", (Object)portalId, (Object)templateName);
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(portalId, templateName, (Context)objectContext, (Writer)pageContentWriter);
            content = pageContentWriter.toString();
        }
        catch (Exception e) {
            this.log.error("Failed rendering display page: {}", (Object)templateName);
            ByteArrayOutputStream eOut = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(eOut));
            String eMsg = eOut.toString();
            messages.add("Page content template error: " + templateName + "\n" + eMsg);
        }
        return content;
    }

    private PyObject evalScript(String portalId, String pageName, Map<String, Object> context, Set<String> messages) {
        PyObject scriptObject = null;
        String scriptName = "scripts/" + pageName + ".py";
        try {
            String path = this.velocityService.resourceExists(portalId, scriptName);
            if (path == null) {
                this.log.debug("No script for portalId:'{}' scriptName:'{}'", (Object)portalId, (Object)scriptName);
            } else {
                scriptObject = this.pageCache.getScriptObject(path);
                if (scriptObject.__findattr__(SCRIPT_ACTIVATE_METHOD) != null) {
                    scriptObject.invoke(SCRIPT_ACTIVATE_METHOD, Py.java2py(context));
                } else {
                    this.log.warn("{} method not found for scriptPath:'{}'", (Object)SCRIPT_ACTIVATE_METHOD, (Object)path);
                }
            }
        }
        catch (Exception e) {
            ByteArrayOutputStream eOut = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(eOut));
            String eMsg = eOut.toString();
            this.log.warn("Failed to run script!\n=====\n{}\n=====", (Object)eMsg);
            messages.add("Script error: " + scriptName + "\n" + eMsg);
        }
        return scriptObject;
    }
}

