/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.sso;

import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.sso.SSOInterface;
import com.googlecode.fascinator.portal.sso.USQUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class USQSSO
implements SSOInterface {
    private Logger log = LoggerFactory.getLogger(USQSSO.class);
    private String remoteLogonURL = null;
    private String remoteLogonId;
    private String requestKey;
    private String responseKey;
    private String WS_DESTINATION = "https://usqauth.usq.edu.au/WSRemoteLogon.asmx?WSDL";
    private String WS_SOAP_ACTION = "SOAPAction";
    private String WS_LOGON_URI = "http://tempuri.org/USQ.eInterface2003/WSRemoteLogon/GetLogonURL";
    private String WS_USERDETAIL_URI = "http://tempuri.org/USQ.eInterface2003/WSRemoteLogon/GetUserDetailsFull";
    private String ENV_URI = "http://tempuri.org/USQ.eInterface2003/WSRemoteLogon";
    private String ENV_NS = "foo";
    private SOAPConnection connection;
    private SOAPMessage message;
    private SOAPEnvelope envelope;
    private SOAPBody messageBody;
    private SOAPMessage reply;
    private String linkText;

    @Override
    public String getId() {
        return "USQSSO";
    }

    @Override
    public String getLabel() {
        return "Login via UConnect";
    }

    @Override
    public String getInterface(String ssoUrl) {
        String html = "<a href=\"" + ssoUrl + "\">" + "<img title=\"" + this.getLabel() + "\" alt=\"" + this.getLabel() + "\" src=\"" + this.linkText + "\"/>" + "</a>";
        return html;
    }

    @Override
    public User getUserObject(JsonSessionState session) {
        String username = (String)session.get("usqSsoUsername");
        String fullname = (String)session.get("usqSsoFullName");
        String groups = (String)session.get("usqSsoGroups");
        if (username == null) {
            return null;
        }
        USQUser user = new USQUser();
        user.setUsername(username);
        user.setSource("USQSSO");
        user.set("fullName", fullname);
        user.set("groups", groups);
        return user;
    }

    @Override
    public void logout(JsonSessionState session) {
        session.remove("usqSsoFullName");
        session.remove("usqSsoRemoteLogonId");
        session.remove("usqSsoResponseKey");
        session.remove("usqSsoRequestKey");
        session.remove("usqSsoUsername");
        session.remove("usqSsoGroups");
        session.remove("usqSsoRemoteLogonURL");
    }

    @Override
    public void ssoInit(JsonSessionState session, HttpServletRequest request) throws Exception {
        String portalUrl = (String)session.get("ssoPortalUrl");
        this.linkText = portalUrl + "/images/UConnect.jpg";
    }

    @Override
    public void ssoPrepareLogin(JsonSessionState session, String returnAddress, String server) throws Exception {
        this.requestKey = this.getRequestKey(session);
        this.createMessage(this.WS_LOGON_URI);
        SOAPElement bodyElement = this.messageBody.addChildElement(this.envelope.createName("GetLogonURL", this.ENV_NS, this.ENV_URI));
        bodyElement.addChildElement(this.envelope.createName("ReturnURL", this.ENV_NS, this.ENV_URI)).addTextNode(returnAddress);
        bodyElement.addChildElement(this.envelope.createName("RequestKey", this.ENV_NS, this.ENV_URI)).addTextNode(this.requestKey);
        this.sendMessage();
        this.retrieveLogonResult(session, (Element)this.reply.getSOAPBody());
    }

    @Override
    public String ssoGetRemoteLogonURL(JsonSessionState session) {
        return this.remoteLogonURL;
    }

    @Override
    public void ssoCheckUserDetails(JsonSessionState session) {
        String username = (String)session.get("usqSsoUsername");
        if (username != null) {
            return;
        }
        this.remoteLogonId = (String)session.get("usqSsoRemoteLogonId");
        this.responseKey = (String)session.get("usqSsoResponseKey");
        this.requestKey = (String)session.get("usqSsoRequestKey");
        if (this.remoteLogonId == null || this.requestKey == null || this.responseKey == null) {
            return;
        }
        try {
            this.createMessage(this.WS_USERDETAIL_URI);
            SOAPElement bodyElement = this.messageBody.addChildElement(this.envelope.createName("GetUserDetailsFull", this.ENV_NS, this.ENV_URI));
            bodyElement.addChildElement(this.envelope.createName("RemoteLogonID", this.ENV_NS, this.ENV_URI)).addTextNode(this.remoteLogonId);
            bodyElement.addChildElement(this.envelope.createName("RequestKey", this.ENV_NS, this.ENV_URI)).addTextNode(this.requestKey);
            bodyElement.addChildElement(this.envelope.createName("ResponseKey", this.ENV_NS, this.ENV_URI)).addTextNode(this.responseKey);
            this.sendMessage();
            this.parseUserDetails(session, (Element)this.reply.getSOAPBody());
        }
        catch (Exception e) {
            this.log.error("Error retrieving user details from SSO Servivce", (Throwable)e);
            session.remove("usqSsoRemoteLogonId");
            session.remove("usqSsoResponseKey");
            session.remove("usqSsoRequestKey");
        }
    }

    private void retrieveLogonResult(JsonSessionState session, Element body) {
        Element response = (Element)body.getElementsByTagName("GetLogonURLResponse").item(0);
        Element result = (Element)response.getElementsByTagName("GetLogonURLResult").item(0);
        this.remoteLogonURL = this.readValue(result, "URL");
        this.remoteLogonId = this.remoteLogonURL.substring(this.remoteLogonURL.indexOf("USQRLID=") + 8);
        this.responseKey = this.readValue(result, "ResponseKey");
        session.set("usqSsoRemoteLogonURL", this.remoteLogonURL);
        session.set("usqSsoRemoteLogonId", this.remoteLogonId);
        session.set("usqSsoResponseKey", this.responseKey);
    }

    private void parseUserDetails(JsonSessionState session, Element body) {
        Element response = (Element)body.getElementsByTagName("GetUserDetailsFullResponse").item(0);
        Element result = (Element)response.getElementsByTagName("GetUserDetailsFullResult").item(0);
        String username = this.readValue(result, "UserID");
        String fullname = this.readValue(result, "FullName");
        String groups = this.readValue(result, "Groups");
        session.set("usqSsoUsername", username);
        session.set("usqSsoFullName", fullname);
        session.set("usqSsoGroups", groups);
    }

    private void debugResponse(Node node, String prefix) {
        this.log.debug(prefix + "'{}' : '{}'", (Object)node.getNodeName(), (Object)node.getNodeValue());
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int count = children.getLength();
            for (int i = 0; i < count; ++i) {
                this.debugResponse(children.item(i), prefix + "'" + node.getNodeName() + "' > ");
            }
        }
    }

    private String readValue(Element root, String tag) {
        if (root == null) {
            return null;
        }
        Node n = root.getElementsByTagName(tag).item(0);
        if (n != null && (n = n.getFirstChild()) != null) {
            return n.getNodeValue();
        }
        return null;
    }

    private void createMessage(String soapAction) throws Exception {
        SOAPConnectionFactory soapFactory = SOAPConnectionFactory.newInstance();
        this.connection = soapFactory.createConnection();
        MessageFactory messageFactory = MessageFactory.newInstance();
        this.message = messageFactory.createMessage();
        this.message.getMimeHeaders().addHeader(this.WS_SOAP_ACTION, soapAction);
        this.envelope = this.message.getSOAPPart().getEnvelope();
        this.messageBody = this.envelope.getBody();
    }

    private void sendMessage() throws Exception {
        this.message.saveChanges();
        this.reply = this.connection.call(this.message, (Object)this.WS_DESTINATION);
        this.connection.close();
    }

    private String getRequestKey(JsonSessionState session) {
        String key = (String)session.get("usqSsoRequestKey");
        if (key == null) {
            key = Long.toHexString(Thread.currentThread().getId()) + Long.toHexString(new Date().getTime());
            session.set("usqSsoRequestKey", key);
        }
        return key;
    }

    @Override
    public List<String> getRolesList(JsonSessionState session) {
        String groups = (String)session.get("usqSsoGroups");
        String[] groupArr = groups.toUpperCase().split(",");
        ArrayList<String> cleaned = new ArrayList<String>();
        for (String s : groupArr) {
            if ((s = s.trim()).length() <= 0) continue;
            cleaned.add(s);
        }
        return cleaned;
    }
}

