/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.quartz;

import com.googlecode.fascinator.HarvestClient;
import com.googlecode.fascinator.api.PluginException;
import java.io.File;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvestJob
implements StatefulJob {
    private Logger log = LoggerFactory.getLogger(HarvestJob.class);
    private String name;
    private HarvestClient harvester;
    private File config;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.name = context.getJobDetail().getName();
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String configFile = dataMap.getString("configFile");
        if (configFile == null) {
            this.log.error("No configuration provided");
            return;
        }
        this.config = new File(configFile);
        if (this.config == null || !this.config.exists()) {
            this.log.error("Error finding config file: '{}'", (Object)configFile);
            return;
        }
        try {
            this.harvester = new HarvestClient(this.config);
        }
        catch (PluginException pe) {
            this.log.error("Failed to initialise harvester: ", (Throwable)pe);
            return;
        }
        this.runJob();
    }

    private void runJob() {
        this.log.info("========================================");
        this.log.info("Executing harvest job: '{}'", (Object)this.name);
        try {
            this.harvester.start();
        }
        catch (PluginException pe) {
            this.log.error("Error during harvest: ", (Throwable)pe);
        }
        this.log.info("Completed harvest job: '{}'", (Object)this.name);
        this.log.info("========================================");
    }
}

