/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.api.access.AccessControlManager;
import com.googlecode.fascinator.api.authentication.AuthManager;
import com.googlecode.fascinator.api.authentication.AuthenticationException;
import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.api.roles.RolesManager;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.authentication.GenericUser;
import com.googlecode.fascinator.portal.FormData;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.services.PortalSecurityManager;
import com.googlecode.fascinator.portal.sso.SSOInterface;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalSecurityManagerImpl
implements PortalSecurityManager {
    private static String SSO_STORAGE_PREFIX = "ssoStoredParam_";
    private static String TRUST_TOKEN_PREFIX = "TrustToken_";
    private static String TRUST_TOKEN_EXPIRY = "600";
    private Logger log = LoggerFactory.getLogger(PortalSecurityManagerImpl.class);
    private String SSO_LOGIN_PAGE = "/sso";
    private FormData formData;
    @Inject
    private AccessControlManager accessManager;
    @Inject
    private AuthManager authManager;
    @Inject
    private RolesManager roleManager;
    @Inject
    private Request request;
    @Inject
    private Response response;
    @Inject
    private RequestGlobals rg;
    private JsonSimpleConfig config = new JsonSimpleConfig();
    private Map<String, SSOInterface> sso = new LinkedHashMap();
    private String serverUrlBase;
    private String defaultPortal;
    private String ssoLoginUrl;
    private Pattern detailPattern;
    private List<String> excStarts;
    private List<String> excEnds;
    private List<String> excEquals;
    private Map<String, String> tokens;
    private Map<String, Long> tokenExpiry;

    public PortalSecurityManagerImpl() throws IOException {
        for (String ssoId : this.config.getStringList(new Object[]{"sso", "plugins"})) {
            SSOInterface valid = this.getSSOProvider(ssoId);
            if (valid == null) {
                this.log.error("Invalid SSO Implementation requested: '{}'", (Object)ssoId);
                continue;
            }
            this.sso.put(ssoId, valid);
            this.log.info("SSO Provider instantiated: '{}'", (Object)ssoId);
        }
        this.defaultPortal = this.config.getString("default", new Object[]{"portal", "defaultView"});
        this.serverUrlBase = this.config.getString(null, new Object[]{"urlBase"});
        this.ssoLoginUrl = this.serverUrlBase + this.defaultPortal + this.SSO_LOGIN_PAGE;
        this.excStarts = this.config.getStringList(new Object[]{"sso", "urlExclusions", "startsWith"});
        this.excEnds = this.config.getStringList(new Object[]{"sso", "urlExclusions", "endsWith"});
        this.excEquals = this.config.getStringList(new Object[]{"sso", "urlExclusions", "equals"});
        Map tokenMap = this.config.getJsonSimpleMap(new Object[]{"sso", "trustTokens"});
        this.tokens = new HashMap();
        this.tokenExpiry = new HashMap();
        for (String key : tokenMap.keySet()) {
            JsonSimple tok = (JsonSimple)tokenMap.get(key);
            String publicKey = tok.getString(null, new Object[]{"publicKey"});
            String privateKey = tok.getString(null, new Object[]{"privateKey"});
            String expiry = tok.getString(TRUST_TOKEN_EXPIRY, new Object[]{"expiry"});
            if (publicKey != null && privateKey != null) {
                this.tokens.put(publicKey, privateKey);
                this.tokenExpiry.put(publicKey, Long.valueOf(expiry));
                continue;
            }
            this.log.error("Invalid token data: '{}'", (Object)key);
        }
    }

    private SSOInterface getSSOProvider(String id) {
        ServiceLoader<SSOInterface> providers = ServiceLoader.load(SSOInterface.class);
        for (SSOInterface provider : providers) {
            if (!id.equals(provider.getId())) continue;
            return provider;
        }
        return null;
    }

    public AccessControlManager getAccessControlManager() {
        return this.accessManager;
    }

    public AuthManager getAuthManager() {
        return this.authManager;
    }

    public RolesManager getRoleManager() {
        return this.roleManager;
    }

    public String[] getRolesList(JsonSessionState session, User user) {
        String[] standardRoles;
        String source = user.getSource();
        ArrayList<String> ssoRoles = new ArrayList<String>();
        if (this.sso.containsKey(source)) {
            ssoRoles.addAll(((SSOInterface)this.sso.get(source)).getRolesList(session));
        }
        GenericUser gUser = (GenericUser)user;
        for (String role : standardRoles = this.roleManager.getRoles(gUser.getUsername())) {
            if (ssoRoles.contains(role)) continue;
            ssoRoles.add(role);
        }
        return ssoRoles.toArray(standardRoles);
    }

    public User getUser(JsonSessionState session, String username, String source) throws AuthenticationException {
        if (username == null || username.equals("") || source == null || source.equals("")) {
            throw new AuthenticationException("Invalid user data requested");
        }
        if (this.sso.containsKey(source)) {
            GenericUser user = (GenericUser)((SSOInterface)this.sso.get(source)).getUserObject(session);
            if (user == null || !user.getUsername().equals(username)) {
                throw new AuthenticationException("Unknown user '" + username + "'");
            }
            return user;
        }
        if (source.startsWith(TRUST_TOKEN_PREFIX)) {
            String sUsername = (String)session.get("username");
            String sSource = (String)session.get("source");
            if (sUsername == null || !username.equals(sUsername) || sSource == null || !source.equals(sSource)) {
                throw new AuthenticationException("Unknown user '" + username + "'");
            }
            GenericUser user = new GenericUser();
            user.setUsername(username);
            user.setSource(source);
            return user;
        }
        this.authManager.setActivePlugin(source);
        return this.authManager.getUser(username);
    }

    public void logout(JsonSessionState session, User user) throws AuthenticationException {
        String source = user.getSource();
        session.remove((Object)"username");
        session.remove((Object)"source");
        if (this.sso.containsKey(source)) {
            ((SSOInterface)this.sso.get(source)).logout(session);
            return;
        }
        if (source.startsWith(TRUST_TOKEN_PREFIX)) {
            session.remove((Object)"validToken");
            return;
        }
        this.authManager.logOut(user);
    }

    public boolean runSsoIntegration(JsonSessionState session, FormData formData) {
        this.formData = formData;
        String returnUrl = this.request.getParameter("returnUrl");
        if (returnUrl != null) {
            this.log.info("External redirect requested: '{}'", (Object)returnUrl);
            session.set("ssoReturnUrl", (Object)returnUrl);
        }
        String utoken = this.request.getParameter("token");
        String stoken = (String)session.get("validToken");
        String token = null;
        if (stoken != null) {
            token = stoken;
        }
        if (utoken != null) {
            token = utoken;
        }
        if (token != null) {
            if (this.testTrustToken(session, token)) {
                return false;
            }
            try {
                this.response.sendError(403, "Invalid or expired security token!");
            }
            catch (IOException ex) {
                this.log.error("Error sending 403 response to client!");
            }
            return true;
        }
        try {
            String ssoId = this.ssoInit(session);
            if (ssoId != null) {
                String ssoUrl = this.ssoGetRemoteLogonURL(session, ssoId);
                if (ssoUrl != null) {
                    this.log.info("Redirect to external URL: '{}'", (Object)ssoUrl);
                    this.response.sendRedirect(ssoUrl);
                    return true;
                }
            } else {
                boolean valid = this.ssoCheckUserDetails(session);
                if (valid && (returnUrl = (String)session.get("ssoReturnUrl")) != null) {
                    this.log.info("Redirect to external URL: '{}'", (Object)returnUrl);
                    session.remove((Object)"ssoReturnUrl");
                    this.response.sendRedirect(returnUrl);
                    return true;
                }
            }
        }
        catch (Exception ex) {
            this.log.error("SSO Error!", (Throwable)ex);
        }
        return false;
    }

    public String ssoInit(JsonSessionState session) throws Exception {
        String returnAddress;
        String portalId = (String)session.get("portalId", (Object)this.defaultPortal);
        this.ssoLoginUrl = this.serverUrlBase + portalId + this.SSO_LOGIN_PAGE;
        String path = this.request.getAttribute("RequestURI").toString();
        String currentAddress = this.serverUrlBase + path;
        session.set("ssoPortalUrl", (Object)(this.serverUrlBase + portalId));
        for (String ssoId : this.sso.keySet()) {
            ((SSOInterface)this.sso.get(ssoId)).ssoInit(session, this.rg.getHTTPServletRequest());
        }
        String ssoId = this.request.getParameter("ssoId");
        if (!currentAddress.contains(this.SSO_LOGIN_PAGE)) {
            session.set("returnAddress", (Object)currentAddress);
            if (ssoId == null) {
                return null;
            }
            for (String param : this.request.getParameterNames()) {
                if (param.equals("ssoId")) continue;
                session.set(SSO_STORAGE_PREFIX + param, (Object)this.request.getParameter(param));
            }
        }
        if ((returnAddress = (String)session.get("returnAddress")) == null) {
            returnAddress = this.serverUrlBase + portalId + "/home";
        }
        if (ssoId == null) {
            this.log.error("==== SSO: SSO ID not found!");
            return null;
        }
        if (!this.sso.containsKey(ssoId)) {
            this.log.error("==== SSO: SSO ID invalid: '{}'!", (Object)ssoId);
            return null;
        }
        ((SSOInterface)this.sso.get(ssoId)).ssoPrepareLogin(session, returnAddress, this.serverUrlBase);
        return ssoId;
    }

    public boolean ssoCheckUserDetails(JsonSessionState session) {
        String[] oldParams;
        List currentParams = this.request.getParameterNames();
        for (String key : oldParams = session.keySet().toArray(new String[0])) {
            String oldParam;
            if (!key.startsWith(SSO_STORAGE_PREFIX) || currentParams.contains(oldParam = key.replace(SSO_STORAGE_PREFIX, ""))) continue;
            String data = (String)session.get(key);
            this.formData.set(oldParam, data);
            session.remove((Object)key);
        }
        for (String ssoId : this.sso.keySet()) {
            ((SSOInterface)this.sso.get(ssoId)).ssoCheckUserDetails(session);
            GenericUser user = (GenericUser)((SSOInterface)this.sso.get(ssoId)).getUserObject(session);
            if (user == null) continue;
            session.set("username", (Object)user.getUsername());
            session.set("source", (Object)ssoId);
            return true;
        }
        return false;
    }

    public Map<String, Map<String, String>> ssoBuildLogonInterface(JsonSessionState session) {
        LinkedHashMap<String, Map<String, String>> ssoInterface = new LinkedHashMap<String, Map<String, String>>();
        for (String ssoId : this.sso.keySet()) {
            SSOInterface provider = (SSOInterface)this.sso.get(ssoId);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("label", provider.getLabel());
            map.put("interface", provider.getInterface(this.ssoLoginUrl + "?ssoId=" + ssoId));
            ssoInterface.put(ssoId, map);
        }
        return ssoInterface;
    }

    public String ssoGetRemoteLogonURL(JsonSessionState session, String source) {
        if (!this.sso.containsKey(source)) {
            return null;
        }
        return ((SSOInterface)this.sso.get(source)).ssoGetRemoteLogonURL(session);
    }

    public boolean testForSso(JsonSessionState session, String resource, String uri) {
        String ssoId = this.request.getParameter("ssoId");
        if (ssoId != null) {
            return true;
        }
        String utoken = this.request.getParameter("token");
        String stoken = (String)session.get("validToken");
        if (utoken != null || stoken != null) {
            return true;
        }
        for (String test : this.excStarts) {
            if (!resource.startsWith(test)) continue;
            return false;
        }
        for (String test : this.excEnds) {
            if (!resource.endsWith(test)) continue;
            return false;
        }
        for (String test : this.excEquals) {
            if (!resource.equals(test)) continue;
            return false;
        }
        String returnAddress = (String)session.get("returnAddress");
        if (returnAddress != null && returnAddress.endsWith(uri)) {
            return true;
        }
        if (resource.equals("detail") || resource.equals("download") || resource.equals("preview")) {
            if (resource.equals("detail")) {
                Matcher matcher;
                if (this.detailPattern == null) {
                    this.detailPattern = Pattern.compile("detail/\\w+/*$");
                }
                if ((matcher = this.detailPattern.matcher(uri)).find()) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public boolean testTrustToken(JsonSessionState session, String token) {
        String[] parts = StringUtils.split((String)token, (String)":");
        if (parts.length != 4) {
            this.log.error("TOKEN: Should have 4 parts, not {} : '{}'", (Object)parts.length, (Object)token);
            return false;
        }
        String username = parts[0];
        String timestamp = parts[1];
        String publicKey = parts[2];
        String userToken = parts[3];
        if (username.isEmpty() || timestamp.isEmpty() || publicKey.isEmpty() || userToken.isEmpty()) {
            this.log.error("TOKEN: One or more parts are empty : '{}'", (Object)token);
            return false;
        }
        if (!this.tokens.containsKey(publicKey)) {
            this.log.error("TOKEN: Invalid public key : '{}'", (Object)publicKey);
            return false;
        }
        String privateKey = (String)this.tokens.get(publicKey);
        Long expiry = (Long)this.tokenExpiry.get(publicKey);
        if ((timestamp = this.getFormattedTime(timestamp)) == null) {
            this.log.error("TOKEN: Invalid timestamp : '{}'", (Object)timestamp);
            return false;
        }
        Long tokenTime = Long.valueOf(timestamp);
        Long currentTime = Long.valueOf(this.getFormattedTime(null));
        Long age = currentTime - tokenTime;
        if (age > expiry) {
            this.log.error("Token is passed its expiry : {}s old", (Object)age);
            return false;
        }
        String tokenSeed = username + ":" + timestamp + ":" + privateKey;
        String expectedToken = DigestUtils.md5Hex((String)tokenSeed);
        if (userToken.equals(expectedToken)) {
            session.set("username", (Object)username);
            session.set("source", (Object)(TRUST_TOKEN_PREFIX + publicKey));
            session.set("validToken", (Object)token);
            return true;
        }
        this.log.error("TOKEN: Invalid token, hash does not match: '{}'", (Object)userToken);
        return false;
    }

    private String getFormattedTime(String input) {
        Date dateData;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        if (input == null) {
            dateData = new Date();
        } else {
            try {
                dateData = dateFormat.parse(input);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return dateFormat.format(dateData);
    }
}

