/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.api.Plugin;
import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.IndexerException;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.messaging.MessagingException;
import com.googlecode.fascinator.common.messaging.MessagingServices;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.services.IndexerService;
import java.io.File;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ApplicationStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerServiceImpl
implements IndexerService {
    private static final String DEFAULT_INDEXER_TYPE = "solr";
    @Inject
    private JsonSessionState sessionState;
    private String username;
    private MessagingServices messaging;
    private Logger log = LoggerFactory.getLogger(IndexerServiceImpl.class);
    private Indexer indexer;

    public IndexerServiceImpl(Indexer indexer, ApplicationStateManager asm) {
        if (this.sessionState == null) {
            this.sessionState = (JsonSessionState)asm.get(JsonSessionState.class);
        }
        this.username = (String)this.sessionState.get("username");
        try {
            this.messaging = MessagingServices.getInstance();
        }
        catch (MessagingException ex) {
            this.log.error("Failed to start connection: {}", (Object)ex.getMessage());
        }
        if (indexer == null) {
            try {
                JsonSimpleConfig config = new JsonSimpleConfig();
                indexer = PluginManager.getIndexer((String)config.getString(DEFAULT_INDEXER_TYPE, new Object[]{"indexer", "type"}));
                indexer.init(JsonSimpleConfig.getSystemFile());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.indexer = indexer;
    }

    public void index(String oid) throws IndexerException {
        this.sentMessage(oid, "modify");
        this.indexer.index(oid);
    }

    public void index(String oid, String pid) throws IndexerException {
        this.sentMessage(oid, "modify");
        this.indexer.index(oid, pid);
    }

    public void commit() {
        this.indexer.commit();
    }

    public void annotate(String oid, String pid) throws IndexerException {
        this.sentMessage(oid, "modify-anotar");
        this.indexer.annotate(oid, pid);
    }

    public void annotateSearch(SearchRequest request, OutputStream result) throws IndexerException {
        this.indexer.annotateSearch(request, result);
    }

    public void annotateRemove(String oid) throws IndexerException {
        this.sentMessage(oid, "delete-anotar");
        this.indexer.annotateRemove(oid);
    }

    public void annotateRemove(String oid, String pid) throws IndexerException {
        this.sentMessage(oid, "delete-anotar");
        this.indexer.annotateRemove(oid, pid);
    }

    public void remove(String oid) throws IndexerException {
        this.sentMessage(oid, "delete");
        this.indexer.remove(oid);
    }

    public void remove(String oid, String pid) throws IndexerException {
        this.sentMessage(oid, "delete");
        this.indexer.remove(oid, pid);
    }

    public void search(SearchRequest request, OutputStream result) throws IndexerException {
        this.indexer.search(request, result);
    }

    public String getId() {
        return this.indexer.getId();
    }

    public String getName() {
        return this.indexer.getName();
    }

    public PluginDescription getPluginDetails() {
        return new PluginDescription((Plugin)this);
    }

    public void init(File jsonFile) throws PluginException {
        this.indexer.init(jsonFile);
    }

    public void shutdown() throws PluginException {
        this.indexer.shutdown();
    }

    public void init(String jsonString) throws PluginException {
        this.indexer.init(jsonString);
    }

    private void sentMessage(String oid, String eventType) {
        this.log.info(" * Sending message: {} with event {}", (Object)oid, (Object)eventType);
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put("oid", oid);
        param.put("eventType", eventType);
        param.put("username", this.username);
        param.put("context", this.indexer.getName());
        try {
            this.messaging.onEvent(param);
        }
        catch (MessagingException ex) {
            this.log.error("Error sending message: ", (Throwable)ex);
        }
    }

    public void searchByIndex(SearchRequest request, OutputStream response, String indexName) throws IndexerException {
        this.indexer.searchByIndex(request, response, indexName);
    }

    public void search(SearchRequest request, OutputStream result, String format) throws IndexerException {
        this.indexer.search(request, result, format);
    }
}

