/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.velocity;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonLogger
extends OutputStream {
    private Logger log = LoggerFactory.getLogger(JythonLogger.class);
    private Logger jythonLogger;
    private boolean dirty;
    private StringBuilder buffer;

    public JythonLogger(String name) {
        String packageName = this.getClass().getPackage().getName();
        String scriptName = StringUtils.substringBetween((String)name, (String)"scripts/", (String)".py");
        scriptName = scriptName.replace("/", "$") + "$py";
        this.jythonLogger = LoggerFactory.getLogger((String)(packageName + "." + scriptName));
        this.dirty = false;
        this.buffer = new StringBuilder();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void flush() throws IOException {
        if (this.dirty) {
            this.jythonLogger.debug("{}", (Object)this.buffer.toString());
            this.dirty = false;
            this.buffer = new StringBuilder();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (b == 13 || b == 10) {
            this.dirty = true;
            this.flush();
        } else {
            this.buffer.append((char)b);
        }
    }
}

