/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.api.impl;

import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.portal.api.APICallHandler;
import com.googlecode.fascinator.portal.api.impl.MintStatsAPICallHandlerImpl;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.tapestry5.services.Request;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MintStatsAPICallHandlerImpl
implements APICallHandler {
    private ScriptingServices scriptingServices;
    private HashMap<String, Stat> statMap;
    private JsonSimple config;
    private String strDateFormat = "dd/MM/yyyy";
    private String solrDateFormat = "yyyy-MM-dd";
    private Logger log = LoggerFactory.getLogger(MintStatsAPICallHandlerImpl.class);

    public JsonSimple getConfig() {
        return this.config;
    }

    public void setConfig(JsonSimple config) {
        this.config = config;
    }

    private void init() {
        this.log.debug("Initializing MintStatsAPICallHandlerImpl...");
        this.statMap = new HashMap();
        JsonObject jsonStat = this.config.getObject(new Object[]{"stats"});
        if (jsonStat != null) {
            this.log.debug(jsonStat.toJSONString());
            String name = (String)jsonStat.get((Object)"name");
            String query = (String)jsonStat.get((Object)"query");
            List fq = this.config.getStringList(new Object[]{"stats", "params", "fq"});
            String rows = this.config.getString("0", new Object[]{"stats", "params", "rows"});
            Stat stat = new Stat(this, name, query, fq, rows);
            this.statMap.put(name, stat);
            JSONArray fieldsArray = this.config.getArray(new Object[]{"stats", "fields"});
            for (Object fieldObj : fieldsArray) {
                JsonObject field = (JsonObject)fieldObj;
                String resultName = (String)field.get((Object)"name");
                String label = (String)field.get((Object)"label");
                String solr_field = (String)field.get((Object)"solr_field");
                String solr_field_value = (String)field.get((Object)"solr_field_value");
                StatResult result = new StatResult(this, resultName + "-" + solr_field_value, resultName, label, solr_field, solr_field_value);
                String groupBy = (String)field.get((Object)"groupby");
                result.setGroupBy(groupBy);
                stat.addResult(result);
            }
        }
        this.log.debug("Initialized MintStatsAPICallHandlerImpl.");
    }

    public String handleRequest(Request request) throws Exception {
        String appendFilter;
        if (this.statMap == null) {
            this.init();
        }
        appendFilter = (appendFilter = request.getParameter("appendFilter")) == null ? "" : " AND " + appendFilter;
        Indexer indexer = this.scriptingServices.getIndexer();
        block0: for (String key : this.statMap.keySet()) {
            Stat stat = (Stat)this.statMap.get(key);
            stat.resetCounts();
            String query = stat.getQuery() + appendFilter;
            this.log.debug("Using query:" + query);
            SearchRequest solrReq = new SearchRequest(query);
            int start = 0;
            int pageSize = Integer.valueOf(stat.getRows());
            solrReq.setParam("fq", (Collection)stat.getFq());
            solrReq.setParam("rows", "" + pageSize);
            solrReq.setParam("start", "" + start);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            indexer.search(solrReq, (OutputStream)result);
            SolrResult resultObject = new SolrResult((InputStream)new ByteArrayInputStream(result.toByteArray()));
            int numFound = resultObject.getNumFound();
            stat.setResultCount("mint-total-", numFound);
            this.log.debug("numFound:" + numFound);
            while (numFound > 0) {
                List results = resultObject.getResults();
                for (SolrDoc docObject : results) {
                    for (String resName : stat.getResultsByName().keySet()) {
                        StatResult statRes = stat.getResultByName(resName);
                        String solrFld = statRes.getSolrField();
                        String value = docObject.getString(null, new Object[]{solrFld});
                        if (solrFld.equals("numFound")) continue;
                        if (value == null) {
                            JSONArray valueArr = docObject.getArray(new Object[]{solrFld});
                            if (valueArr != null) {
                                value = (String)valueArr.get(0);
                            } else {
                                this.log.error("Value not found for solr field:" + solrFld);
                            }
                        }
                        if (resName.indexOf(":") > 0) {
                            if (!statRes.getSolrFieldValue().equalsIgnoreCase(value)) continue;
                            String groupBy = statRes.getGroupBy();
                            String uniqueVal = docObject.getString(null, new Object[]{groupBy});
                            if (uniqueVal == null) {
                                JSONArray valueArr = docObject.getArray(new Object[]{groupBy});
                                if (valueArr != null) {
                                    uniqueVal = (String)valueArr.get(0);
                                } else {
                                    this.log.error("Value not found for group by field:" + groupBy);
                                }
                            }
                            Integer curCountObj = (Integer)stat.getResultByName(resName).getGroupMap().get(uniqueVal);
                            int curCount = 0;
                            if (curCountObj != null) {
                                curCount = curCountObj;
                            }
                            stat.getResultByName(resName).setGroupValues(uniqueVal, new Integer(++curCount));
                            continue;
                        }
                        String resultKey = resName + "-" + value;
                        statRes = (StatResult)stat.getResults().get(resultKey);
                        if (statRes == null) continue;
                        statRes.incCounts();
                    }
                }
                if ((start += pageSize) > numFound) continue block0;
                solrReq.setParam("start", "" + start);
                result = new ByteArrayOutputStream();
                indexer.search(solrReq, (OutputStream)result);
                resultObject = new SolrResult((InputStream)new ByteArrayInputStream(result.toByteArray()));
            }
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        for (String statKey : this.statMap.keySet()) {
            this.log.debug("For stat key: " + statKey);
            Stat stat = (Stat)this.statMap.get(statKey);
            for (String resKey : stat.getResults().keySet()) {
                StatResult statRes = (StatResult)stat.getResults().get(resKey);
                if (statRes.getName().indexOf(":") > 0) {
                    resMap.put(statRes.getLabel(), new ArrayList(statRes.getGroupList()));
                    HashMap<String, String> groupMap = new HashMap<String, String>();
                    for (String valKey : statRes.getGroupMap().keySet()) {
                        groupMap.put(valKey, ((Integer)statRes.getGroupMap().get(valKey)).toString());
                    }
                    resMap.put(statRes.getLabel() + "counts", groupMap);
                } else {
                    resMap.put(statRes.getLabel(), String.valueOf(statRes.getCounts()));
                }
                this.log.debug("Result label:" + statRes.getLabel() + " has counts: " + statRes.getCounts());
            }
        }
        return new JsonObject(resMap).toJSONString();
    }

    public void setScriptingServices(ScriptingServices scriptingServices) {
        this.scriptingServices = scriptingServices;
    }
}

