/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.api.impl;

import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.portal.api.APICallHandler;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.services.Request;

public class PublishedRecordsByTypeAPICallHandlerImpl
implements APICallHandler {
    private ScriptingServices scriptingServices;

    public String handleRequest(Request request) throws Exception {
        String dateFromString = request.getParameter("dateFrom");
        String dateToString = request.getParameter("dateTo");
        Indexer indexer = this.scriptingServices.getIndexer();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        String query = "published:true";
        SearchRequest searchRequest = new SearchRequest(query);
        int start = 0;
        int pageSize = 10;
        searchRequest.setParam("start", "" + start);
        searchRequest.setParam("rows", "" + pageSize);
        indexer.search(searchRequest, (OutputStream)result);
        SolrResult resultObject = new SolrResult(result.toString());
        int numFound = resultObject.getNumFound();
        HashMap<String, String> publishedOidMap = new HashMap<String, String>();
        while (true) {
            List results = resultObject.getResults();
            for (SolrDoc docObject : results) {
                publishedOidMap.put(docObject.get("storage_id"), (String)docObject.getArray(new Object[]{"oai_set"}).toArray()[0]);
            }
            if ((start += pageSize) > numFound) break;
            searchRequest.setParam("start", "" + start);
            result = new ByteArrayOutputStream();
            indexer.search(searchRequest, (OutputStream)result);
            resultObject = new SolrResult(result.toString());
        }
        HashMap<String, Integer> typeCountMap = new HashMap<String, Integer>();
        typeCountMap.put("Activities", 0);
        typeCountMap.put("Parties_People", 0);
        typeCountMap.put("Parties", 0);
        typeCountMap.put("Services", 0);
        if (publishedOidMap.size() > 0) {
            Set publishedOids = publishedOidMap.keySet();
            String eventLogQuery = "oid:(";
            int i = 0;
            for (String publishedOid : publishedOids) {
                eventLogQuery = eventLogQuery + publishedOid;
                if (i < publishedOidMap.size() - 1) {
                    eventLogQuery = eventLogQuery + " OR ";
                }
                ++i;
            }
            eventLogQuery = eventLogQuery + ")";
            eventLogQuery = eventLogQuery + "AND eventTime:[" + dateFromString + "T00:00:00.000Z TO " + dateToString + "T23:59:59.999Z] AND eventType:modify AND context:HarvestClient";
            searchRequest = new SearchRequest(eventLogQuery);
            result = new ByteArrayOutputStream();
            start = 0;
            pageSize = 10;
            searchRequest.setParam("start", "" + start);
            searchRequest.setParam("rows", "" + pageSize);
            indexer.searchByIndex(searchRequest, (OutputStream)result, "eventLog");
            resultObject = new SolrResult(result.toString());
            numFound = resultObject.getNumFound();
            while (true) {
                List results = resultObject.getResults();
                for (SolrDoc docObject : results) {
                    String oid = docObject.getString(null, new Object[]{"oid"});
                    if (oid == null) continue;
                    int count = (Integer)typeCountMap.get(publishedOidMap.get(oid));
                    typeCountMap.put((String)publishedOidMap.get(oid), ++count);
                }
                if ((start += pageSize) > numFound) break;
                searchRequest.setParam("start", "" + start);
                result = new ByteArrayOutputStream();
                indexer.search(searchRequest, (OutputStream)result);
                resultObject = new SolrResult(result.toString());
            }
        }
        return new JsonObject(typeCountMap).toJSONString();
    }

    public void setScriptingServices(ScriptingServices scriptingServices) {
        this.scriptingServices = scriptingServices;
    }
}

