/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal;

import com.googlecode.fascinator.portal.Page;
import java.util.ArrayList;
import java.util.List;

public class Pagination {
    private int page;
    private int totalFound;
    private int startNum;
    private int endNum;
    private int lastPage;
    private List<Page> pages;

    public Pagination(int page, int totalFound, int numPerPage) {
        this.page = page;
        this.totalFound = totalFound;
        this.lastPage = totalFound / numPerPage;
        if (totalFound % numPerPage > 0) {
            ++this.lastPage;
        }
        int startPage = page - 5;
        if (page < 8) {
            startPage = 1;
        } else if (this.lastPage - page < 7) {
            startPage = Math.max(this.lastPage - 10, 1);
        }
        int endPage = Math.min(this.lastPage, startPage + 10);
        this.pages = new ArrayList<Page>();
        for (int i = startPage; i < endPage + 1; ++i) {
            Page p = new Page(i, page, totalFound, numPerPage);
            this.pages.add(p);
            if (!p.isSelected()) continue;
            this.startNum = p.getStart();
            this.endNum = p.getEnd();
        }
    }

    public boolean hasPrevious() {
        return this.page > 0;
    }

    public boolean hasNext() {
        return this.page < this.lastPage - 1;
    }

    public int getPage() {
        return this.page;
    }

    public int getTotalFound() {
        return this.totalFound;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public int getStartNum() {
        return this.startNum;
    }

    public int getEndNum() {
        return this.endNum;
    }

    public List<Page> getPages() {
        return this.pages;
    }
}

