/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.api.impl;

import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.portal.api.APICallHandler;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.services.Request;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MintStatsAPICallHandlerImpl
implements APICallHandler {
    private ScriptingServices scriptingServices;
    private HashMap<String, Stat> statMap;
    private JsonSimple config;
    private String strDateFormat = "dd/MM/yyyy";
    private String solrDateFormat = "yyyy-MM-dd";
    private Logger log = LoggerFactory.getLogger(MintStatsAPICallHandlerImpl.class);

    public JsonSimple getConfig() {
        return this.config;
    }

    public void setConfig(JsonSimple config) {
        this.config = config;
    }

    private void init() {
        this.log.debug("Initializing MintStatsAPICallHandlerImpl...");
        this.statMap = new HashMap();
        JsonObject jsonStat = this.config.getObject(new Object[]{"stats"});
        if (jsonStat != null) {
            this.log.debug(jsonStat.toJSONString());
            String name = (String)jsonStat.get((Object)"name");
            String query = (String)jsonStat.get((Object)"query");
            List fq = this.config.getStringList(new Object[]{"stats", "params", "fq"});
            String rows = this.config.getString("0", new Object[]{"stats", "params", "rows"});
            Stat stat = new Stat(name, query, fq, rows);
            this.statMap.put(name, stat);
            JSONArray fieldsArray = this.config.getArray(new Object[]{"stats", "fields"});
            for (Object fieldObj : fieldsArray) {
                JsonObject field = (JsonObject)fieldObj;
                String resultName = (String)field.get((Object)"name");
                String label = (String)field.get((Object)"label");
                String solr_field = (String)field.get((Object)"solr_field");
                String solr_field_value = (String)field.get((Object)"solr_field_value");
                StatResult result = new StatResult(resultName + "-" + solr_field_value, resultName, label, solr_field, solr_field_value);
                String groupBy = (String)field.get((Object)"groupby");
                result.setGroupBy(groupBy);
                stat.addResult(result);
            }
        }
        this.log.debug("Initialized MintStatsAPICallHandlerImpl.");
    }

    @Override
    public String handleRequest(Request request) throws Exception {
        if (this.statMap == null) {
            this.init();
        }
        String customQuery = null;
        String dateFromString = request.getParameter("dateFrom");
        String dateToString = request.getParameter("dateTo");
        Indexer indexer = this.scriptingServices.getIndexer();
        if ("true".equals(request.getParameter("published"))) {
            customQuery = "context:\"Curation\" AND eventType:\"Curation completed.\" AND eventTime:[" + dateFromString + "T00:00:00.000Z TO " + dateToString + "T23:59:59.999Z]";
            int start = 0;
            int pageSize = 10;
            HashSet<String> publishedOidSet = new HashSet<String>();
            SearchRequest searchRequest = new SearchRequest(customQuery);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            searchRequest.setParam("start", "" + start);
            searchRequest.setParam("rows", "" + pageSize);
            indexer.searchByIndex(searchRequest, (OutputStream)result, "eventLog");
            SolrResult resultObject = new SolrResult(result.toString());
            int numFound = resultObject.getNumFound();
            while (true) {
                List results = resultObject.getResults();
                for (SolrDoc docObject : results) {
                    String oid = docObject.getString(null, new Object[]{"oid"});
                    if (oid == null) continue;
                    publishedOidSet.add(oid);
                }
                if ((start += pageSize) > numFound) break;
                searchRequest.setParam("start", "" + start);
                result = new ByteArrayOutputStream();
                indexer.searchByIndex(searchRequest, (OutputStream)result, "eventLog");
                resultObject = new SolrResult(result.toString());
            }
            StringBuilder query = new StringBuilder();
            query.append("id:(");
            if (publishedOidSet.size() > 0) {
                for (String publishedOid : publishedOidSet) {
                    if (query.length() > 4) {
                        query.append(" OR ");
                    }
                    query.append(publishedOid);
                }
            } else {
                query.append("empty");
            }
            query.append(" )");
            customQuery = query.toString();
        } else {
            customQuery = "last_modified:[" + dateFromString + "T00:00:00.000Z TO " + dateToString + "T23:59:59.999Z]";
        }
        block3: for (String key : this.statMap.keySet()) {
            Stat stat = this.statMap.get(key);
            stat.resetCounts();
            String query = customQuery == null ? stat.getQuery() : customQuery;
            this.log.debug("Using query:" + query);
            SearchRequest solrReq = new SearchRequest(query);
            int start = 0;
            int pageSize = Integer.valueOf(stat.getRows());
            solrReq.setParam("fq", stat.getFq());
            solrReq.setParam("rows", "" + pageSize);
            solrReq.setParam("start", "" + start);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            indexer.search(solrReq, (OutputStream)result);
            SolrResult resultObject = new SolrResult((InputStream)new ByteArrayInputStream(result.toByteArray()));
            int numFound = resultObject.getNumFound();
            stat.setResultCount("mint-total-", numFound);
            this.log.debug("numFound:" + numFound);
            while (numFound > 0) {
                List results = resultObject.getResults();
                for (SolrDoc docObject : results) {
                    for (String resName : stat.getResultsByName().keySet()) {
                        StatResult statRes = stat.getResultByName(resName);
                        String solrFld = statRes.getSolrField();
                        String value = docObject.getString(null, new Object[]{solrFld});
                        if (solrFld.equals("numFound")) continue;
                        if (value == null) {
                            JSONArray valueArr = docObject.getArray(new Object[]{solrFld});
                            if (valueArr != null) {
                                value = (String)valueArr.get(0);
                            } else {
                                this.log.error("Value not found for solr field:" + solrFld);
                            }
                        }
                        if (resName.indexOf(":") > 0) {
                            if (!statRes.getSolrFieldValue().equalsIgnoreCase(value)) continue;
                            String groupBy = statRes.getGroupBy();
                            String uniqueVal = docObject.getString(null, new Object[]{groupBy});
                            if (uniqueVal == null) {
                                JSONArray valueArr = docObject.getArray(new Object[]{groupBy});
                                if (valueArr != null) {
                                    uniqueVal = (String)valueArr.get(0);
                                } else {
                                    this.log.error("Value not found for group by field:" + groupBy);
                                }
                            }
                            Integer curCountObj = stat.getResultByName(resName).getGroupMap().get(uniqueVal);
                            int curCount = 0;
                            if (curCountObj != null) {
                                curCount = curCountObj;
                            }
                            stat.getResultByName(resName).setGroupValues(uniqueVal, new Integer(++curCount));
                            continue;
                        }
                        String resultKey = resName + "-" + value;
                        statRes = stat.getResults().get(resultKey);
                        if (statRes == null) continue;
                        statRes.incCounts();
                    }
                }
                if ((start += pageSize) > numFound) continue block3;
                solrReq.setParam("start", "" + start);
                result = new ByteArrayOutputStream();
                indexer.search(solrReq, (OutputStream)result);
                resultObject = new SolrResult((InputStream)new ByteArrayInputStream(result.toByteArray()));
            }
        }
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        for (String statKey : this.statMap.keySet()) {
            this.log.debug("For stat key: " + statKey);
            Stat stat = this.statMap.get(statKey);
            for (String resKey : stat.getResults().keySet()) {
                StatResult statRes = stat.getResults().get(resKey);
                if (statRes.getName().indexOf(":") > 0) {
                    resMap.put(statRes.getLabel(), new ArrayList<String>(statRes.getGroupList()));
                    HashMap<String, String> groupMap = new HashMap<String, String>();
                    for (String valKey : statRes.getGroupMap().keySet()) {
                        groupMap.put(valKey, statRes.getGroupMap().get(valKey).toString());
                    }
                    resMap.put(statRes.getLabel() + "counts", groupMap);
                } else {
                    resMap.put(statRes.getLabel(), String.valueOf(statRes.getCounts()));
                }
                this.log.debug("Result label:" + statRes.getLabel() + " has counts: " + statRes.getCounts());
            }
        }
        return new JsonObject(resMap).toJSONString();
    }

    @Override
    public void setScriptingServices(ScriptingServices scriptingServices) {
        this.scriptingServices = scriptingServices;
    }

    class StatResult {
        private String key;
        private String name;
        private String label;
        private String solrField;
        private String solrFieldValue;
        private int counts;
        private HashMap<String, Integer> groupMap;
        private HashSet<String> groupList;
        private String groupBy;

        public StatResult(String key, String name, String label, String field, String value) {
            this.key = key;
            this.name = name;
            this.label = label;
            this.solrField = field;
            this.solrFieldValue = value;
            this.counts = 0;
            this.groupMap = new HashMap();
            this.groupList = new HashSet();
        }

        public void setGroupValues(String key, Integer count) {
            this.groupList.add(key);
            this.groupMap.put(key, count);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getSolrField() {
            return this.solrField;
        }

        public void setSolrField(String solrField) {
            this.solrField = solrField;
        }

        public String getSolrFieldValue() {
            return this.solrFieldValue;
        }

        public void setSolrFieldValue(String solrFieldValue) {
            this.solrFieldValue = solrFieldValue;
        }

        public int getCounts() {
            return this.groupMap.size() > 0 ? this.groupMap.size() : this.counts;
        }

        public void setCounts(int counts) {
            this.counts = counts;
        }

        public void incCounts() {
            ++this.counts;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public HashMap<String, Integer> getGroupMap() {
            return this.groupMap;
        }

        public void setGroupMap(HashMap<String, Integer> groupMap) {
            this.groupMap = groupMap;
        }

        public String getGroupBy() {
            return this.groupBy;
        }

        public void setGroupBy(String groupBy) {
            this.groupBy = groupBy;
        }

        public HashSet<String> getGroupList() {
            return this.groupList;
        }

        public void setGroupList(HashSet<String> groupList) {
            this.groupList = groupList;
        }
    }

    class Stat {
        private String name;
        private String query;
        private List<String> fq;
        private HashMap<String, StatResult> results = new HashMap();
        private Set<String> fields;
        private HashMap<String, StatResult> resultsByName = new HashMap();
        private String rows;

        public Stat(String name, String query, List<String> fq, String rows) {
            this.fields = new HashSet<String>();
            this.name = name;
            this.query = query;
            this.fq = fq;
            this.rows = rows;
        }

        public void resetCounts() {
            for (String key : this.results.keySet()) {
                StatResult statResult = this.results.get(key);
                statResult.setCounts(0);
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public List<String> getFq() {
            return this.fq;
        }

        public void setFq(List<String> fq) {
            this.fq = fq;
        }

        public Map<String, StatResult> getResults() {
            return this.results;
        }

        public String getRows() {
            return this.rows;
        }

        public void setRows(String rows) {
            this.rows = rows;
        }

        public void addResult(StatResult result) {
            this.results.put(result.getKey(), result);
            this.fields.add(result.getSolrField());
            this.resultsByName.put(result.getName(), result);
        }

        public void setResultCount(String key, int counts) {
            this.results.get(key).setCounts(counts);
        }

        public Set<String> getFields() {
            return this.fields;
        }

        public StatResult getResultByName(String name) {
            return this.resultsByName.get(name);
        }

        public HashMap<String, StatResult> getResultsByName() {
            return this.resultsByName;
        }

        public void setResultsByName(HashMap<String, StatResult> resultsByName) {
            this.resultsByName = resultsByName;
        }
    }
}

