/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.services.DatabaseServices;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseServicesImpl
implements DatabaseServices {
    private static String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String DERBY_PROTOCOL = "jdbc:derby:";
    private Logger log = LoggerFactory.getLogger(DatabaseServicesImpl.class);
    private JsonSimpleConfig sysConfig;
    private String derbyHome;
    private Map<String, Connection> dbConnections;
    private Map<String, PreparedStatement> statements;

    public DatabaseServicesImpl() {
        this.log.info("Database services starting...");
        try {
            this.sysConfig = new JsonSimpleConfig();
            this.derbyHome = this.sysConfig.getString(null, new Object[]{"database-service", "derbyHome"});
            String oldHome = System.getProperty("derby.system.home");
            if (oldHome != null) {
                if (this.derbyHome != null) {
                    this.log.warn("Using previously specified data directory: '{}', provided value has been ignored: '{}'", (Object)oldHome, (Object)this.derbyHome);
                } else {
                    this.log.info("Using existing data directory: '{}'", (Object)oldHome);
                }
            } else {
                if (this.derbyHome == null) {
                    this.log.error("No database home directory configured!");
                    return;
                }
                File file = new File(this.derbyHome);
                if (file.exists()) {
                    if (!file.isDirectory()) {
                        this.log.error("Database home '" + this.derbyHome + "' is not a directory!");
                        return;
                    }
                } else {
                    file.mkdirs();
                    if (!file.exists()) {
                        this.log.error("Database home '" + this.derbyHome + "' does not exist and could not be created!");
                        return;
                    }
                }
                System.setProperty("derby.system.home", this.derbyHome);
            }
            try {
                Class.forName(DERBY_DRIVER).newInstance();
            }
            catch (Exception ex) {
                this.log.error("JDBC Driver load failed: ", (Throwable)ex);
                return;
            }
            this.dbConnections = new HashMap();
            this.statements = new HashMap();
        }
        catch (IOException ex) {
            this.log.error("Failed to access system config", (Throwable)ex);
        }
    }

    private Connection connection(String database, boolean create) throws SQLException {
        Connection thisDatabase = null;
        if (this.dbConnections.containsKey(database)) {
            thisDatabase = (Connection)this.dbConnections.get(database);
        }
        if (thisDatabase == null || !thisDatabase.isValid(1)) {
            if (thisDatabase != null) {
                this.log.error("Database connection '{}' has failed, recreating.", (Object)database);
                try {
                    thisDatabase.close();
                }
                catch (SQLException ex) {
                    this.log.error("Error closing invalid connection, ignoring: {}", (Object)ex.getMessage());
                }
            }
            try {
                Class.forName(DERBY_DRIVER).newInstance();
            }
            catch (Exception ex) {
                this.log.error("Driver load failed: ", (Throwable)ex);
                throw new SQLException("Driver load failed: ", ex);
            }
            String connection = DERBY_PROTOCOL + database;
            if (create) {
                connection = connection + ";create=true";
            }
            thisDatabase = DriverManager.getConnection(connection, new Properties());
            this.dbConnections.put(database, thisDatabase);
        }
        return thisDatabase;
    }

    public void registryDidShutdown() {
        block6: {
            this.log.info("Database services shutting down...");
            for (String key : this.statements.keySet()) {
                this.close((Statement)this.statements.get(key));
            }
            for (String key : this.dbConnections.keySet()) {
                try {
                    ((Connection)this.dbConnections.get(key)).close();
                }
                catch (SQLException ex) {
                    this.log.error("Error closing database: ", (Throwable)ex);
                }
            }
            String threadedShutdownMessage = DERBY_DRIVER + " is not registered with the JDBC driver manager";
            try {
                DriverManager.getConnection(DERBY_PROTOCOL + ";shutdown=true");
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() == 50000 && ex.getSQLState().equals("XJ015") || ex.getMessage().equals(threadedShutdownMessage)) break block6;
                this.log.warn("Error during database shutdown:", (Throwable)ex);
            }
        }
    }

    public Connection checkConnection(String database) throws Exception {
        try {
            return this.connection(database, false);
        }
        catch (Exception ex) {
            throw new Exception("Database does not exist", ex);
        }
    }

    public Connection getConnection(String database) throws Exception {
        try {
            return this.connection(database, true);
        }
        catch (Exception ex) {
            this.log.error("Error during database creation:", (Throwable)ex);
            throw ex;
        }
    }

    public PreparedStatement prepare(Connection db, String index, String sql) throws Exception {
        PreparedStatement statement = (PreparedStatement)this.statements.get(index);
        if (statement == null) {
            try {
                statement = db.prepareStatement(sql);
                this.statements.put(index, statement);
            }
            catch (SQLException ex) {
                this.log.error("Error preparing statement:", (Throwable)ex);
                throw new Exception("Error preparing statement:", ex);
            }
        }
        return statement;
    }

    public void bindParam(PreparedStatement sql, int index, Object data) throws Exception {
        try {
            if (data == null) {
                throw new Exception("NULL values are not accepted. Use 'IS NULL' or similar!");
            }
            sql.setObject(index, data);
        }
        catch (SQLException ex) {
            this.log.error("Error binding parameter:", (Throwable)ex);
            throw new Exception("Error binding parameter:", ex);
        }
    }

    public void free(PreparedStatement sql) throws Exception {
        this.close((Statement)sql);
    }

    public List<Map<String, String>> getResults(PreparedStatement sql) throws Exception {
        ArrayList<Map<String, String>> response = new ArrayList<Map<String, String>>();
        ResultSet results = null;
        ResultSetMetaData columns = null;
        try {
            results = sql.executeQuery();
            columns = results.getMetaData();
            if (results.isClosed()) {
                this.log.error("!!! ResultSet is closed");
                return response;
            }
            while (results.next()) {
                HashMap<String, String> row = new HashMap<String, String>();
                for (int i = 1; i <= columns.getColumnCount(); ++i) {
                    row.put(columns.getColumnName(i), results.getString(i));
                }
                response.add(row);
            }
            results.close();
            return response;
        }
        catch (SQLException ex) {
            throw new Exception("Error executing query:", ex);
        }
    }

    public List<Map<String, String>> select(String db, String index, String sql, List<Object> fields) throws Exception {
        if (db == null) {
            throw new Exception("Database cannot be NULL!");
        }
        if (sql == null) {
            throw new Exception("SQL statement cannot be NULL!");
        }
        Connection database = this.checkConnection(db);
        if (database == null) {
            throw new Exception("Database '" + db + "' does not exist!");
        }
        PreparedStatement statement = null;
        try {
            statement = database.prepareStatement(sql);
        }
        catch (SQLException ex) {
            this.log.error("Error preparing statement:", (Throwable)ex);
            throw new Exception("Error preparing statement:", ex);
        }
        if (fields != null) {
            for (int i = 1; i <= fields.size(); ++i) {
                this.bindParam(statement, i, fields.get(i - 1));
            }
        }
        List response = this.getResults(statement);
        this.close((Statement)statement);
        return response;
    }

    public void insert(String db, String index, String table, Map<String, Object> fields) throws Exception {
        if (db == null) {
            throw new Exception("Database cannot be NULL!");
        }
        if (table == null) {
            throw new Exception("Table name cannot be NULL!");
        }
        if (fields == null) {
            throw new Exception("No field data provided!");
        }
        Connection database = this.checkConnection(db);
        if (database == null) {
            throw new Exception("Database '" + db + "' does not exist!");
        }
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> placeHolders = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        for (String key : fields.keySet()) {
            columns.add(key);
            placeHolders.add("?");
            data.add(fields.get(key));
        }
        String sql = "INSERT INTO " + table + " (" + StringUtils.join(columns, (String)",") + ") VALUES (" + StringUtils.join(placeHolders, (String)",") + ")";
        PreparedStatement statement = this.prepare(database, index, sql);
        for (int i = 1; i <= data.size(); ++i) {
            this.bindParam(statement, i, data.get(i - 1));
        }
        try {
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            if (ex.getMessage().contains("duplicate key value")) {
                throw new Exception("Duplicate record!");
            }
            this.log.error("Error during insert:", (Throwable)ex);
            throw new Exception("Error during insert:", ex);
        }
    }

    public void delete(String db, String index, String table, Map<String, Object> where) throws Exception {
        if (db == null) {
            throw new Exception("Database cannot be NULL!");
        }
        if (table == null) {
            throw new Exception("Table name cannot be NULL!");
        }
        Connection database = this.checkConnection(db);
        if (database == null) {
            throw new Exception("Database '" + db + "' does not exist!");
        }
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> data = new ArrayList<Object>();
        if (where != null) {
            for (String key : where.keySet()) {
                columns.add(key + " = ?");
                data.add(where.get(key));
            }
        }
        String sql = columns.isEmpty() ? "DELETE FROM " + table : "DELETE FROM " + table + " WHERE " + StringUtils.join(columns, (String)" AND ");
        PreparedStatement statement = this.prepare(database, index, sql);
        if (!data.isEmpty()) {
            for (int i = 1; i <= data.size(); ++i) {
                this.bindParam(statement, i, data.get(i - 1));
            }
        }
        try {
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new Exception("Error during insert:", ex);
        }
    }

    public void execute(String db, String index, String sql, List<Object> fields) throws Exception {
        if (db == null) {
            throw new Exception("Database cannot be NULL!");
        }
        if (sql == null) {
            throw new Exception("SQL statement cannot be NULL!");
        }
        Connection database = this.checkConnection(db);
        if (database == null) {
            throw new Exception("Database '" + db + "' does not exist!");
        }
        PreparedStatement statement = this.prepare(database, index, sql);
        if (fields != null) {
            for (int i = 1; i <= fields.size(); ++i) {
                this.bindParam(statement, i, fields.get(i - 1));
            }
        }
        statement.execute();
    }

    private void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                this.log.error("Error closing statement: ", (Throwable)ex);
            }
        }
        statement = null;
    }
}

