/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.process;

import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.portal.process.Processor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRecordProcessor
implements Processor {
    private Logger log = LoggerFactory.getLogger(NewRecordProcessor.class);

    @Override
    public boolean process(String id, String inputKey, String outputKey, String stage, String configFilePath, HashMap dataMap) throws Exception {
        this.log.debug("PASSED PARAMS-> ID:" + id + ", INPUTKEY: " + inputKey + ", OUTPUTKEY:" + outputKey + ", STAGE: " + stage + ", CONFIGFILEPATH:" + configFilePath);
        if ("pre".equalsIgnoreCase(stage)) {
            return this.getNewRecords(id, outputKey, configFilePath, dataMap);
        }
        if ("post".equalsIgnoreCase(stage)) {
            return this.postProcess(id, inputKey, configFilePath, dataMap);
        }
        return false;
    }

    private boolean getNewRecords(String id, String outputKey, String configFilePath, HashMap dataMap) throws Exception {
        Indexer indexer = (Indexer)dataMap.get("indexer");
        JsonSimple config = new JsonSimple(new File(configFilePath));
        String solrQuery = config.getString("", new Object[]{"query"});
        String lastRun = config.getString(null, new Object[]{"lastrun"});
        solrQuery = solrQuery + (lastRun != null ? " AND create_timestamp:[" + lastRun + " TO NOW]" : "");
        this.log.debug("Using solrQuery:" + solrQuery);
        SearchRequest searchRequest = new SearchRequest(solrQuery);
        int start = 0;
        int pageSize = 10;
        searchRequest.setParam("start", "" + start);
        searchRequest.setParam("rows", "" + pageSize);
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        indexer.search(searchRequest, (OutputStream)result);
        SolrResult resultObject = new SolrResult(result.toString());
        int numFound = resultObject.getNumFound();
        this.log.debug("Number found:" + numFound);
        ArrayList<String> newRecords = new ArrayList<String>();
        while (true) {
            List results = resultObject.getResults();
            for (SolrDoc docObject : results) {
                String oid = docObject.getString(null, new Object[]{"id"});
                if (oid != null) {
                    this.log.debug("New record found: " + oid);
                    newRecords.add(oid);
                    continue;
                }
                this.log.debug("Record returned but has no id.");
                this.log.debug(docObject.toString());
            }
            if ((start += pageSize) > numFound) break;
            searchRequest.setParam("start", "" + start);
            result = new ByteArrayOutputStream();
            resultObject = new SolrResult(result.toString());
        }
        JSONArray includedArr = config.getArray(new Object[]{"includeList"});
        if (includedArr != null && includedArr.size() > 0) {
            newRecords.addAll((Collection<String>)includedArr);
        }
        dataMap.put(outputKey, newRecords);
        return true;
    }

    private boolean postProcess(String id, String inputKey, String configFilePath, HashMap dataMap) throws Exception {
        File configFile = new File(configFilePath);
        SimpleDateFormat dtFormat = new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ss'Z'");
        JsonSimple config = new JsonSimple(configFile);
        config.getJsonObject().put((Object)"lastrun", (Object)dtFormat.format(new Date()));
        List oids = (List)dataMap.get(inputKey);
        JSONArray includedArr = config.getArray(new Object[]{"includeList"});
        if (oids != null && oids.size() > 0) {
            if (includedArr == null) {
                includedArr = config.writeArray(new Object[]{"includeList"});
            }
            includedArr.clear();
            for (String oid : oids) {
                includedArr.add((Object)oid);
            }
        } else if (includedArr != null && includedArr.size() > 0) {
            includedArr.clear();
        }
        FileWriter writer = new FileWriter(configFile);
        writer.write(config.toString(true));
        writer.close();
        return true;
    }
}

