/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.portal.services.LanguageService;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaPropertiesLanguageService
implements LanguageService {
    private Logger log = LoggerFactory.getLogger(JavaPropertiesLanguageService.class);
    private JsonSimple config;
    private List<Properties> propertiesFiles = new ArrayList<Properties>();

    @Override
    public JsonSimple getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(JsonSimple config) {
        this.config = config;
    }

    @Override
    public void init() {
        File[] file;
        this.log.debug("Initializing JavaPropertiesLanguageService...");
        File propertiesDir = new File(this.config.getString(null, new Object[]{"config", "propertiesDir"}));
        if (!propertiesDir.exists()) {
            this.log.error("Can't find properties directory " + propertiesDir.getPath());
            return;
        }
        for (File propertyFile : file = propertiesDir.listFiles()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(propertyFile));
                this.propertiesFiles.add(properties);
            }
            catch (Exception e) {
                this.log.error("Can't find properties properties file " + propertyFile.getPath(), (Throwable)e);
            }
        }
    }

    @Override
    public String displayMessage(String messageCode) {
        for (Properties propertyFile : this.propertiesFiles) {
            if (propertyFile.get(messageCode) == null) continue;
            return (String)propertyFile.get(messageCode);
        }
        return messageCode;
    }
}

