/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.api.PluginDescription;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.messaging.MessagingException;
import com.googlecode.fascinator.common.messaging.MessagingServices;
import com.googlecode.fascinator.portal.JsonSessionState;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Set;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.ApplicationStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageWrapperImpl
implements Storage {
    private Storage storage;
    private String username;
    @Inject
    private JsonSessionState sessionState;
    private MessagingServices messaging;
    private Logger log = LoggerFactory.getLogger(StorageWrapperImpl.class);

    public StorageWrapperImpl(Storage storage, ApplicationStateManager asm) {
        this.storage = storage;
        if (this.sessionState == null) {
            this.sessionState = (JsonSessionState)asm.get(JsonSessionState.class);
        }
        this.username = (String)this.sessionState.get("username");
        try {
            this.messaging = MessagingServices.getInstance();
        }
        catch (MessagingException ex) {
            this.log.error("Failed to start connection: {}", (Object)ex.getMessage());
        }
    }

    public DigitalObject createObject(String oid) throws StorageException {
        DigitalObject object = this.storage.createObject(oid);
        this.sentMessage(object.getId(), "create");
        return object;
    }

    public DigitalObject getObject(String oid) throws StorageException {
        DigitalObject object = this.storage.getObject(oid);
        this.sentMessage(object.getId(), "access");
        return object;
    }

    public Set<String> getObjectIdList() {
        return this.storage.getObjectIdList();
    }

    public void removeObject(String oid) throws StorageException {
        this.sentMessage(oid, "delete");
        this.storage.removeObject(oid);
    }

    public String getId() {
        return this.storage.getId();
    }

    public String getName() {
        return this.storage.getName();
    }

    public PluginDescription getPluginDetails() {
        return this.storage.getPluginDetails();
    }

    public void init(File jsonFile) throws PluginException {
        this.storage.init(jsonFile);
    }

    public void init(String jsonString) throws PluginException {
        this.storage.init(jsonString);
    }

    public void shutdown() throws PluginException {
        if (this.messaging != null) {
            this.messaging.release();
        }
    }

    private void sentMessage(String oid, String eventType) {
        this.log.info(" * Sending message: {} with event {}", (Object)oid, (Object)eventType);
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put("oid", oid);
        param.put("eventType", eventType);
        param.put("username", this.username);
        param.put("context", this.storage.getName());
        try {
            this.messaging.onEvent(param);
        }
        catch (MessagingException ex) {
            this.log.error("Unable to send message: ", (Throwable)ex);
        }
    }
}

