/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.workflow;

import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.FascinatorHome;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.messaging.MessagingException;
import com.googlecode.fascinator.common.messaging.MessagingServices;
import com.googlecode.fascinator.common.storage.StorageUtils;
import com.googlecode.fascinator.portal.FormData;
import com.googlecode.fascinator.portal.services.VelocityService;
import com.googlecode.fascinator.portal.workflow.components.HtmlButton;
import com.googlecode.fascinator.portal.workflow.components.HtmlDiv;
import com.googlecode.fascinator.portal.workflow.components.HtmlFieldElement;
import com.googlecode.fascinator.portal.workflow.components.HtmlForm;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tapestry5.internal.KeyValue;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.json.simple.JSONArray;

public class SimpleWorkflowHelper {
    private Storage storage = null;
    private VelocityService velocityService = null;
    private JsonSimple systemConfiguration = null;
    private String portalId = null;
    private VelocityContext parentVelocityContext = null;
    private MessagingServices messagingServices = MessagingServices.getInstance();

    public String updateWorkflowMetadata(String oid, String action) throws StorageException, IOException {
        String targetStep = null;
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        JsonSimple workflowMetadata = this.getWorkflowMetadata(digitalObject);
        String workflowId = workflowMetadata.getString(null, new Object[]{"id"});
        JsonSimple workflowConfiguration = this.getWorkflowConfiguration(workflowId);
        JSONArray workflowStages = workflowConfiguration.getArray(new Object[]{"stages"});
        JsonObject workflowStageConfiguration = null;
        for (int i = 0; i < workflowStages.size(); ++i) {
            JsonObject workflowStage = (JsonObject)workflowStages.get(i);
            if (!workflowMetadata.getJsonObject().get((Object)"step").equals(workflowStage.get((Object)"name"))) continue;
            workflowStageConfiguration = workflowStage;
            break;
        }
        JSONArray workflowStepActions = (JSONArray)workflowStageConfiguration.get((Object)"actions");
        for (int i = 0; i < workflowStepActions.size(); ++i) {
            JsonObject workflowStepAction = (JsonObject)workflowStepActions.get(i);
            if (!action.equals(workflowStepAction.get((Object)"action-name"))) continue;
            targetStep = (String)workflowStepAction.get((Object)"target-step");
            this.progressActionToNextStep(digitalObject, workflowMetadata, targetStep);
        }
        return targetStep;
    }

    private void progressActionToNextStep(DigitalObject digitalObject, JsonSimple workflowMetadata, String targetStep) throws StorageException {
        workflowMetadata.getJsonObject().put((Object)"targetStep", (Object)targetStep);
        digitalObject.updatePayload("workflow.metadata", (InputStream)new ByteArrayInputStream(workflowMetadata.toString().getBytes()));
    }

    public void updateObjectMetadata(String oid, List<KeyValue> data) throws StorageException, IOException {
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        Properties tfObjMeta = digitalObject.getMetadata();
        for (KeyValue keyValue : data) {
            tfObjMeta.setProperty(keyValue.getKey(), keyValue.getValue());
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tfObjMeta.store(output, null);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        StorageUtils.createOrUpdatePayload((DigitalObject)digitalObject, (String)"TF-OBJ-META", (InputStream)input);
    }

    public void updateTFPackage(String oid, FormData formData) throws StorageException, IOException {
        Matcher m;
        String pid = this.getTFPackagePid(oid);
        JsonSimple tfPackage = this.getTFPackage(oid, pid);
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        JsonSimple workflowMetadata = this.getWorkflowMetadata(digitalObject);
        String workflowId = workflowMetadata.getString(null, new Object[]{"id"});
        JsonSimple workflowConfiguration = this.getWorkflowConfiguration(workflowId);
        JsonSimple formConfiguration = this.getFormConfiguration(workflowConfiguration);
        ArrayList fieldList = new ArrayList();
        List<JsonObject> formJsonArray = this.getFormFieldArray(formConfiguration.getArray(new Object[]{"stages", workflowMetadata.getString(null, new Object[]{"step"}), "divs"}).toArray());
        HashMap<String, Integer> repeatableFormFields = new HashMap<String, Integer>();
        Pattern p = Pattern.compile("([A-Za-z0-9\\.\\:]+\\.)([0-9]+)(\\.[A-Za-z0-9\\.\\:]*)");
        Set<String> fields = formData.getFormFields();
        for (String field : fields) {
            String fieldValue = formData.get(field);
            if (fieldValue != null) {
                tfPackage.getJsonObject().put((Object)field, (Object)fieldValue);
            }
            m = p.matcher(field);
            m.find();
            if (!m.matches()) continue;
            String fieldId = m.group(1) + "0" + m.group(3);
            int fieldIndex = new Integer(m.group(2));
            Integer count = (Integer)repeatableFormFields.get(fieldId);
            if (count != null && count >= fieldIndex) continue;
            repeatableFormFields.put(fieldId, fieldIndex);
        }
        for (String repeatableFormField : repeatableFormFields.keySet()) {
            int count = (Integer)repeatableFormFields.get(repeatableFormField);
            ++count;
            m = p.matcher(repeatableFormField);
            m.find();
            while (this.existsInTFPackage(tfPackage, m.group(1) + count + m.group(3))) {
                tfPackage.getJsonObject().remove((Object)(m.group(1) + count + m.group(3)));
                ++count;
            }
        }
        digitalObject.updatePayload(pid, (InputStream)new ByteArrayInputStream(tfPackage.toString().getBytes()));
    }

    private boolean existsInTFPackage(JsonSimple tfPackage, String path) {
        return tfPackage.getJsonObject().get((Object)path) != null;
    }

    private List<JsonObject> getFormFieldArray(Object[] divs) {
        ArrayList<JsonObject> formFields = new ArrayList<JsonObject>();
        for (Object div : divs) {
            JsonObject jsonObjectDiv = (JsonObject)div;
            JsonObject[] divFormFields = (JsonObject[])((JSONArray)jsonObjectDiv.get((Object)"fields")).toArray((Object[])new JsonObject[0]);
            formFields.addAll(Arrays.asList(divFormFields));
        }
        return formFields;
    }

    public void reindex(String oid, String step, String username) throws StorageException, IOException, MessagingException {
        JsonObject message = new JsonObject();
        message.put((Object)"oid", (Object)oid);
        if (step == null) {
            message.put((Object)"eventType", (Object)"ReIndex");
        } else {
            message.put((Object)"eventType", (Object)("NewStep : " + step));
            message.put((Object)"newStep", (Object)step);
        }
        message.put((Object)"quickIndex", (Object)true);
        message.put((Object)"username", (Object)username);
        message.put((Object)"context", (Object)"Workflow");
        message.put((Object)"task", (Object)"workflow");
        this.messagingServices.queueMessage("transactionManager", message.toString());
    }

    private JsonSimple getTFPackage(String oid, String pid) throws StorageException, IOException {
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        InputStream tfPackageInputStream = digitalObject.getPayload(pid).open();
        return new JsonSimple(tfPackageInputStream);
    }

    public JsonSimple getTFPackage(String oid) throws StorageException, IOException {
        return this.getTFPackage(oid, this.getTFPackagePid(oid));
    }

    private String getTFPackagePid(String oid) throws StorageException {
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        for (String pid : digitalObject.getPayloadIdList()) {
            if (!pid.endsWith("tfpackage")) continue;
            return pid;
        }
        return null;
    }

    public String getFormHtml(String oid) throws Exception {
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        JsonSimple workflowMetadata = this.getWorkflowMetadata(digitalObject);
        String workflowId = workflowMetadata.getString(null, new Object[]{"id"});
        JsonSimple workflowConfiguration = this.getWorkflowConfiguration(workflowId);
        JsonSimple formConfiguration = this.getFormConfiguration(workflowConfiguration);
        HtmlForm form = new HtmlForm();
        JSONArray formJsonArray = formConfiguration.getArray(new Object[]{"stages", workflowMetadata.getString(null, new Object[]{"step"}), "divs"});
        for (int i = 0; i < formJsonArray.size(); ++i) {
            form.addHtmlDiv(this.getHtmlDiv((JsonObject)formJsonArray.get(i)));
        }
        JSONArray buttonJsonArray = formConfiguration.getArray(new Object[]{"stages", workflowMetadata.getString(null, new Object[]{"step"}), "buttons"});
        for (int i = 0; i < buttonJsonArray.size(); ++i) {
            form.addHtmlButton(this.getHtmlButton((JsonObject)buttonJsonArray.get(i)));
        }
        String htmlFooter = (String)((JsonObject)((JsonObject)formConfiguration.getJsonObject().get((Object)"stages")).get((Object)workflowMetadata.getString(null, new Object[]{"step"}))).get((Object)"form-footer");
        if (htmlFooter != null) {
            form.setHtmlFooter(htmlFooter);
        }
        String output = this.renderFormHtml(form);
        return output;
    }

    private String renderFormHtml(HtmlForm form) throws Exception {
        String divElementsHtml = this.renderDivElementsHtml(form);
        String fieldElementsHtml = this.renderFieldElementsHtml(form.getHtmlFieldElements());
        String buttonElementsHtml = this.renderButtonElementsHtml(form);
        String formFooterHtml = this.renderFormFooterHtml(form.getHtmlFooter());
        VelocityContext vc = this.parentVelocityContext;
        vc.put("fieldElementsHtml", (Object)fieldElementsHtml);
        vc.put("buttonElementsHtml", (Object)buttonElementsHtml);
        vc.put("divElementsHtml", (Object)divElementsHtml);
        vc.put("formFooterHtml", (Object)formFooterHtml);
        StringWriter pageContentWriter = new StringWriter();
        this.velocityService.renderTemplate(this.portalId, "form-components/form-template", (Context)vc, pageContentWriter);
        return pageContentWriter.toString();
    }

    private String renderFormFooterHtml(String htmlFooterTemplate) throws Exception {
        VelocityContext vc = (VelocityContext)this.parentVelocityContext.clone();
        if (this.velocityService.resourceExists(this.portalId, "form-components/" + htmlFooterTemplate + ".vm") != null) {
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, "form-components/" + htmlFooterTemplate, (Context)vc, pageContentWriter);
            return pageContentWriter.toString();
        }
        return "";
    }

    private String renderDivElementsHtml(HtmlForm form) throws Exception {
        String divElementsHtml = "";
        List<HtmlDiv> htmlDivs = form.getHtmlDivs();
        int divorder = 1;
        for (HtmlDiv htmlDiv : htmlDivs) {
            Object[] parentKeys;
            String htmlDivTemplate = "form-components/" + htmlDiv.getComponentTemplateName();
            if (this.velocityService.resourceExists(this.portalId, htmlDivTemplate + ".vm") == null) continue;
            String fieldElementsHtml = this.renderFieldElementsHtml(htmlDiv.getHtmlFieldElements());
            VelocityContext vc = new VelocityContext();
            for (Object object : parentKeys = this.parentVelocityContext.getKeys()) {
                vc.put((String)object, this.parentVelocityContext.get((String)object));
            }
            vc.put("divorder", (Object)divorder++);
            vc.put("fieldElementsHtml", (Object)fieldElementsHtml);
            Map<String, Object> parameterMap = htmlDiv.getParameterMap();
            Set<String> keySet = parameterMap.keySet();
            for (String string : keySet) {
                vc.put(string, parameterMap.get(string));
            }
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, htmlDivTemplate, (Context)vc, pageContentWriter);
            divElementsHtml = divElementsHtml + pageContentWriter.toString();
        }
        return divElementsHtml;
    }

    private String renderButtonElementsHtml(HtmlForm form) throws Exception {
        Object[] parentKeys;
        String buttonElementsHtml = "";
        List<HtmlButton> htmlButtons = form.getHtmlButtons();
        for (HtmlButton htmlButton : htmlButtons) {
            Object[] parentKeys2;
            String pageName = "form-components/button-elements/" + htmlButton.getComponentTemplateName();
            if (this.velocityService.resourceExists(this.portalId, pageName + ".vm") == null) continue;
            VelocityContext vc = new VelocityContext();
            for (Object object : parentKeys2 = this.parentVelocityContext.getKeys()) {
                vc.put((String)object, this.parentVelocityContext.get((String)object));
            }
            Map<String, Object> parameterMap = htmlButton.getParameterMap();
            Set<String> keySet = parameterMap.keySet();
            for (String string : keySet) {
                vc.put(string, parameterMap.get(string));
            }
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, pageName, (Context)vc, pageContentWriter);
            buttonElementsHtml = buttonElementsHtml + pageContentWriter.toString();
        }
        VelocityContext vc = new VelocityContext();
        for (Object key : parentKeys = this.parentVelocityContext.getKeys()) {
            vc.put((String)key, this.parentVelocityContext.get((String)key));
        }
        vc.put("buttonHtml", (Object)buttonElementsHtml);
        StringWriter pageContentWriter = new StringWriter();
        this.velocityService.renderTemplate(this.portalId, "form-components/button-wrapper", (Context)vc, pageContentWriter);
        buttonElementsHtml = pageContentWriter.toString();
        return buttonElementsHtml;
    }

    /*
     * WARNING - void declaration
     */
    private String renderFieldElementsHtml(List<HtmlFieldElement> htmlfieldElements) throws Exception {
        String fieldElementsHtml = "";
        for (HtmlFieldElement htmlFieldElement : htmlfieldElements) {
            void var11_13;
            Object[] parentKeys;
            if ("group".equals(htmlFieldElement.getComponentTemplateName())) {
                fieldElementsHtml = fieldElementsHtml + this.renderGroupElement(htmlFieldElement);
                continue;
            }
            String pageName = "form-components/field-elements/" + htmlFieldElement.getComponentTemplateName();
            if (this.velocityService.resourceExists(this.portalId, pageName + ".vm") == null) continue;
            VelocityContext vc = new VelocityContext();
            for (Object object : parentKeys = this.parentVelocityContext.getKeys()) {
                vc.put((String)object, this.parentVelocityContext.get((String)object));
            }
            Map<String, Object> parameterMap = htmlFieldElement.getParameterMap();
            Set<String> keySet = parameterMap.keySet();
            for (String string : keySet) {
                vc.put(string, parameterMap.get(string));
            }
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, pageName, (Context)vc, pageContentWriter);
            String string = pageContentWriter.toString();
            if (htmlFieldElement.hasValidation()) {
                vc.put("validation", (Object)htmlFieldElement.getValidation());
                vc.put("elementHtml", (Object)string);
                pageContentWriter = new StringWriter();
                this.velocityService.renderTemplate(this.portalId, "form-components/validation-wrapper", (Context)vc, pageContentWriter);
                String string2 = pageContentWriter.toString();
            }
            vc.put("elementHtml", (Object)var11_13);
            pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, "form-components/component-wrapper", (Context)vc, pageContentWriter);
            fieldElementsHtml = fieldElementsHtml + pageContentWriter.toString();
        }
        return fieldElementsHtml;
    }

    private String renderGroupElement(HtmlFieldElement htmlFieldElement) throws Exception {
        JSONArray fieldsArray = (JSONArray)htmlFieldElement.getParameterMap().get("fields");
        ArrayList<HtmlFieldElement> fieldElements = new ArrayList<HtmlFieldElement>();
        for (int i = 0; i < fieldsArray.size(); ++i) {
            fieldElements.add(this.getHtmlComponent((JsonObject)fieldsArray.get(i)));
        }
        String fieldElementsHtml = this.renderFieldElementsHtml(fieldElements);
        String groupTemplate = (String)htmlFieldElement.getParameterMap().get("template");
        StringWriter pageContentWriter = new StringWriter();
        if (this.velocityService.resourceExists(this.portalId, "form-components/field-elements/" + groupTemplate + ".vm") != null) {
            VelocityContext vc = (VelocityContext)this.parentVelocityContext.clone();
            vc.put("fieldElementsHtml", (Object)fieldElementsHtml);
            Set<String> keys = htmlFieldElement.getParameterMap().keySet();
            for (String key : keys) {
                vc.put(key, htmlFieldElement.getParameterMap().get(key));
            }
            this.velocityService.renderTemplate(this.portalId, "form-components/field-elements/" + groupTemplate, (Context)vc, pageContentWriter);
        }
        return pageContentWriter.toString();
    }

    private HtmlFieldElement getHtmlComponent(JsonObject jsonObject) {
        HtmlFieldElement htmlComponent = new HtmlFieldElement();
        htmlComponent.setComponentTemplateName((String)jsonObject.get((Object)"component-type"));
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Set keys = jsonObject.keySet();
        for (Object key : keys) {
            parameterMap.put((String)key, jsonObject.get(key));
        }
        if (jsonObject.get((Object)"validation") != null) {
            htmlComponent.setValidation((JsonObject)jsonObject.get((Object)"validation"));
        }
        htmlComponent.setParameterMap(parameterMap);
        return htmlComponent;
    }

    private HtmlDiv getHtmlDiv(JsonObject jsonObject) {
        HtmlDiv htmlDiv = new HtmlDiv();
        String componentTemplateName = (String)jsonObject.get((Object)"component-type");
        if (componentTemplateName != null) {
            htmlDiv.setComponentTemplateName(componentTemplateName);
        }
        JSONArray formJsonArray = (JSONArray)jsonObject.get((Object)"fields");
        for (int i = 0; i < formJsonArray.size(); ++i) {
            htmlDiv.addHtmlFieldElement(this.getHtmlComponent((JsonObject)formJsonArray.get(i)));
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Set keys = jsonObject.keySet();
        for (Object key : keys) {
            parameterMap.put((String)key, jsonObject.get(key));
        }
        htmlDiv.setParameterMap(parameterMap);
        return htmlDiv;
    }

    private HtmlButton getHtmlButton(JsonObject jsonObject) {
        HtmlButton htmlButton = new HtmlButton();
        htmlButton.setComponentTemplateName((String)jsonObject.get((Object)"component-type"));
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Set keys = jsonObject.keySet();
        for (Object key : keys) {
            parameterMap.put((String)key, jsonObject.get(key));
        }
        htmlButton.setParameterMap(parameterMap);
        return htmlButton;
    }

    private JsonSimple getFormConfiguration(JsonSimple workflowConfiguration) throws IOException {
        String formConfigFileLocation = workflowConfiguration.getString(null, new Object[]{"form-configuration"});
        File formConfigFile = FascinatorHome.getPathFile((String)formConfigFileLocation);
        return new JsonSimple(formConfigFile);
    }

    private JsonSimple getWorkflowConfiguration(String workflowId) throws IOException {
        String workflowConfigFileLocation = (String)this.systemConfiguration.getObject(new Object[]{"portal", "packageTypes", workflowId}).get((Object)"jsonconfig");
        File workflowConfigFile = FascinatorHome.getPathFile((String)("harvest/workflows/" + workflowConfigFileLocation));
        return new JsonSimple(workflowConfigFile);
    }

    private JsonSimple getWorkflowMetadata(DigitalObject digitalObject) throws StorageException, IOException {
        return new JsonSimple(digitalObject.getPayload("workflow.metadata").open());
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void setSystemConfiguration(JsonSimple systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
    }

    public void setVelocityService(VelocityService velocityService) {
        this.velocityService = velocityService;
    }

    public void setPortalId(String portalId) {
        this.portalId = portalId;
    }

    public void setParentVelocityContext(VelocityContext parentVelocityContext) {
        this.parentVelocityContext = parentVelocityContext;
    }
}

