/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.process;

import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.portal.process.Processor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.SimpleEmail;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotifier
implements Processor {
    private Logger log = LoggerFactory.getLogger(EmailNotifier.class);
    private String host;
    private String port;
    private String tls;
    private String ssl;
    private String from;
    private String to;
    private String username;
    private String password;

    private void init(JsonSimple config) {
        this.host = config.getString("", new Object[]{"host"});
        this.port = config.getString("", new Object[]{"port"});
        this.from = config.getString("", new Object[]{"from"});
        this.to = config.getString("", new Object[]{"to"});
        this.username = config.getString("", new Object[]{"username"});
        this.password = config.getString("", new Object[]{"password"});
        this.tls = config.getString("false", new Object[]{"tls"});
        this.ssl = config.getString("false", new Object[]{"ssl"});
        Properties props = System.getProperties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", this.tls);
    }

    private String replaceVars(SolrDoc solrDoc, String text, List<String> vars, JsonSimple config) {
        for (String var : vars) {
            String varField = config.getString("", new Object[]{"mapping", var});
            this.log.debug("Replacing '" + var + "' using field '" + varField + "'");
            String replacement = solrDoc.getString(var, new Object[]{varField});
            if (replacement == null || "".equals(replacement)) {
                JSONArray arr = solrDoc.getArray(new Object[]{varField});
                if (arr != null) {
                    replacement = (String)arr.get(0);
                    if (replacement == null) {
                        replacement = var;
                    }
                } else {
                    replacement = var;
                }
            }
            text = text.replace(var, replacement);
        }
        return text;
    }

    public boolean process(String id, String inputKey, String outputKey, String stage, String configFilePath, HashMap dataMap) throws Exception {
        JsonSimple config = new JsonSimple(new File(configFilePath));
        this.init(config);
        Indexer indexer = (Indexer)dataMap.get("indexer");
        ArrayList<String> failedOids = new ArrayList<String>();
        List oids = (List)dataMap.get(inputKey);
        String subjectTemplate = config.getString("", new Object[]{"subject"});
        String bodyTemplate = config.getString("", new Object[]{"body"});
        List vars = config.getStringList(new Object[]{"vars"});
        for (String oid : oids) {
            this.log.debug("Sending email notification for oid:" + oid);
            SearchRequest searchRequest = new SearchRequest("id:" + oid);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            indexer.search(searchRequest, (OutputStream)result);
            SolrResult resultObject = new SolrResult(result.toString());
            List results = resultObject.getResults();
            SolrDoc solrDoc = (SolrDoc)results.get(0);
            String subject = this.replaceVars(solrDoc, subjectTemplate, vars, config);
            String body = this.replaceVars(solrDoc, bodyTemplate, vars, config);
            String recipient = this.to;
            if (this.to.startsWith("$") && (recipient = this.replaceVars(solrDoc, this.to, vars, config)).startsWith("$")) {
                this.log.error("Failed to build the email recipient:'" + recipient + "'. Please check the mapping field and verify that it exists and is populated in Solr.");
                failedOids.add(oid);
                continue;
            }
            if (this.email(oid, recipient, subject, body)) continue;
            failedOids.add(oid);
        }
        dataMap.put(outputKey, failedOids);
        return true;
    }

    private boolean email(String oid, String recipient, String subject, String body) {
        try {
            SimpleEmail email = new SimpleEmail();
            this.log.debug("Email host: " + this.host);
            this.log.debug("Email port: " + this.port);
            this.log.debug("Email username: " + this.username);
            this.log.debug("Email from: " + this.from);
            this.log.debug("Email to: " + recipient);
            this.log.debug("Email Subject is: " + subject);
            this.log.debug("Email Body is: " + body);
            email.setHostName(this.host);
            email.setSmtpPort(Integer.parseInt(this.port));
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.username, this.password));
            email.setSSL("true".equalsIgnoreCase(this.ssl));
            email.setTLS("true".equalsIgnoreCase(this.tls));
            email.setFrom(this.from);
            email.setSubject(subject);
            email.setMsg(body);
            if (recipient.indexOf(",") >= 0) {
                String[] recs;
                for (String rec : recs = recipient.split(",")) {
                    email.addTo(rec);
                }
            } else {
                email.addTo(recipient);
            }
            email.send();
        }
        catch (Exception ex) {
            this.log.debug("Error sending notification mail for oid:" + oid, (Throwable)ex);
            return false;
        }
        return true;
    }
}

