/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.servlet;

import com.googlecode.fascinator.common.messaging.MessagingException;
import com.googlecode.fascinator.messaging.MessageBroker;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.python.core.PySystemState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexerServlet
extends HttpServlet {
    private Logger log = LoggerFactory.getLogger(IndexerServlet.class);
    private MessageBroker broker;

    public void init() throws ServletException {
        try {
            this.broker = MessageBroker.getInstance();
        }
        catch (MessagingException ex) {
            this.log.error("Failed to start broker: {}", (Throwable)ex);
            throw new ServletException("Error starting AMQ Broker: ", (Throwable)ex);
        }
        String realPath = this.getServletContext().getRealPath("/");
        if (!realPath.endsWith("/")) {
            realPath = realPath + "/";
        }
        String pythonHome = realPath + "WEB-INF/lib";
        Properties props = new Properties();
        props.setProperty("python.home", pythonHome);
        PySystemState.initialize((Properties)PySystemState.getBaseProperties(), (Properties)props, (String[])new String[]{""});
        PySystemState.add_classdir((String)(realPath + "WEB-INF/classes"));
        PySystemState.add_classdir((String)(realPath + "../../../target/classes"));
        PySystemState.add_extdir((String)pythonHome, (boolean)true);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void destroy() {
        boolean result;
        if (this.broker != null && !(result = this.broker.shutdown())) {
            this.log.error("Message broker did not shut down correctly!");
        }
        super.destroy();
    }
}

