/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.rest;

import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.IndexerException;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/search")
public class SearchResource {
    private JsonSimpleConfig config;

    public SearchResource() {
        try {
            this.config = new JsonSimpleConfig(this.getClass().getResourceAsStream("/config.json"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{portal}/{query}")
    public Response get(@PathParam(value="id") String id, @PathParam(value="query") String query) {
        try {
            Indexer indexer = PluginManager.getIndexer((String)this.config.getString(null, new Object[]{"indexer", "type"}));
            indexer.init(JsonSimpleConfig.getSystemFile());
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            SearchRequest request = new SearchRequest(query);
            indexer.search(request, (OutputStream)result);
            return Response.ok((Object)result.toByteArray()).build();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (IndexerException ie) {
            ie.printStackTrace();
        }
        catch (PluginException pe) {
            pe.printStackTrace();
        }
        return Response.ok().build();
    }
}

