/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services;

import com.googlecode.fascinator.AccessManager;
import com.googlecode.fascinator.AuthenticationManager;
import com.googlecode.fascinator.RoleManager;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.access.AccessControlManager;
import com.googlecode.fascinator.api.authentication.AuthManager;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.roles.RolesManager;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.services.ByteRangeRequestCache;
import com.googlecode.fascinator.portal.services.DatabaseServices;
import com.googlecode.fascinator.portal.services.DynamicPageCache;
import com.googlecode.fascinator.portal.services.DynamicPageService;
import com.googlecode.fascinator.portal.services.HarvestManager;
import com.googlecode.fascinator.portal.services.HouseKeepingManager;
import com.googlecode.fascinator.portal.services.NullURLEncoderImpl;
import com.googlecode.fascinator.portal.services.PortalManager;
import com.googlecode.fascinator.portal.services.PortalSecurityManager;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import com.googlecode.fascinator.portal.services.VelocityService;
import com.googlecode.fascinator.portal.services.impl.ByteRangeRequestCacheImpl;
import com.googlecode.fascinator.portal.services.impl.CachingDynamicPageServiceImpl;
import com.googlecode.fascinator.portal.services.impl.DatabaseServicesImpl;
import com.googlecode.fascinator.portal.services.impl.EhcacheDynamicPageCacheImpl;
import com.googlecode.fascinator.portal.services.impl.HarvestManagerImpl;
import com.googlecode.fascinator.portal.services.impl.HouseKeepingManagerImpl;
import com.googlecode.fascinator.portal.services.impl.PortalManagerImpl;
import com.googlecode.fascinator.portal.services.impl.PortalSecurityManagerImpl;
import com.googlecode.fascinator.portal.services.impl.ScriptingServicesImpl;
import com.googlecode.fascinator.portal.services.impl.VelocityServiceImpl;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.RegistryShutdownHub;
import org.apache.tapestry5.ioc.services.RegistryShutdownListener;
import org.apache.tapestry5.services.AliasContribution;
import org.apache.tapestry5.services.ApplicationStateContribution;
import org.apache.tapestry5.services.ApplicationStateCreator;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.URLEncoder;
import org.apache.tapestry5.urlrewriter.RewriteRuleApplicability;
import org.apache.tapestry5.urlrewriter.SimpleRequestWrapper;
import org.apache.tapestry5.urlrewriter.URLRewriteContext;
import org.apache.tapestry5.urlrewriter.URLRewriterRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PortalModule {
    private static final String DEFAULT_INDEXER_TYPE = "solr";
    private static final String DEFAULT_STORAGE_TYPE = "file-system";
    private static Logger log = LoggerFactory.getLogger(PortalModule.class);

    public static void bind(ServiceBinder binder) {
        binder.bind(ByteRangeRequestCache.class, ByteRangeRequestCacheImpl.class);
        binder.bind(DynamicPageService.class, CachingDynamicPageServiceImpl.class);
        binder.bind(HarvestManager.class, HarvestManagerImpl.class);
        binder.bind(PortalManager.class, PortalManagerImpl.class);
        binder.bind(PortalSecurityManager.class, PortalSecurityManagerImpl.class);
        binder.bind(ScriptingServices.class, ScriptingServicesImpl.class);
        binder.bind(VelocityService.class, VelocityServiceImpl.class);
    }

    public static DynamicPageCache buildDynamicPageCache(PortalManager portalManager, VelocityService velocityService, ScriptingServices scriptingServices, RegistryShutdownHub hub) {
        EhcacheDynamicPageCacheImpl cache = new EhcacheDynamicPageCacheImpl(portalManager, velocityService, scriptingServices);
        hub.addRegistryShutdownListener((RegistryShutdownListener)cache);
        return cache;
    }

    public static DatabaseServices buildDatabaseServices(RegistryShutdownHub hub) {
        DatabaseServicesImpl database = new DatabaseServicesImpl();
        hub.addRegistryShutdownListener((RegistryShutdownListener)database);
        return database;
    }

    public static HouseKeepingManager buildHouseKeepingManager(RegistryShutdownHub hub) {
        HouseKeepingManagerImpl houseKeeping = new HouseKeepingManagerImpl();
        hub.addRegistryShutdownListener((RegistryShutdownListener)houseKeeping);
        return houseKeeping;
    }

    public static AccessControlManager buildAccessManager() {
        try {
            AccessManager access = new AccessManager();
            access.init(JsonSimpleConfig.getSystemFile());
            return access;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AuthManager buildAuthManager() {
        try {
            AuthenticationManager auth = new AuthenticationManager();
            auth.init(JsonSimpleConfig.getSystemFile());
            return auth;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Indexer buildIndexer() {
        try {
            JsonSimpleConfig config = new JsonSimpleConfig();
            Indexer indexer = PluginManager.getIndexer((String)config.getString(DEFAULT_INDEXER_TYPE, new Object[]{"indexer", "type"}));
            indexer.init(JsonSimpleConfig.getSystemFile());
            return indexer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static RolesManager buildRoleManager() {
        try {
            RoleManager roles = new RoleManager();
            roles.init(JsonSimpleConfig.getSystemFile());
            return roles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Storage buildStorage() {
        try {
            JsonSimpleConfig config = new JsonSimpleConfig();
            Storage storage = PluginManager.getStorage((String)config.getString(DEFAULT_STORAGE_TYPE, new Object[]{"storage", "type"}));
            storage.init(JsonSimpleConfig.getSystemFile());
            return storage;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void contributeResponseCompressionAnalyzer(Configuration<String> configuration) {
        try {
            JsonSimpleConfig config = new JsonSimpleConfig();
            List ignoreList = config.getStringList(new Object[]{"portal", "compression", "ignore"});
            if (ignoreList != null && !ignoreList.isEmpty()) {
                for (String format : ignoreList) {
                    log.info("Exclude from GZIP '{}'", (Object)format);
                    configuration.add((Object)format);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void contributeApplicationStateManager(MappedConfiguration<Class<?>, ApplicationStateContribution> configuration) {
        ApplicationStateCreator<JsonSessionState> creator = new ApplicationStateCreator<JsonSessionState>(){

            public JsonSessionState create() {
                return new JsonSessionState();
            }
        };
        ApplicationStateContribution contribution = new ApplicationStateContribution("session", (ApplicationStateCreator)creator);
        configuration.add(JsonSessionState.class, (Object)contribution);
    }

    public static void contributeAlias(Configuration<AliasContribution<URLEncoder>> configuration) {
        configuration.add((Object)AliasContribution.create(URLEncoder.class, (Object)new NullURLEncoderImpl()));
    }

    public static void contributeURLRewriter(OrderedConfiguration<URLRewriterRule> configuration, final @Inject RequestGlobals requestGlobals, @Inject URLEncoder urlEncoder) {
        URLRewriterRule rule = new URLRewriterRule(){

            public Request process(Request request, URLRewriteContext context) {
                HttpServletRequest req = requestGlobals.getHTTPServletRequest();
                String ctxPath = request.getContextPath();
                String uri = req.getRequestURI();
                request.setAttribute("RequestURI", (Object)uri.substring(ctxPath.length() + 1));
                String path = request.getPath();
                String[] parts = path.substring(1).split("/");
                if (parts.length > 0) {
                    String start = parts[0];
                    if (!"assets".equals(start) && !"dispatch".equals(start)) {
                        path = "/dispatch" + path;
                    }
                } else {
                    path = "/dispatch";
                }
                return new SimpleRequestWrapper(request, path);
            }

            public RewriteRuleApplicability applicability() {
                return RewriteRuleApplicability.INBOUND;
            }
        };
        configuration.add("dispatch", (Object)rule, new String[0]);
    }

    static {
        MDC.put((String)"name", (String)"main");
    }
}

