/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.velocity;

import com.googlecode.fascinator.portal.velocity.JythonIterator;
import com.googlecode.fascinator.portal.velocity.JythonVelMethod;
import com.googlecode.fascinator.portal.velocity.JythonVelPropertyGet;
import java.util.Iterator;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.UberspectImpl;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.apache.velocity.util.introspection.VelPropertySet;
import org.python.core.PyBoolean;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyJavaType;
import org.python.core.PyList;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyObjectDerived;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonUberspect
extends UberspectImpl {
    private static Logger log = LoggerFactory.getLogger(JythonUberspect.class);

    public Iterator<?> getIterator(Object obj, Info i) throws Exception {
        log.trace("getIterator obj:" + obj + " i:" + i);
        if (obj instanceof PyObject) {
            PyObject pyObject = (PyObject)obj;
            PyType pyType = pyObject.getType();
            if (pyObject instanceof PySequence) {
                return new JythonIterator((PySequence)pyObject);
            }
            if (pyObject instanceof PyDictionary) {
                return ((PyDictionary)pyObject).values().iterator();
            }
            if (pyType instanceof PyJavaType) {
                Class cls = ((PyJavaType)pyType).getProxyType();
                return super.getIterator(pyObject.__tojava__(cls), i);
            }
            log.trace("Unsupported class:{} type:{}", pyObject.getClass(), (Object)pyType);
        }
        return super.getIterator(obj, i);
    }

    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace("getMethod obj:" + obj + " methodName:" + methodName + " i:" + i);
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    log.trace("          arg:" + arg);
                }
            }
        }
        if (obj instanceof PyObject) {
            return new JythonVelMethod(methodName);
        }
        return super.getMethod(obj, methodName, args, i);
    }

    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
        log.trace("getPropertyGet obj:" + obj + " identifier:" + identifier + " i:" + i);
        if (obj instanceof PyObject) {
            return new JythonVelPropertyGet(identifier);
        }
        return super.getPropertyGet(obj, identifier, i);
    }

    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
        log.trace("getPropertySet obj:" + obj + " identifier:" + identifier + " arg:" + arg + " i:" + i);
        return super.getPropertySet(obj, identifier, arg, i);
    }

    public static Object toJava(Object obj) {
        log.trace("toJava object:{}", obj);
        if (obj instanceof PyObject) {
            PyObject pyObject = (PyObject)obj;
            if (pyObject instanceof PyNone) {
                return null;
            }
            if (pyObject instanceof PyString) {
                return ((PyString)pyObject).asString();
            }
            if (pyObject instanceof PyBoolean) {
                return Boolean.parseBoolean(pyObject.toString());
            }
            if (pyObject instanceof PyInteger) {
                return Integer.parseInt(pyObject.toString());
            }
            if (pyObject instanceof PyUnicode) {
                return new String(((PyUnicode)pyObject).encode("UTF-8"));
            }
            if (pyObject instanceof PyObjectDerived) {
                PyType pyType = pyObject.getType();
                Class cls = ((PyJavaType)pyType).getProxyType();
                return ((PyObjectDerived)pyObject).__tojava__(cls);
            }
            if (pyObject instanceof PyList || pyObject instanceof PyDictionary) {
                return pyObject;
            }
            log.trace("toJava unhandled type:{}", (Object)pyObject.getClass().getName());
        }
        return obj;
    }
}

