/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.HarvestContent;
import com.googlecode.fascinator.portal.services.HarvestManager;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvestManagerImpl
implements HarvestManager {
    private Logger log = LoggerFactory.getLogger(HarvestManagerImpl.class);
    private File contentDir;
    private Map<String, HarvestContent> contentMap;

    public HarvestManagerImpl() {
        try {
            JsonSimpleConfig config = new JsonSimpleConfig();
            this.contentDir = new File(config.getString(null, new Object[]{"portal", "contentDir"}));
            this.load();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, HarvestContent> getContents() {
        if (this.contentMap == null) {
            this.contentMap = new HashMap();
        }
        return this.contentMap;
    }

    public void add(HarvestContent content) {
        this.getContents().put(content.getId(), content);
    }

    public HarvestContent get(String id) {
        return (HarvestContent)this.getContents().get(id);
    }

    public void remove(String id) {
        HarvestContent content = (HarvestContent)this.getContents().remove(id);
        this.getContents().remove(id);
    }

    public void save(HarvestContent content) throws IOException {
        FileWriter writer = new FileWriter(new File(this.contentDir, content.getId()));
        writer.write(content.toString());
        writer.close();
    }

    private void load() {
        File[] contentFiles;
        for (File contentFile : contentFiles = this.contentDir.listFiles((FileFilter)new /* Unavailable Anonymous Inner Class!! */)) {
            this.log.debug("Found content file: {}", (Object)contentFile);
            try {
                this.add(new HarvestContent(contentFile));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

