/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.process;

import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Payload;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.portal.process.EmailNotifier;
import com.googlecode.fascinator.portal.process.MessageqNotifierService;
import com.googlecode.fascinator.portal.process.Processor;
import com.googlecode.fascinator.spring.ApplicationContextProvider;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeInstitutionNotifier
implements Processor {
    private Logger log = LoggerFactory.getLogger(HomeInstitutionNotifier.class);

    @Override
    public boolean process(String id, String inputKey, String outputKey, String stage, String configFilePath, HashMap<String, Object> dataMap) throws Exception {
        Indexer indexer = (Indexer)dataMap.get("indexer");
        HashSet<String> failedOids = (HashSet<String>)dataMap.get(outputKey);
        if (failedOids == null) {
            failedOids = new HashSet<String>();
        }
        Collection oids = (Collection)dataMap.get(inputKey);
        JsonSimple config = new JsonSimple(new File(configFilePath));
        HashMap<String, JsonObject> homes = new HashMap<String, JsonObject>();
        for (Object homeObj : config.getArray(new Object[]{"institutions"})) {
            JsonObject home = (JsonObject)homeObj;
            homes.put((String)home.get((Object)"name"), home);
        }
        File sysFile = JsonSimpleConfig.getSystemFile();
        Storage storage = PluginManager.getStorage((String)"file-system");
        storage.init(sysFile);
        String targetPayload = "arms.xml";
        String targetProperty = "dataprovider:organization";
        for (String oid : oids) {
            JSONArray array;
            this.log.debug("Processing oid:" + oid);
            ByteArrayOutputStream out = null;
            SearchRequest searchRequest = new SearchRequest("id:" + oid);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            indexer.search(searchRequest, (OutputStream)result);
            SolrResult resultObject = new SolrResult(result.toString());
            List results = resultObject.getResults();
            SolrDoc solrDoc = (SolrDoc)results.get(0);
            String targetProp = solrDoc.getString("", new Object[]{targetProperty});
            if (targetProp == null && (array = solrDoc.getArray(new Object[]{targetProperty})).size() > 0) {
                targetProp = (String)array.get(0);
            }
            this.log.debug("Target property value: " + targetProp);
            if (targetProp != null && targetProp.length() > 0) {
                String channel = (String)((JsonObject)homes.get(targetProp)).get((Object)"channel");
                if (channel != null) {
                    this.log.debug("Using channel:" + channel);
                    if (channel.endsWith("email")) {
                        this.sendEmail(dataMap, failedOids, config, storage, out, targetPayload, oid, solrDoc, channel);
                        continue;
                    }
                    this.log.debug("Sending message through the queue...");
                    MessageqNotifierService notifierService = (MessageqNotifierService)ApplicationContextProvider.getApplicationContext().getBean(channel + "_service", MessageqNotifierService.class);
                    out = this.extractPayload(storage, out, targetPayload, oid);
                    if (out != null) {
                        notifierService.sendMessage(out.toString("UTF-8"));
                        continue;
                    }
                    this.log.error("Payload not found: " + targetPayload + ", for oid:" + oid);
                    continue;
                }
                this.log.debug("Channel configuration not found, ignoring.");
                continue;
            }
            this.log.debug("Target property has no value, ignoring.");
        }
        return true;
    }

    private void sendEmail(HashMap<String, Object> dataMap, HashSet<String> failedOids, JsonSimple config, Storage storage, ByteArrayOutputStream out, String targetPayload, String oid, SolrDoc solrDoc, String channel) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException, StorageException, Exception {
        String subjectTemplate = config.getString("", new Object[]{channel, "subject"});
        String bodyTemplate = config.getString("", new Object[]{channel, "body"});
        List vars = config.getStringList(new Object[]{channel, "vars"});
        VelocityContext context = new VelocityContext();
        this.initVars(solrDoc, vars, config, context, channel);
        String subject = this.evaluateStr(subjectTemplate, context);
        String body = this.evaluateStr(bodyTemplate, context);
        String to = config.getString("", new Object[]{channel, "to"});
        String from = config.getString("", new Object[]{channel, "from"});
        String recipient = this.evaluateStr(to, context);
        String attachDesc = config.getString("", new Object[]{channel, "attachDesc"});
        String attachType = config.getString("", new Object[]{channel, "attachType"});
        if (recipient.startsWith("$")) {
            this.log.error("Failed to build the email recipient:'" + recipient + "'. Please check the mapping field and verify that it exists and is populated in Solr.");
            failedOids.add(oid);
        } else {
            this.log.debug("Sending message to channel: " + channel);
            out = this.extractPayload(storage, out, targetPayload, oid);
            if (out != null) {
                EmailNotifier notifier = (EmailNotifier)dataMap.get(EmailNotifier.class.getName());
                if (!notifier.emailAttachment(recipient, from, subject, body, out.toByteArray(), attachType, targetPayload, attachDesc)) {
                    failedOids.add(oid);
                }
            } else {
                this.log.error("Payload not found: " + targetPayload + ", for oid:" + oid);
            }
        }
    }

    private ByteArrayOutputStream extractPayload(Storage storage, ByteArrayOutputStream out, String targetPayload, String oid) throws StorageException, IOException {
        DigitalObject object = storage.getObject(oid);
        Payload payload = object.getPayload(targetPayload);
        if (payload != null) {
            out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)payload.open(), (OutputStream)out);
            payload.close();
        } else {
            this.log.debug("Target payload not found:" + targetPayload);
        }
        return out;
    }

    private void initVars(SolrDoc solrDoc, List<String> vars, JsonSimple config, VelocityContext context, String channel) {
        for (String var : vars) {
            String varField;
            String replacement = solrDoc.getString(var, new Object[]{varField = config.getString("", new Object[]{channel, "mapping", var})});
            if (replacement == null || "".equals(replacement)) {
                JSONArray arr = solrDoc.getArray(new Object[]{varField});
                if (arr != null) {
                    replacement = (String)arr.get(0);
                    if (replacement == null) {
                        replacement = var;
                    }
                } else {
                    replacement = var;
                }
            }
            this.log.debug("Getting variable value '" + var + "' using field '" + varField + "', value:" + replacement);
            context.put(var.replace("$", ""), (Object)replacement);
        }
    }

    private String evaluateStr(String source, VelocityContext context) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException {
        StringWriter writer = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)writer, (String)"evaluateStr", (String)source);
        return writer.toString();
    }
}

