/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.security;

import com.googlecode.fascinator.RoleManager;
import com.googlecode.fascinator.common.authentication.GenericUser;
import com.googlecode.fascinator.common.authentication.SpringUser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class FascinatorSpringSecurityAuthenticationManager
implements AuthenticationManager {
    private RoleManager roleManager = null;

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public Authentication authenticate(Authentication authToken) throws AuthenticationException {
        GenericUser genericUser = (GenericUser)authToken.getDetails();
        SpringUser user = new SpringUser();
        user.setUsername(genericUser.getUsername());
        user.setSource(genericUser.getSource());
        List<GrantedAuthority> userRoles = this.buildRoleList((GenericUser)user);
        return new PreAuthenticatedAuthenticationToken((Object)user.getUsername(), (Object)user, userRoles);
    }

    private List<GrantedAuthority> buildRoleList(GenericUser user) {
        String[] roles;
        ArrayList<GrantedAuthority> userRoles = new ArrayList<GrantedAuthority>();
        for (String role : roles = this.roleManager.getRoles(user.getUsername())) {
            GrantedAuthorityImpl authority = new GrantedAuthorityImpl(role);
            userRoles.add((GrantedAuthority)authority);
        }
        return userRoles;
    }
}

