/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.cache;

import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.portal.services.ByteRangeRequestCache;
import com.googlecode.fascinator.portal.services.DatabaseServices;
import com.googlecode.fascinator.portal.services.DynamicPageService;
import com.googlecode.fascinator.portal.services.FascinatorService;
import com.googlecode.fascinator.portal.services.HarvestManager;
import com.googlecode.fascinator.portal.services.HouseKeepingManager;
import com.googlecode.fascinator.portal.services.PortalManager;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import com.googlecode.fascinator.portal.services.VelocityService;
import com.googlecode.fascinator.portal.velocity.JythonLogger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonCacheEntryFactory
implements CacheEntryFactory {
    private Logger log = LoggerFactory.getLogger(JythonCacheEntryFactory.class);
    private VelocityService velocityService;
    private ScriptingServices scriptingServices;
    private String portalPath;
    private String defaultPortal;
    private List<String> skinPriority;

    public JythonCacheEntryFactory(PortalManager portalManager, VelocityService velocityService, ScriptingServices scriptingServices) {
        this.velocityService = velocityService;
        this.scriptingServices = new DeprecatedServicesWrapper(scriptingServices);
        this.defaultPortal = portalManager.getDefaultPortal();
        this.portalPath = portalManager.getHomeDir().toString();
        this.skinPriority = portalManager.getSkinPriority();
    }

    public Object createEntry(Object key) throws Exception {
        String path = key.toString();
        int qmarkPos = path.lastIndexOf("?");
        if (qmarkPos != -1) {
            path = path.substring(0, qmarkPos);
        }
        int slashPos = path.indexOf("/");
        String portalId = path.substring(0, slashPos);
        PyObject scriptObject = null;
        InputStream in = this.velocityService.getResource(path);
        if (in == null) {
            this.log.debug("Failed to load script: '{}'", (Object)path);
        } else {
            this.addSysPaths(portalId, Py.getSystemState());
            PythonInterpreter python = PythonInterpreter.threadLocalStateInterpreter(null);
            python.set("Services", (Object)this.scriptingServices);
            JythonLogger jythonLogger = new JythonLogger(path);
            python.setOut((OutputStream)jythonLogger);
            python.setErr((OutputStream)jythonLogger);
            python.execfile(in, path);
            String scriptClassName = StringUtils.capitalize((String)FilenameUtils.getBaseName((String)path)) + "Data";
            PyObject scriptClass = python.get(scriptClassName);
            if (scriptClass != null) {
                scriptObject = scriptClass.__call__();
            } else {
                this.log.debug("Failed to find class '{}'", (Object)scriptClassName);
            }
            python.cleanup();
        }
        return scriptObject;
    }

    private void addSysPaths(String portalId, PySystemState sys) {
        for (String skin : this.skinPriority) {
            String sysPath = this.portalPath + "/" + portalId + "/" + skin + "/scripts";
            sys.path.append((PyObject)Py.newString((String)sysPath));
        }
        if (!this.defaultPortal.equals(portalId)) {
            this.addSysPaths(this.defaultPortal, sys);
        }
    }

    private class DeprecatedServicesWrapper
    implements ScriptingServices {
        private ScriptingServices scriptingServices;

        public DeprecatedServicesWrapper(ScriptingServices scriptingServices) {
            this.scriptingServices = scriptingServices;
        }

        @Override
        public DatabaseServices getDatabase() {
            JythonCacheEntryFactory.this.log.warn("WARN: getDatabase(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getDatabase();
        }

        @Override
        public DynamicPageService getPageService() {
            JythonCacheEntryFactory.this.log.warn("WARN: getPageService(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getPageService();
        }

        @Override
        public Indexer getIndexer() {
            JythonCacheEntryFactory.this.log.warn("WARN: getIndexer(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getIndexer();
        }

        @Override
        public Storage getStorage() {
            JythonCacheEntryFactory.this.log.warn("WARN: getStorage(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getStorage();
        }

        @Override
        public HarvestManager getHarvestManager() {
            JythonCacheEntryFactory.this.log.warn("WARN: getHarvestManager(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getHarvestManager();
        }

        @Override
        public HouseKeepingManager getHouseKeepingManager() {
            JythonCacheEntryFactory.this.log.warn("WARN: getHouseKeepingManager(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getHouseKeepingManager();
        }

        @Override
        public PortalManager getPortalManager() {
            JythonCacheEntryFactory.this.log.warn("WARN: getPortalManager(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getPortalManager();
        }

        @Override
        public ByteRangeRequestCache getByteRangeCache() {
            JythonCacheEntryFactory.this.log.warn("WARN: getByteRangeCache(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getByteRangeCache();
        }

        @Override
        public VelocityService getVelocityService() {
            JythonCacheEntryFactory.this.log.warn("WARN: getVelocityService(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getVelocityService();
        }

        @Override
        public FascinatorService getService(String serviceName) {
            JythonCacheEntryFactory.this.log.warn("WARN: getService(): Global scope Services is deprecated, use the context");
            return this.scriptingServices.getService(serviceName);
        }
    }
}

