/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.HarvestClient;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.Portal;
import com.googlecode.fascinator.portal.services.PortalManager;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortalManagerImpl
implements PortalManager {
    private static final String PORTAL_JSON = "portal.json";
    private Logger log = LoggerFactory.getLogger(PortalManagerImpl.class);
    private Map<String, Portal> portals;
    private Map<String, Long> lastModified;
    private Map<String, File> portalFiles;
    private File portalsDir;
    private String defaultPortal;
    private String defaultSkin;
    private String defaultDisplay;
    private List<String> skinPriority;

    public PortalManagerImpl() {
        this.log.debug("Creating PortalManagerImpl");
        try {
            String home;
            File homeDir;
            JsonSimpleConfig config = new JsonSimpleConfig();
            this.defaultPortal = config.getString("default", new Object[]{"portal", "defaultView"});
            this.defaultSkin = config.getString("default", new Object[]{"portal", "skins", "default"});
            this.defaultDisplay = config.getString("default", new Object[]{"portal", "displays", "default"});
            this.skinPriority = config.getStringList(new Object[]{"portal", "skins", "order"});
            if (!this.skinPriority.contains(this.defaultSkin)) {
                this.skinPriority.add(this.defaultSkin);
            }
            if (!(homeDir = new File(home = config.getString("portal", new Object[]{"portal", "home"}))).exists()) {
                home = "src/main/config/portal";
            }
            this.init(home);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void init(String portalsDir) {
        try {
            this.portalsDir = new File(portalsDir);
            this.lastModified = new HashMap<String, Long>();
            this.portalFiles = new HashMap<String, File>();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, Portal> getPortals() {
        if (this.portals == null) {
            this.portals = new HashMap<String, Portal>();
            this.loadPortals();
        }
        return this.portals;
    }

    @Override
    public Portal getDefault() {
        return this.get(this.defaultPortal);
    }

    @Override
    public File getHomeDir() {
        return this.portalsDir;
    }

    @Override
    public Portal get(String name) {
        Portal portal = null;
        if (this.getPortals().containsKey(name)) {
            if (this.lastModified.containsKey(name) && this.lastModified.get(name) < this.portalFiles.get(name).lastModified()) {
                this.loadPortal(name);
            }
            portal = this.getPortals().get(name);
        } else {
            portal = this.loadPortal(name);
        }
        return portal;
    }

    @Override
    public boolean exists(String name) {
        return this.getPortals().containsKey(name);
    }

    @Override
    public void add(Portal portal) {
        String portalName = portal.getName();
        this.getPortals().put(portalName, portal);
    }

    @Override
    public void remove(String name) {
        File portalDir = new File(this.portalsDir, name);
        File portalFile = new File(portalDir, PORTAL_JSON);
        portalFile.delete();
        this.getPortals().remove(name);
    }

    @Override
    public void save(Portal portal) {
        String portalName = portal.getName();
        File portalFile = new File(new File(this.portalsDir, FilenameUtils.normalize((String)portalName)), PORTAL_JSON);
        portalFile.getParentFile().mkdirs();
        try {
            FileWriter writer = new FileWriter(portalFile);
            writer.write(portal.toString(true));
            writer.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }

    private void loadPortals() {
        File[] portalDirs;
        for (File dir : portalDirs = this.portalsDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return file.isDirectory() && !name.equals(".svn");
            }
        })) {
            this.loadPortal(dir.getName());
        }
    }

    private Portal loadPortal(String name) {
        Portal portal = null;
        File portalFile = new File(new File(this.portalsDir, name), PORTAL_JSON);
        if (portalFile.exists()) {
            this.lastModified.put(name, portalFile.lastModified());
            this.portalFiles.put(name, portalFile);
            try {
                portal = new Portal(portalFile);
                this.add(portal);
            }
            catch (IOException e) {
                this.log.warn("Portal: " + name + " failed to load", (Throwable)e);
            }
        }
        return portal;
    }

    @Override
    public void reharvest(String objectId) {
        try {
            HarvestClient client = new HarvestClient();
            client.reharvest(objectId, true);
        }
        catch (Exception e) {
            this.log.error("Object reharvest failed", (Throwable)e);
        }
    }

    @Override
    public void reharvest(Set<String> objectIds) {
        try {
            HarvestClient client = new HarvestClient();
            for (String oid : objectIds) {
                client.reharvest(oid);
            }
        }
        catch (Exception e) {
            this.log.error("Portal reharvest failed", (Throwable)e);
        }
    }

    @Override
    public String getDefaultPortal() {
        return this.defaultPortal;
    }

    @Override
    public String getDefaultDisplay() {
        return this.defaultDisplay;
    }

    @Override
    public List<String> getSkinPriority() {
        return this.skinPriority;
    }
}

