/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.workflow;

import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.FascinatorHome;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.messaging.MessagingException;
import com.googlecode.fascinator.common.messaging.MessagingServices;
import com.googlecode.fascinator.common.storage.StorageUtils;
import com.googlecode.fascinator.portal.FormData;
import com.googlecode.fascinator.portal.services.VelocityService;
import com.googlecode.fascinator.portal.workflow.SimpleWorkflowPageCache;
import com.googlecode.fascinator.portal.workflow.SimpleWorkflowPageCacheKey;
import com.googlecode.fascinator.portal.workflow.components.HtmlButton;
import com.googlecode.fascinator.portal.workflow.components.HtmlDiv;
import com.googlecode.fascinator.portal.workflow.components.HtmlFieldElement;
import com.googlecode.fascinator.portal.workflow.components.HtmlForm;
import com.googlecode.fascinator.portal.workflow.components.HtmlFormLayout;
import com.googlecode.fascinator.portal.workflow.components.HtmlValidationFunction;
import com.googlecode.fascinator.spring.ApplicationContextProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.tapestry5.internal.KeyValue;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.json.simple.JSONArray;

public class SimpleWorkflowHelper {
    private Storage storage = null;
    private VelocityService velocityService = null;
    private JsonSimple systemConfiguration = null;
    private String portalId = null;
    private VelocityContext parentVelocityContext = null;
    private VelocityContext baseVelocityContext = new VelocityContext();
    private MessagingServices messagingServices = MessagingServices.getInstance();
    private SimpleWorkflowPageCache cachedPages = (SimpleWorkflowPageCache)ApplicationContextProvider.getApplicationContext().getBean("simpleWorkflowPageCache");

    public String updateWorkflowMetadata(String oid, String action) throws StorageException, IOException {
        String targetStep = null;
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        JsonSimple workflowMetadata = this.getWorkflowMetadata(digitalObject);
        String workflowId = workflowMetadata.getString(null, new Object[]{"id"});
        JsonSimple workflowConfiguration = this.getWorkflowConfiguration(workflowId);
        JSONArray workflowStages = workflowConfiguration.getArray(new Object[]{"stages"});
        JsonObject workflowStageConfiguration = null;
        for (int i = 0; i < workflowStages.size(); ++i) {
            JsonObject workflowStage = (JsonObject)workflowStages.get(i);
            if (!workflowMetadata.getJsonObject().get((Object)"step").equals(workflowStage.get((Object)"name"))) continue;
            workflowStageConfiguration = workflowStage;
            break;
        }
        JSONArray workflowStepActions = (JSONArray)workflowStageConfiguration.get((Object)"actions");
        for (int i = 0; i < workflowStepActions.size(); ++i) {
            JsonObject workflowStepAction = (JsonObject)workflowStepActions.get(i);
            if (!action.equals(workflowStepAction.get((Object)"action-name"))) continue;
            targetStep = (String)workflowStepAction.get((Object)"target-step");
            this.progressActionToNextStep(digitalObject, workflowMetadata, targetStep);
        }
        return targetStep;
    }

    private void progressActionToNextStep(DigitalObject digitalObject, JsonSimple workflowMetadata, String targetStep) throws StorageException {
        workflowMetadata.getJsonObject().put((Object)"targetStep", (Object)targetStep);
        digitalObject.updatePayload("workflow.metadata", (InputStream)new ByteArrayInputStream(workflowMetadata.toString().getBytes()));
    }

    public void updateObjectMetadata(String oid, List<KeyValue> data) throws StorageException, IOException {
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        Properties tfObjMeta = digitalObject.getMetadata();
        for (KeyValue keyValue : data) {
            tfObjMeta.setProperty(keyValue.getKey(), keyValue.getValue());
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        tfObjMeta.store(output, null);
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        StorageUtils.createOrUpdatePayload((DigitalObject)digitalObject, (String)"TF-OBJ-META", (InputStream)input);
    }

    public void updateTFPackage(String oid, FormData formData) throws StorageException, IOException {
        Matcher m;
        String pid = this.getTFPackagePid(oid);
        JsonSimple tfPackage = this.getTFPackage(oid, pid);
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        HashMap<String, Integer> repeatableFormFields = new HashMap<String, Integer>();
        Pattern p = Pattern.compile("([A-Za-z0-9\\.\\:]+\\.)([0-9]+)(\\.[A-Za-z0-9\\.\\:]*)");
        Set fields = formData.getFormFields();
        for (String field : fields) {
            String fieldValue = formData.get(field);
            if (fieldValue != null) {
                tfPackage.getJsonObject().put((Object)field, (Object)fieldValue);
            }
            m = p.matcher(field);
            m.find();
            if (!m.matches()) continue;
            String fieldId = m.group(1) + "0" + m.group(3);
            int fieldIndex = new Integer(m.group(2));
            Integer count = (Integer)repeatableFormFields.get(fieldId);
            if (count != null && count >= fieldIndex) continue;
            repeatableFormFields.put(fieldId, fieldIndex);
        }
        for (String repeatableFormField : repeatableFormFields.keySet()) {
            int count = (Integer)repeatableFormFields.get(repeatableFormField);
            ++count;
            m = p.matcher(repeatableFormField);
            m.find();
            while (this.existsInTFPackage(tfPackage, m.group(1) + count + m.group(3))) {
                tfPackage.getJsonObject().remove((Object)(m.group(1) + count + m.group(3)));
                ++count;
            }
        }
        digitalObject.updatePayload(pid, (InputStream)new ByteArrayInputStream(tfPackage.toString().getBytes()));
    }

    private boolean existsInTFPackage(JsonSimple tfPackage, String path) {
        return tfPackage.getJsonObject().get((Object)path) != null;
    }

    public void reindex(String oid, String step, String username) throws StorageException, IOException, MessagingException {
        JsonObject message = new JsonObject();
        message.put((Object)"oid", (Object)oid);
        if (step == null) {
            message.put((Object)"eventType", (Object)"ReIndex");
        } else {
            message.put((Object)"eventType", (Object)("NewStep : " + step));
            message.put((Object)"newStep", (Object)step);
        }
        message.put((Object)"quickIndex", (Object)true);
        message.put((Object)"username", (Object)username);
        message.put((Object)"context", (Object)"Workflow");
        message.put((Object)"task", (Object)"workflow");
        this.messagingServices.queueMessage("transactionManager", message.toString());
    }

    private JsonSimple getTFPackage(String oid, String pid) throws StorageException, IOException {
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        InputStream tfPackageInputStream = digitalObject.getPayload(pid).open();
        return new JsonSimple(tfPackageInputStream);
    }

    public JsonSimple getTFPackage(String oid) throws StorageException, IOException {
        return this.getTFPackage(oid, this.getTFPackagePid(oid));
    }

    private String getTFPackagePid(String oid) throws StorageException {
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        for (String pid : digitalObject.getPayloadIdList()) {
            if (!pid.endsWith("tfpackage")) continue;
            return pid;
        }
        return null;
    }

    public String getFormHtml(String oid) throws Exception {
        JsonObject formLayout;
        JSONArray customValidators;
        JSONArray formJsonArray;
        DigitalObject digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        JsonSimple workflowMetadata = this.getWorkflowMetadata(digitalObject);
        String workflowId = workflowMetadata.getString(null, new Object[]{"id"});
        JsonSimple workflowConfiguration = this.getWorkflowConfiguration(workflowId);
        JsonSimple formConfiguration = this.getFormConfiguration(workflowConfiguration);
        String step = workflowMetadata.getString(null, new Object[]{"step"});
        SimpleWorkflowPageCacheKey key = new SimpleWorkflowPageCacheKey(this.portalId, workflowId, step);
        this.buildBaseVelocityContext();
        HtmlForm form = new HtmlForm();
        JsonObject stepObject = formConfiguration.getObject(new Object[]{"stages", step});
        if (stepObject.get((Object)"config-file") != null) {
            stepObject = this.getJsonObject((String)stepObject.get((Object)"config-file"));
            formJsonArray = (JSONArray)stepObject.get((Object)"divs");
        } else {
            formJsonArray = (JSONArray)stepObject.get((Object)"divs");
        }
        String htmlFooter = (String)stepObject.get((Object)"form-footer");
        if (htmlFooter != null) {
            form.setHtmlFooter(htmlFooter);
        }
        if (this.cachedPages.containsKey((Object)key)) {
            return this.renderPageTemplate((Template)this.cachedPages.get((Object)key), form);
        }
        for (int i = 0; i < formJsonArray.size(); ++i) {
            JsonObject htmlDivJson = (JsonObject)formJsonArray.get(i);
            if (htmlDivJson.get((Object)"config-file") != null) {
                htmlDivJson = this.getJsonObject((String)htmlDivJson.get((Object)"config-file"));
            }
            form.addHtmlDiv(this.getHtmlDiv(htmlDivJson));
        }
        JSONArray buttonJsonArray = (JSONArray)stepObject.get((Object)"buttons");
        for (int i = 0; i < buttonJsonArray.size(); ++i) {
            form.addHtmlButton(this.getHtmlButton((JsonObject)buttonJsonArray.get(i)));
        }
        JsonObject validationFunction = (JsonObject)stepObject.get((Object)"validation-function");
        if (validationFunction != null) {
            form.setValidationFunction(this.getValidationFunction(validationFunction));
        }
        if ((customValidators = (JSONArray)stepObject.get((Object)"validators")) != null) {
            form.setCustomValidators(this.getValidatorList(customValidators));
        }
        if ((formLayout = (JsonObject)stepObject.get((Object)"form-layout")) != null) {
            form.setHtmlFormLayout(this.getFormLayout(formLayout));
        }
        String output = this.renderFormHtml(form);
        RuntimeServices runtimeServices = RuntimeSingleton.getRuntimeServices();
        StringReader reader = new StringReader(output);
        SimpleNode node = runtimeServices.parse((Reader)reader, "template");
        Template template = new Template();
        template.setRuntimeServices(runtimeServices);
        template.setData((Object)node);
        template.initDocument();
        this.cachedPages.put((Object)key, (Object)template);
        return this.renderPageTemplate(template, form);
    }

    private void buildBaseVelocityContext() {
        for (Object key : this.parentVelocityContext.getKeys()) {
            if (key.equals("formData") || key.equals("velocityContext")) continue;
            this.baseVelocityContext.put((String)key, this.parentVelocityContext.get((String)key));
        }
    }

    private String renderPageTemplate(Template template, HtmlForm form) throws Exception {
        VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
        FormData formData = (FormData)this.parentVelocityContext.get("formData");
        for (String field : formData.getFormFields()) {
            vc.put(field, (Object)formData.get(field));
        }
        String formFooterHtml = this.renderFormFooterHtml(form.getHtmlFooter());
        vc.put("formFooterHtml", (Object)formFooterHtml);
        StringWriter writer = new StringWriter();
        template.merge((Context)vc, (Writer)writer);
        return writer.toString();
    }

    private JsonObject getJsonObject(String jsonObjectPath) throws IOException {
        File workflowConfigFile = FascinatorHome.getPathFile((String)jsonObjectPath);
        return new JsonSimple(workflowConfigFile).getJsonObject();
    }

    private List<String> getValidatorList(JSONArray customValidators) {
        ArrayList<String> validatorList = new ArrayList<String>();
        for (int i = 0; i < customValidators.size(); ++i) {
            validatorList.add((String)customValidators.get(i));
        }
        return validatorList;
    }

    private HtmlValidationFunction getValidationFunction(JsonObject jsonObject) {
        HtmlValidationFunction htmlValidationFunction = new HtmlValidationFunction();
        htmlValidationFunction.setComponentTemplateName((String)jsonObject.get((Object)"component-type"));
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Set keys = jsonObject.keySet();
        for (Object key : keys) {
            parameterMap.put((String)key, jsonObject.get(key));
        }
        htmlValidationFunction.setParameterMap(parameterMap);
        return htmlValidationFunction;
    }

    private HtmlFormLayout getFormLayout(JsonObject jsonObject) {
        HtmlFormLayout htmlFormLayout = new HtmlFormLayout();
        htmlFormLayout.setComponentTemplateName((String)jsonObject.get((Object)"component-type"));
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Set keys = jsonObject.keySet();
        for (Object key : keys) {
            parameterMap.put((String)key, jsonObject.get(key));
        }
        htmlFormLayout.setParameterMap(parameterMap);
        return htmlFormLayout;
    }

    private String renderFormHtml(HtmlForm form) throws Exception {
        String divElementsHtml = this.renderDivElementsHtml(form);
        String fieldElementsHtml = this.renderFieldElementsHtml(form.getHtmlFieldElements());
        String buttonElementsHtml = this.renderButtonElementsHtml(form);
        String validationFunction = this.renderValidationFunction(form.getValidationFunction());
        String formLayout = "";
        if (form.getHtmlFormLayout() != null) {
            formLayout = this.renderFormLayoutCode(form.getHtmlFormLayout());
        }
        String validatorFunctions = this.renderValidatorFunctions(form.getCustomValidators());
        VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
        vc.put("fieldElementsHtml", (Object)fieldElementsHtml);
        vc.put("buttonElementsHtml", (Object)buttonElementsHtml);
        vc.put("divElementsHtml", (Object)divElementsHtml);
        vc.put("formLayoutCode", (Object)formLayout);
        vc.put("validationFunction", (Object)validationFunction);
        vc.put("validatorFunctions", (Object)validatorFunctions);
        StringWriter pageContentWriter = new StringWriter();
        this.velocityService.renderTemplate(this.portalId, "form-components/form-template", (Context)vc, (Writer)pageContentWriter);
        return pageContentWriter.toString();
    }

    private String renderValidatorFunctions(List<String> customValidators) throws Exception {
        VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
        String portalHome = this.systemConfiguration.getString("portal", new Object[]{"portal", "home"});
        File coreValidatorDir = new File(portalHome + "/default/default/form-components/validators");
        if (coreValidatorDir.exists()) {
            String[] defaultValidators;
            for (String defaultValidator : defaultValidators = coreValidatorDir.list((FilenameFilter)new SuffixFileFilter(".vm"))) {
                customValidators.add(defaultValidator.substring(0, defaultValidator.length() - 3));
            }
        }
        String validatorFunctions = "";
        for (String validator : customValidators) {
            if (this.velocityService.resourceExists(this.portalId, "form-components/validators/" + validator + ".vm") == null) continue;
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, "form-components/validators/" + validator, (Context)vc, (Writer)pageContentWriter);
            validatorFunctions = validatorFunctions + pageContentWriter.toString();
        }
        return validatorFunctions;
    }

    private String renderFormLayoutCode(HtmlFormLayout htmlFormLayout) throws Exception {
        VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
        if (this.velocityService.resourceExists(this.portalId, "form-components/form-layouts/" + htmlFormLayout.getComponentTemplateName() + ".vm") != null) {
            Map parameterMap = htmlFormLayout.getParameterMap();
            Set keySet = parameterMap.keySet();
            for (String key : keySet) {
                vc.put(key, parameterMap.get(key));
            }
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, "form-components/form-layouts/" + htmlFormLayout.getComponentTemplateName(), (Context)vc, (Writer)pageContentWriter);
            return pageContentWriter.toString();
        }
        String formLayoutCode = "";
        return formLayoutCode;
    }

    private String renderValidationFunction(HtmlValidationFunction validationFunction) throws Exception {
        VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
        String validationFunctionTemplate = validationFunction.getComponentTemplateName();
        if (this.velocityService.resourceExists(this.portalId, "form-components/validation-functions/" + validationFunctionTemplate + ".vm") != null) {
            Map parameterMap = validationFunction.getParameterMap();
            Set keySet = parameterMap.keySet();
            for (String key : keySet) {
                vc.put(key, parameterMap.get(key));
            }
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, "form-components/validation-functions/" + validationFunctionTemplate, (Context)vc, (Writer)pageContentWriter);
            return pageContentWriter.toString();
        }
        String validationFunctionString = "function doValidation() { return true;}";
        return validationFunctionString;
    }

    private String renderFormFooterHtml(String htmlFooterTemplate) throws Exception {
        VelocityContext vc = new VelocityContext((Context)this.parentVelocityContext);
        if (this.velocityService.resourceExists(this.portalId, "form-components/" + htmlFooterTemplate + ".vm") != null) {
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, "form-components/" + htmlFooterTemplate, (Context)vc, (Writer)pageContentWriter);
            return pageContentWriter.toString();
        }
        return "";
    }

    private String renderDivElementsHtml(HtmlForm form) throws Exception {
        String divElementsHtml = "";
        List htmlDivs = form.getHtmlDivs();
        int divorder = 1;
        for (HtmlDiv htmlDiv : htmlDivs) {
            String htmlDivTemplate = "form-components/" + htmlDiv.getComponentTemplateName();
            if (this.velocityService.resourceExists(this.portalId, htmlDivTemplate + ".vm") == null) continue;
            String fieldElementsHtml = this.renderFieldElementsHtml(htmlDiv.getHtmlFieldElements());
            VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
            vc.put("divorder", (Object)divorder++);
            vc.put("fieldElementsHtml", (Object)fieldElementsHtml);
            Map parameterMap = htmlDiv.getParameterMap();
            Set keySet = parameterMap.keySet();
            for (String key : keySet) {
                vc.put(key, parameterMap.get(key));
            }
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, htmlDivTemplate, (Context)vc, (Writer)pageContentWriter);
            divElementsHtml = divElementsHtml + pageContentWriter.toString();
        }
        return divElementsHtml;
    }

    private String renderButtonElementsHtml(HtmlForm form) throws Exception {
        String buttonElementsHtml = "";
        List htmlButtons = form.getHtmlButtons();
        for (HtmlButton htmlButton : htmlButtons) {
            String pageName = "form-components/button-elements/" + htmlButton.getComponentTemplateName();
            if (this.velocityService.resourceExists(this.portalId, pageName + ".vm") == null) continue;
            VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
            Map parameterMap = htmlButton.getParameterMap();
            Set keySet = parameterMap.keySet();
            for (String key : keySet) {
                vc.put(key, parameterMap.get(key));
            }
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, pageName, (Context)vc, (Writer)pageContentWriter);
            buttonElementsHtml = buttonElementsHtml + pageContentWriter.toString();
        }
        VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
        vc.put("buttonHtml", (Object)buttonElementsHtml);
        StringWriter pageContentWriter = new StringWriter();
        this.velocityService.renderTemplate(this.portalId, "form-components/button-wrapper", (Context)vc, (Writer)pageContentWriter);
        buttonElementsHtml = pageContentWriter.toString();
        return buttonElementsHtml;
    }

    private String renderFieldElementsHtml(List<HtmlFieldElement> htmlfieldElements) throws Exception {
        String fieldElementsHtml = "";
        for (HtmlFieldElement htmlFieldElement : htmlfieldElements) {
            if ("group".equals(htmlFieldElement.getComponentTemplateName())) {
                fieldElementsHtml = fieldElementsHtml + this.renderGroupElement(htmlFieldElement);
                continue;
            }
            String fieldElementName = "form-components/field-elements/" + htmlFieldElement.getComponentTemplateName();
            String buttonElementName = "form-components/button-elements/" + htmlFieldElement.getComponentTemplateName();
            String fieldElementHtml = "";
            if (this.velocityService.resourceExists(this.portalId, fieldElementName + ".vm") != null) {
                fieldElementHtml = this.renderHtmlFieldElement(htmlFieldElement, fieldElementName);
            } else if (this.velocityService.resourceExists(this.portalId, buttonElementName + ".vm") != null) {
                fieldElementHtml = this.renderHtmlFieldElement(htmlFieldElement, buttonElementName);
            }
            fieldElementsHtml = fieldElementsHtml + fieldElementHtml;
        }
        return fieldElementsHtml;
    }

    private String renderHtmlFieldElement(HtmlFieldElement htmlFieldElement, String fieldElementName) throws Exception {
        VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
        Map parameterMap = htmlFieldElement.getParameterMap();
        Set keySet = parameterMap.keySet();
        for (String key : keySet) {
            vc.put(key, parameterMap.get(key));
        }
        StringWriter pageContentWriter = new StringWriter();
        this.velocityService.renderTemplate(this.portalId, fieldElementName, (Context)vc, (Writer)pageContentWriter);
        String componentHtml = pageContentWriter.toString();
        if (htmlFieldElement.hasValidation()) {
            vc.put("validation", (Object)htmlFieldElement.getValidation());
            vc.put("elementHtml", (Object)componentHtml);
            pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(this.portalId, "form-components/validation-wrapper", (Context)vc, (Writer)pageContentWriter);
            componentHtml = pageContentWriter.toString();
        }
        vc.put("elementHtml", (Object)componentHtml);
        pageContentWriter = new StringWriter();
        this.velocityService.renderTemplate(this.portalId, "form-components/component-wrapper", (Context)vc, (Writer)pageContentWriter);
        String fieldElementHtml = pageContentWriter.toString();
        return fieldElementHtml;
    }

    private String renderGroupElement(HtmlFieldElement htmlFieldElement) throws Exception {
        JSONArray fieldsArray = (JSONArray)htmlFieldElement.getParameterMap().get("fields");
        ArrayList<HtmlFieldElement> fieldElements = new ArrayList<HtmlFieldElement>();
        for (int i = 0; i < fieldsArray.size(); ++i) {
            fieldElements.add(this.getHtmlComponent((JsonObject)fieldsArray.get(i)));
        }
        String fieldElementsHtml = this.renderFieldElementsHtml(fieldElements);
        String groupTemplate = (String)htmlFieldElement.getParameterMap().get("template");
        StringWriter pageContentWriter = new StringWriter();
        if (this.velocityService.resourceExists(this.portalId, "form-components/field-elements/" + groupTemplate + ".vm") != null) {
            VelocityContext vc = new VelocityContext((Context)this.baseVelocityContext);
            vc.put("fieldElementsHtml", (Object)fieldElementsHtml);
            Set keys = htmlFieldElement.getParameterMap().keySet();
            for (String key : keys) {
                vc.put(key, htmlFieldElement.getParameterMap().get(key));
            }
            this.velocityService.renderTemplate(this.portalId, "form-components/field-elements/" + groupTemplate, (Context)vc, (Writer)pageContentWriter);
        }
        return pageContentWriter.toString();
    }

    private HtmlFieldElement getHtmlComponent(JsonObject jsonObject) {
        HtmlFieldElement htmlComponent = new HtmlFieldElement();
        htmlComponent.setComponentTemplateName((String)jsonObject.get((Object)"component-type"));
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Set keys = jsonObject.keySet();
        for (Object key : keys) {
            parameterMap.put((String)key, jsonObject.get(key));
        }
        if (jsonObject.get((Object)"validation") != null) {
            htmlComponent.setValidation((JsonObject)jsonObject.get((Object)"validation"));
        }
        htmlComponent.setParameterMap(parameterMap);
        return htmlComponent;
    }

    private HtmlDiv getHtmlDiv(JsonObject jsonObject) {
        HtmlDiv htmlDiv = new HtmlDiv();
        String componentTemplateName = (String)jsonObject.get((Object)"component-type");
        if (componentTemplateName != null) {
            htmlDiv.setComponentTemplateName(componentTemplateName);
        }
        JSONArray formJsonArray = (JSONArray)jsonObject.get((Object)"fields");
        for (int i = 0; i < formJsonArray.size(); ++i) {
            htmlDiv.addHtmlFieldElement(this.getHtmlComponent((JsonObject)formJsonArray.get(i)));
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Set keys = jsonObject.keySet();
        for (Object key : keys) {
            parameterMap.put((String)key, jsonObject.get(key));
        }
        htmlDiv.setParameterMap(parameterMap);
        return htmlDiv;
    }

    private HtmlButton getHtmlButton(JsonObject jsonObject) {
        HtmlButton htmlButton = new HtmlButton();
        htmlButton.setComponentTemplateName((String)jsonObject.get((Object)"component-type"));
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Set keys = jsonObject.keySet();
        for (Object key : keys) {
            parameterMap.put((String)key, jsonObject.get(key));
        }
        htmlButton.setParameterMap(parameterMap);
        return htmlButton;
    }

    private JsonSimple getFormConfiguration(JsonSimple workflowConfiguration) throws IOException {
        String formConfigFileLocation = workflowConfiguration.getString(null, new Object[]{"form-configuration"});
        File formConfigFile = FascinatorHome.getPathFile((String)formConfigFileLocation);
        return new JsonSimple(formConfigFile);
    }

    private JsonSimple getWorkflowConfiguration(String workflowId) throws IOException {
        String workflowConfigFileLocation = (String)this.systemConfiguration.getObject(new Object[]{"portal", "packageTypes", workflowId}).get((Object)"jsonconfig");
        File workflowConfigFile = FascinatorHome.getPathFile((String)("harvest/workflows/" + workflowConfigFileLocation));
        return new JsonSimple(workflowConfigFile);
    }

    private JsonSimple getWorkflowMetadata(DigitalObject digitalObject) throws StorageException, IOException {
        return new JsonSimple(digitalObject.getPayload("workflow.metadata").open());
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public void setSystemConfiguration(JsonSimple systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
    }

    public void setVelocityService(VelocityService velocityService) {
        this.velocityService = velocityService;
    }

    public void setPortalId(String portalId) {
        this.portalId = portalId;
    }

    public void setParentVelocityContext(VelocityContext parentVelocityContext) {
        this.parentVelocityContext = parentVelocityContext;
    }
}

