/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.quartz;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.codec.digest.DigestUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalJob
implements Job {
    private Logger log = LoggerFactory.getLogger(ExternalJob.class);
    private String name;
    private URL url;
    private String token;
    private boolean broken;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.broken = false;
        this.name = context.getJobDetail().getName();
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        String urlString = dataMap.getString("url");
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            this.broken = true;
            this.log.error("URL is invalid: ", (Throwable)ex);
        }
        this.token = dataMap.getString("token");
        if (this.token != null) {
            this.token = DigestUtils.md5Hex((String)this.token);
        }
        if (!this.broken) {
            this.runJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJob() {
        HttpURLConnection conn = null;
        this.log.debug("Job firing: '{}'", (Object)this.name);
        try {
            if (this.token == null) {
                conn = (HttpURLConnection)this.url.openConnection();
            } else {
                String param = "token=" + URLEncoder.encode(this.token, "UTF-8");
                conn = (HttpURLConnection)this.url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", "" + Integer.toString(param.getBytes().length));
                conn.setUseCaches(false);
                conn.setDoOutput(true);
                DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                wr.writeBytes(param);
                wr.flush();
                wr.close();
            }
            if (conn.getResponseCode() != 200) {
                this.log.error("Error hitting external script: {}", (Object)conn.getResponseMessage());
            }
        }
        catch (IOException ex) {
            this.log.error("Error connecting to URL: ", (Throwable)ex);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }
}

