/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.security;

import com.googlecode.fascinator.api.access.AccessControl;
import com.googlecode.fascinator.api.access.AccessControlException;
import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.api.storage.StorageException;
import com.googlecode.fascinator.common.FascinatorHome;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.storage.StorageUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;

public class FascinatorWebSecurityExpressionRoot
extends WebSecurityExpressionRoot {
    private Logger log = LoggerFactory.getLogger(FascinatorWebSecurityExpressionRoot.class);
    private Storage storage;
    private JsonSimpleConfig systemConfiguration;
    private AccessControl accessControl;
    private JsonSimple workflowConfigJson;
    private static final String OID_PATTERN = ".+([0-9a-f]{32}).*";

    public FascinatorWebSecurityExpressionRoot(Authentication a, FilterInvocation fi) {
        super(a, fi);
        try {
            this.systemConfiguration = new JsonSimpleConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FascinatorWebSecurityExpressionRoot(Authentication authentication, FilterInvocation fi, Storage storage, AccessControl accessControl) {
        this(authentication, fi);
        this.storage = storage;
        this.accessControl = accessControl;
    }

    public boolean hasDownloadAccess() {
        return this.hasDownloadAccess(OID_PATTERN);
    }

    public boolean hasDownloadAccess(String oidPattern) {
        if (this.isAdmin()) {
            return true;
        }
        String oid = this.getOid(oidPattern);
        DigitalObject digitalObject = this.getDigitalObject(oid);
        try {
            Properties tfObjMeta = digitalObject.getMetadata();
            if (this.isPublished(tfObjMeta)) {
                return true;
            }
            if (this.isOwner(tfObjMeta)) {
                return true;
            }
            if (this.isInAllowedRoles(oid)) {
                return true;
            }
            if (this.isInAllowedUsers(oid)) {
                return true;
            }
        }
        catch (Exception e) {
            this.log.error("hasDownloadAccess check failed", (Throwable)e);
        }
        return false;
    }

    private boolean isAdmin() {
        return this.authentication.getAuthorities().contains("admin");
    }

    public boolean hasViewAccess() {
        return this.hasViewAccess(OID_PATTERN);
    }

    public boolean hasViewAccess(String oidPattern) {
        block8: {
            String oid = this.getOid(oidPattern);
            if (oid != null) {
                try {
                    DigitalObject digitalObject = this.getDigitalObject(oid);
                    if (digitalObject != null) {
                        Properties tfObjMeta = digitalObject.getMetadata();
                        if (this.isPublished(tfObjMeta)) {
                            return true;
                        }
                        if (this.isOwner(tfObjMeta)) {
                            return true;
                        }
                        if (this.isInAllowedRoles(oid)) {
                            return true;
                        }
                        if (this.isInAllowedUsers(oid)) {
                            return true;
                        }
                        break block8;
                    }
                    return false;
                }
                catch (Exception e) {
                    this.log.error("Failed to check view access: ", (Throwable)e);
                }
            }
        }
        return false;
    }

    public boolean isInAllowedUsers() {
        return this.isInAllowedUsers(OID_PATTERN);
    }

    public boolean isInAllowedUsers(String oid) {
        String userName = (String)this.authentication.getPrincipal();
        try {
            List allowedUsers = this.accessControl.getUsers(oid);
            if (allowedUsers != null) {
                for (String allowedUserName : allowedUsers) {
                    if (!allowedUserName.equals(userName)) continue;
                    return true;
                }
            }
        }
        catch (AccessControlException e) {
            return false;
        }
        return false;
    }

    public boolean isPublished() {
        String oid = this.getOid(OID_PATTERN);
        if (oid != null) {
            try {
                DigitalObject digitalObject = this.getDigitalObject(oid);
                if (digitalObject != null) {
                    Properties tfObjMeta = digitalObject.getMetadata();
                    return this.isPublished(tfObjMeta);
                }
            }
            catch (Exception e) {
                this.log.error("Failed to check property of isPublished.", (Throwable)e);
            }
        }
        return false;
    }

    private boolean isPublished(Properties tfObjMeta) {
        return "true".equals(tfObjMeta.get("published"));
    }

    public boolean isOwner() {
        return this.isOwner(OID_PATTERN);
    }

    public boolean isOwner(String oidPattern) {
        String oid = this.getOid(oidPattern);
        if (oid != null) {
            try {
                DigitalObject digitalObject = this.getDigitalObject(oid);
                if (digitalObject != null) {
                    Properties tfObjMeta = digitalObject.getMetadata();
                    return this.isOwner(tfObjMeta);
                }
            }
            catch (Exception e) {
                this.log.error("Failed to check ownership", (Throwable)e);
            }
        }
        return false;
    }

    private boolean isOwner(Properties tfObjMeta) {
        String owner;
        String userName = (String)this.authentication.getPrincipal();
        return userName.equals(owner = tfObjMeta.getProperty("owner"));
    }

    public boolean isInAllowedRoles() {
        String oid = this.getOid(OID_PATTERN);
        return this.isInAllowedRoles(oid);
    }

    public boolean isInAllowedRoles(String oid) {
        try {
            List allowedRoles = this.accessControl.getRoles(oid);
            if (allowedRoles != null) {
                Collection userRoles = this.authentication.getAuthorities();
                for (GrantedAuthority grantedAuthority : userRoles) {
                    if (!allowedRoles.contains(grantedAuthority.getAuthority())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Failed to check allowed roles", (Throwable)e);
        }
        return false;
    }

    public boolean hasWorkflowAccess() {
        return this.hasWorkflowAccess(OID_PATTERN);
    }

    public boolean hasWorkflowAccess(String oidPattern) {
        boolean hasAccess = false;
        try {
            String oid = this.getOid(oidPattern);
            if (oid != null) {
                DigitalObject digitalObject = this.getDigitalObject(oid);
                JsonObject workflowStageConfiguration = this.getWorkflowStageConfig(digitalObject);
                if (this.isGuestOwnerEditAllowed(workflowStageConfiguration)) {
                    return true;
                }
                if (this.isOwnerEditAllowed(digitalObject, workflowStageConfiguration)) {
                    return true;
                }
                if (this.isInAllowedRoles(oid)) {
                    return true;
                }
            } else {
                hasAccess = false;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to check workflow access: ", (Throwable)e);
            hasAccess = false;
        }
        return hasAccess;
    }

    public boolean isOwnerEditAllowed() {
        String oid = this.getOid(OID_PATTERN);
        try {
            if (oid != null) {
                DigitalObject digitalObject = this.getDigitalObject(oid);
                JsonObject workflowStageConfiguration = this.getWorkflowStageConfig(digitalObject);
                return this.isOwnerEditAllowed(digitalObject, workflowStageConfiguration);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to check OwnerEditAllowed property", (Throwable)e);
        }
        return false;
    }

    private boolean isOwnerEditAllowed(DigitalObject digitalObject, JsonObject workflowStageConfiguration) {
        String ownerEditAllowed = (String)workflowStageConfiguration.get((Object)"owner_edit_allowed");
        if (ownerEditAllowed != null && Boolean.parseBoolean(ownerEditAllowed)) {
            Properties tfObjMeta;
            try {
                tfObjMeta = digitalObject.getMetadata();
            }
            catch (StorageException e) {
                this.log.error("Failed to read metadata from object", (Throwable)e);
                return false;
            }
            return this.isOwner(tfObjMeta);
        }
        return false;
    }

    public boolean hasAPIAccess() {
        JsonObject clientObject;
        String apiKey = this.request.getParameter("apiKey");
        return !StringUtils.isEmpty((String)apiKey) && (clientObject = this.systemConfiguration.getObject(new Object[]{"api", "clients", apiKey})) != null;
    }

    public boolean isGuestOwnerEditAllowed() {
        String oid = this.getOid(OID_PATTERN);
        try {
            if (oid != null) {
                DigitalObject digitalObject = this.getDigitalObject(oid);
                JsonObject workflowStageConfiguration = this.getWorkflowStageConfig(digitalObject);
                return this.isGuestOwnerEditAllowed(workflowStageConfiguration);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to check GuestOwnerEditAllowed property", (Throwable)e);
        }
        return false;
    }

    private boolean isGuestOwnerEditAllowed(JsonObject workflowStageConfiguration) {
        String guestOwnerEditAllowed = (String)workflowStageConfiguration.get((Object)"guest_owner_edit_allowed");
        return guestOwnerEditAllowed != null && Boolean.parseBoolean(guestOwnerEditAllowed);
    }

    private String getOid(String oidPatthern) {
        Matcher m;
        Pattern p = Pattern.compile(oidPatthern);
        String requestURI = this.request.getRequestURI();
        if (!StringUtils.isEmpty((String)this.request.getQueryString())) {
            requestURI = requestURI + "?" + this.request.getQueryString();
        }
        if ((m = p.matcher(requestURI)).matches()) {
            return m.group(1);
        }
        return null;
    }

    private JsonObject getWorkflowStageConfig(DigitalObject digitalObject) throws StorageException, IOException {
        JsonSimple workflowMetadata = this.getWorkflowMetadata(digitalObject);
        String workflowId = workflowMetadata.getString(null, new Object[]{"id"});
        JsonSimple workflowConfiguration = this.getWorkflowConfiguration(workflowId);
        JSONArray workflowStages = workflowConfiguration.getArray(new Object[]{"stages"});
        JsonObject workflowStageConfiguration = null;
        for (int i = 0; i < workflowStages.size(); ++i) {
            JsonObject workflowStage = (JsonObject)workflowStages.get(i);
            if (!workflowMetadata.getJsonObject().get((Object)"step").equals(workflowStage.get((Object)"name"))) continue;
            workflowStageConfiguration = workflowStage;
            break;
        }
        return workflowStageConfiguration;
    }

    private JsonSimple getWorkflowConfiguration(String workflowId) throws IOException {
        if (this.workflowConfigJson == null) {
            String workflowConfigFileLocation = (String)this.systemConfiguration.getObject(new Object[]{"portal", "packageTypes", workflowId}).get((Object)"jsonconfig");
            File workflowConfigFile = FascinatorHome.getPathFile((String)("harvest/workflows/" + workflowConfigFileLocation));
            this.workflowConfigJson = new JsonSimple(workflowConfigFile);
        }
        return this.workflowConfigJson;
    }

    private DigitalObject getDigitalObject(String oid) {
        DigitalObject digitalObject = null;
        try {
            digitalObject = StorageUtils.getDigitalObject((Storage)this.storage, (String)oid);
        }
        catch (StorageException e) {
            this.log.error("When checking access, cannot get object {}", (Object)oid, (Object)e);
        }
        return digitalObject;
    }

    private JsonSimple getWorkflowMetadata(DigitalObject digitalObject) throws StorageException, IOException {
        return new JsonSimple(digitalObject.getPayload("workflow.metadata").open());
    }
}

