/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.security.filter;

import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.authentication.GenericUser;
import com.googlecode.fascinator.common.authentication.SpringUser;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.services.PortalSecurityManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONArray;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class FascinatorAuthenticationInterceptorFilter
extends OncePerRequestFilter {
    private AuthenticationManager authManager = null;
    private PortalSecurityManager portalSecurityManager;
    private Map<String, String> apiClients = new HashMap<String, String>();

    public FascinatorAuthenticationInterceptorFilter() throws IOException {
        JsonSimpleConfig config = new JsonSimpleConfig();
        JSONArray clients = config.getArray(new Object[]{"api", "clients"});
        if (clients != null) {
            for (Object clientObject : clients) {
                JsonObject client = (JsonObject)clientObject;
                if (client.get((Object)"apiKey") == null || client.get((Object)"username") == null) continue;
                this.apiClients.put((String)client.get((Object)"apiKey"), (String)client.get((Object)"username"));
            }
        }
    }

    public void setAuthManager(AuthenticationManager authManager) {
        this.authManager = authManager;
    }

    public void setPortalSecurityManager(PortalSecurityManager portalSecurityManager) {
        this.portalSecurityManager = portalSecurityManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        SpringUser user;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        JsonSessionState jsonSessionState = (JsonSessionState)request.getSession().getAttribute("sso:com.googlecode.fascinator.portal.JsonSessionState");
        if (jsonSessionState != null) {
            SpringUser user2;
            PreAuthenticatedAuthenticationToken token = null;
            if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
                if (jsonSessionState.get("username") != null) {
                    token = new PreAuthenticatedAuthenticationToken(jsonSessionState.get("username"), (Object)"password");
                    user2 = new SpringUser();
                    user2.setUsername((String)jsonSessionState.get("username"));
                    user2.setSource((String)jsonSessionState.get("source"));
                    token.setDetails((Object)user2);
                } else if (request.getParameter("apiKey") != null && this.apiClients.get(request.getParameter("apiKey")) != null) {
                    String username = this.apiClients.get(request.getParameter("apiKey"));
                    token = new PreAuthenticatedAuthenticationToken((Object)username, (Object)"password");
                    jsonSessionState.set("username", username);
                    jsonSessionState.set("source", "internal");
                    SpringUser user3 = new SpringUser();
                    user3.setUsername(username);
                    user3.setSource("internal");
                    token.setDetails((Object)user3);
                }
            } else if (jsonSessionState.get("username") != null && !authentication.getName().equals(jsonSessionState.get("username"))) {
                token = new PreAuthenticatedAuthenticationToken(jsonSessionState.get("username"), (Object)"password");
                user2 = new SpringUser();
                user2.setUsername((String)jsonSessionState.get("username"));
                user2.setSource((String)jsonSessionState.get("source"));
                token.setDetails((Object)user2);
            } else if (jsonSessionState.get("username") == null) {
                SecurityContextHolder.getContext().setAuthentication(null);
            }
            if (token != null) {
                authentication = this.authManager.authenticate((Authentication)token);
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
        }
        if (authentication != null && !(authentication instanceof AnonymousAuthenticationToken) && !(user = (SpringUser)authentication.getCredentials()).isSsoRolesSet()) {
            List<GrantedAuthority> userRoles = this.buildRoleList((GenericUser)user, jsonSessionState);
            user.setSsoRolesSet(true);
            authentication = new PreAuthenticatedAuthenticationToken((Object)user.getUsername(), (Object)user, userRoles);
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private List<GrantedAuthority> buildRoleList(GenericUser user, JsonSessionState jsonSessionState) {
        String[] roles;
        ArrayList<GrantedAuthority> userRoles = new ArrayList<GrantedAuthority>();
        for (String role : roles = this.portalSecurityManager.getRolesList(jsonSessionState, (User)user)) {
            GrantedAuthorityImpl authority = new GrantedAuthorityImpl(role);
            userRoles.add((GrantedAuthority)authority);
        }
        return userRoles;
    }
}

