/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.portal.services.DynamicPageCache;
import com.googlecode.fascinator.portal.services.PortalManager;
import com.googlecode.fascinator.portal.services.VelocityService;
import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.velocity.Template;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VelocityServiceImpl
implements VelocityService {
    private Logger log = LoggerFactory.getLogger(VelocityServiceImpl.class);
    private String portalPath;
    private String defaultPortal;
    private String defaultDisplay;
    private List<String> skinPriority;
    private DynamicPageCache pageCache;

    public VelocityServiceImpl(PortalManager portalManager, DynamicPageCache pageCache) {
        try {
            this.pageCache = pageCache;
            this.defaultPortal = portalManager.getDefaultPortal();
            this.defaultDisplay = portalManager.getDefaultDisplay();
            this.skinPriority = portalManager.getSkinPriority();
            File homePath = portalManager.getHomeDir();
            this.portalPath = homePath.getAbsolutePath();
            Properties props = new Properties();
            props.load(this.getClass().getResourceAsStream("/velocity.properties"));
            props.setProperty("file.resource.loader.path", this.portalPath);
            Velocity.init((Properties)props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public InputStream getResource(String resourcePath) {
        try {
            return RuntimeSingleton.getContent((String)resourcePath).getResourceLoader().getResourceStream(resourcePath);
        }
        catch (Exception e) {
            this.log.error("Failed to get resource: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public InputStream getResource(String portalId, String resourceName) {
        return this.getResource(this.resourceExists(portalId, resourceName));
    }

    @Override
    public String resourceExists(String portalId, String resourceName) {
        String displayType;
        String index = portalId + "/" + resourceName;
        String path = this.pageCache.getPath(index);
        if (path != null) {
            return path;
        }
        path = this.getSkinPath(portalId, resourceName);
        if (path != null) {
            this.pageCache.putPath(index, path);
            return path;
        }
        Pattern p = Pattern.compile("^(?:(.*)/)?display/(?:([a-zA-Z][^/]*))?/(.*)$");
        Matcher m = p.matcher(resourceName);
        if (m.matches() && !this.defaultDisplay.equals(displayType = m.group(2))) {
            String relPath = m.group(3);
            String fallbackResourceName = "display/" + this.defaultDisplay + "/" + relPath;
            if (m.group(1) != null) {
                fallbackResourceName = "scripts/" + fallbackResourceName;
            }
            if ((path = this.getSkinPath(portalId, fallbackResourceName)) != null) {
                this.pageCache.putPath(index, path);
                return path;
            }
        }
        if (!this.defaultPortal.equals(portalId)) {
            return this.resourceExists(this.defaultPortal, resourceName);
        }
        return null;
    }

    @Override
    public void renderTemplate(String portalId, String templateName, Context context, Writer writer) throws Exception {
        String path = this.resourceExists(portalId, templateName + ".vm");
        Template template = Velocity.getTemplate((String)path);
        template.merge(context, writer);
    }

    private String getSkinPath(String portalId, String resourceName) {
        String path = null;
        for (String skin : this.skinPriority) {
            File file;
            path = portalId + "/" + skin + "/" + resourceName;
            if (Velocity.resourceExists((String)path) && !(file = new File(this.portalPath, path)).isDirectory()) {
                return path;
            }
            if (!"".equals(FilenameUtils.getExtension((String)resourceName))) continue;
            if (Velocity.resourceExists((String)(path = path + ".vm"))) {
                return path;
            }
            path = portalId + "/" + skin + "/scripts/" + resourceName + ".py";
            if (!Velocity.resourceExists((String)path)) continue;
            return path;
        }
        return null;
    }
}

