/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.report;

import com.googlecode.fascinator.portal.report.ChartData;
import java.awt.Color;
import java.util.ArrayList;

public class BarChartData
implements ChartData {
    public String rowLabel;
    protected String colLabel;
    protected String title;
    protected ArrayList<DataEntry> entries;
    protected LabelPos colLabelPos;
    protected LabelPos colLegendPos;
    protected boolean useSeriesColor;
    protected Color baseSeriesColor;
    protected int imgW;
    protected int imgH;
    protected boolean stacked;

    public BarChartData(String title, String rowLabel, String colLabel, LabelPos colLabelPos, LabelPos colLegendPos, int imgW, int imgH, boolean stacked) {
        this.rowLabel = rowLabel;
        this.colLabel = colLabel;
        this.title = title;
        this.colLabelPos = colLabelPos;
        this.colLegendPos = colLegendPos;
        this.imgW = imgW;
        this.imgH = imgH;
        this.stacked = stacked;
        this.useSeriesColor = false;
        this.entries = new ArrayList();
    }

    @Override
    public void addEntry(Number value, String rowKey, String colKey) {
        this.entries.add(new DataEntry(value, rowKey, colKey));
    }

    @Override
    public void addEntry(Number value, String rowKey, String colKey, Color seriesColor) {
        this.entries.add(new DataEntry(value, rowKey, colKey, seriesColor));
    }

    public ArrayList<DataEntry> getEntries() {
        return this.entries;
    }

    public int getImgW() {
        return this.imgW;
    }

    public void setImgW(int imgW) {
        this.imgW = imgW;
    }

    public int getImgH() {
        return this.imgH;
    }

    public void setImgH(int imgH) {
        this.imgH = imgH;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getColLabel() {
        return this.colLabel;
    }

    public void setColLabel(String colLabel) {
        this.colLabel = colLabel;
    }

    public String getRowLabel() {
        return this.rowLabel;
    }

    public void setRowLabel(String rowLabel) {
        this.rowLabel = rowLabel;
    }

    public LabelPos getColLabelPos() {
        return this.colLabelPos;
    }

    public void setColLabelPos(LabelPos colLabelPos) {
        this.colLabelPos = colLabelPos;
    }

    public LabelPos getColLegendPos() {
        return this.colLegendPos;
    }

    public void setColLegendPos(LabelPos colLegendPos) {
        this.colLegendPos = colLegendPos;
    }

    public boolean isUseSeriesColor() {
        return this.useSeriesColor;
    }

    public void setUseSeriesColor(boolean useSeriesColor) {
        this.useSeriesColor = useSeriesColor;
    }

    public Color getBaseSeriesColor() {
        return this.baseSeriesColor;
    }

    public void setBaseSeriesColor(Color baseSeriesColor) {
        this.baseSeriesColor = baseSeriesColor;
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public static enum LabelPos {
        HIDDEN,
        HORIZONTAL,
        VERTICAL,
        SLANTED,
        LEFT,
        RIGHT;

    }

    public class DataEntry {
        protected Number value;
        protected String rowKey;
        protected String colKey;
        protected Color seriesColor;

        DataEntry(Number value, String rowKey, String colKey) {
            this.value = value;
            this.rowKey = rowKey;
            this.colKey = colKey;
        }

        DataEntry(Number value, String rowKey, String colKey, Color seriesColor) {
            this.value = value;
            this.rowKey = rowKey;
            this.colKey = colKey;
            this.seriesColor = seriesColor;
        }

        public Number getValue() {
            return this.value;
        }

        public String getRowKey() {
            return this.rowKey;
        }

        public String getColKey() {
            return this.colKey;
        }

        public Color getSeriesColor() {
            return this.seriesColor;
        }
    }
}

