/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.report.service;

import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.portal.report.Report;
import com.googlecode.fascinator.portal.services.FascinatorService;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Random;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportManager
implements FascinatorService {
    private Logger log = LoggerFactory.getLogger(ReportManager.class);
    private JsonSimple config;
    private File reportDir;
    private TreeMap<String, Report> reports;
    private HashMap<String, Report> reportsByLabel;
    private Random random;
    private SimpleDateFormat dtFormatter;

    @Override
    public JsonSimple getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(JsonSimple config) {
        this.config = config;
    }

    @Override
    public void init() {
        this.log.debug("Initializing ReportManager...");
        this.random = new Random(System.currentTimeMillis());
        this.dtFormatter = new SimpleDateFormat("dd/mm/yyyy HH:mm:ss:SSSS");
        this.reportDir = new File(this.config.getString(null, new Object[]{"config", "home"}));
        if (!this.reportDir.exists()) {
            this.log.debug("Creating report directory structure...");
            if (!this.reportDir.mkdirs()) {
                this.log.error("Error creating report directory structure");
                return;
            }
        }
        this.reports = new TreeMap();
        this.reportsByLabel = new HashMap();
        try {
            this.loadReports();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadReports() throws Exception {
        this.log.debug("Loading reports...");
        for (File reportConfigFile : this.reportDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return !file.isDirectory() && !name.equals(".svn");
            }
        })) {
            this.loadAndAddReport(reportConfigFile);
        }
    }

    private void loadAndAddReport(File reportConfigFile) throws Exception {
        JsonSimple reportConfig = new JsonSimple(reportConfigFile);
        String reportName = reportConfig.getString(null, new Object[]{"report", "name"});
        String reportLabel = reportConfig.getString(null, new Object[]{"report", "label"});
        String reportClass = reportConfig.getString(null, new Object[]{"report", "className"});
        this.log.debug("Loading report: " + reportName + ", using class:" + reportClass);
        Report report = (Report)Class.forName(reportClass).newInstance();
        report.setConfig(reportConfig);
        report.setConfigPath(reportConfigFile.getAbsolutePath());
        this.reports.put(reportName, report);
        this.reportsByLabel.put(reportLabel, report);
        this.log.debug("Successfully loaded and added report:" + reportName);
    }

    private Report loadReport(String configPath) throws Exception {
        JsonSimple reportConfig = new JsonSimple(new File(configPath));
        String reportName = reportConfig.getString(null, new Object[]{"report", "name"});
        String reportClass = reportConfig.getString(null, new Object[]{"report", "className"});
        this.log.debug("Loading report: " + reportName + ", using class:" + reportClass);
        Report report = (Report)Class.forName(reportClass).newInstance();
        report.setConfig(reportConfig);
        report.setConfigPath(configPath);
        this.log.debug("Successfully loaded report:" + reportName);
        return report;
    }

    public synchronized void addReport(Report report) throws Exception {
        report.setReportName(this.getUniqueReportName(report.getReportName()));
        this.reports.put(report.getReportName(), report);
        this.reportsByLabel.put(report.getLabel(), report);
    }

    public synchronized void saveReport(Report report) {
        String name = report.getReportName() + ".json";
        File reportConfigFile = new File(this.reportDir, name);
        try {
            FileWriter writer = new FileWriter(reportConfigFile);
            writer.write(report.toJsonString());
            writer.close();
            if (report.getConfigPath() == null) {
                report.setConfigPath(reportConfigFile.getAbsolutePath());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public synchronized void duplicateReport(String reportName) throws Exception {
        Report rptSource = this.getReport(reportName);
        Report rptCopy = this.loadReport(rptSource.getConfigPath());
        String copyLabel = this.getNextCopyLabel(rptCopy.getLabel());
        rptCopy.setReportName(copyLabel.replaceAll(" ", ""));
        rptCopy.setLabel(copyLabel);
        rptCopy.setConfigPath(null);
        this.saveReport(rptCopy);
        this.addReport(rptCopy);
    }

    public synchronized void deleteReport(String reportName) {
        Report report = this.getReport(reportName);
        File reportConfigFile = new File(report.getConfigPath());
        if (!reportConfigFile.delete()) {
            this.log.error("Failed to delete report:" + reportName);
            return;
        }
        this.log.debug("Successfully deleted report:" + reportName);
        this.reports.remove(reportName);
    }

    public synchronized TreeMap<String, Report> getReports() {
        return this.reports;
    }

    public synchronized Report getReport(String reportName) {
        return this.reports.get(reportName);
    }

    public synchronized Report getReportByLabel(String label) {
        return this.reportsByLabel.get(label);
    }

    private String getNextCopyLabel(String label) {
        int copynum = 0;
        Report curCopy = null;
        String nextLabel = null;
        while ((curCopy = this.getReportByLabel(nextLabel = (++copynum == 1 ? "Copy" : "Copy-" + copynum) + " Of " + label)) != null) {
        }
        return nextLabel;
    }

    public String getUniqueReportName(String reportName) throws Exception {
        Calendar curCal = Calendar.getInstance();
        String name = URLEncoder.encode(DigestUtils.md5Hex((String)(reportName + this.dtFormatter.format(curCal.getTime()) + this.random.nextFloat())), "utf-8");
        return name;
    }
}

