/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services;

import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.StorageDataUtil;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwaspSanitizer {
    private static final StorageDataUtil storageDataUtil = new StorageDataUtil();
    private static final Logger LOG = LoggerFactory.getLogger(OwaspSanitizer.class);

    public static void sanitizeTfPackage(JsonSimple tfpackage) {
        OwaspSanitizer.sanitizeTfPackageNumberedFieldAndShadow(tfpackage, "dc:description", "text", "shadow");
        LOG.debug("tfpackage after sanitized is: {}", (Object)tfpackage);
    }

    public static void sanitizeTfPackageField(JsonSimple tfpackage, String baseKey) {
        LOG.debug("field to sanitize: {}", (Object)baseKey);
        String text = tfpackage.getString("", new Object[]{baseKey});
        String sanitized = OwaspSanitizer.sanitizeHtml(text);
        OwaspSanitizer.updateTfPackageSanitizedKeyValue(tfpackage, sanitized, baseKey, text);
    }

    public static void sanitizeTfPackageNumberedFieldAndShadow(JsonSimple tfpackage, String baseKey, String suffixKey, String suffixShadowKey) {
        Map map = storageDataUtil.getList(tfpackage, baseKey);
        LOG.debug("numbered fields to sanitize: {}", (Object)map);
        for (Map.Entry entrySet : map.entrySet()) {
            String number = (String)entrySet.getKey();
            Map field = (Map)entrySet.getValue();
            LOG.debug("processing: {}", (Object)number);
            String text = (String)field.get(suffixKey);
            String sanitized = OwaspSanitizer.sanitizeHtml(text);
            String sanitizedShadow = OwaspSanitizer.escapeHtml(sanitized);
            String keyToUpdate = baseKey + "." + number + "." + suffixKey;
            String shadowKeyToUpdate = baseKey + "." + number + "." + suffixShadowKey;
            OwaspSanitizer.updateTfPackageSanitizedKeyValue(tfpackage, sanitized, keyToUpdate, text);
            OwaspSanitizer.updateTfPackageSanitizedKeyValue(tfpackage, sanitizedShadow, shadowKeyToUpdate, text);
        }
    }

    public static void sanitizeTfPackageNumberedField(JsonSimple tfpackage, String baseKey, String suffixKey) {
        Map map = storageDataUtil.getList(tfpackage, baseKey);
        LOG.debug("numbered fields to sanitize: {}", (Object)map);
        for (Map.Entry entrySet : map.entrySet()) {
            String number = (String)entrySet.getKey();
            Map field = (Map)entrySet.getValue();
            LOG.debug("processing: {}", (Object)number);
            String text = (String)field.get(suffixKey);
            String sanitized = OwaspSanitizer.sanitizeHtml(text);
            String keyToUpdate = baseKey + "." + number + "." + suffixKey;
            OwaspSanitizer.updateTfPackageSanitizedKeyValue(tfpackage, sanitized, keyToUpdate, text);
        }
    }

    public static void sanitizeMapNumberedField(Map<String, Object> map, String subKey) {
        LOG.debug("pre-sanitised map is: {}", map);
        for (Map.Entry<String, Object> entrySet : map.entrySet()) {
            String number = entrySet.getKey();
            Map field = (Map)entrySet.getValue();
            LOG.debug("processing outer map key: {}", (Object)number);
            String text = (String)field.get(subKey);
            String sanitized = OwaspSanitizer.sanitizeHtml(text);
            field.put(subKey, sanitized);
        }
        LOG.debug("post-sanitized map is: {}", map);
    }

    public static String escapeHtml(String value) {
        LOG.debug("incoming value before escaped: {}", (Object)value);
        String escaped = ESAPI.encoder().encodeForHTML(StringUtils.defaultIfEmpty((String)value, (String)""));
        LOG.debug("outgoing value after escaped: {}", (Object)escaped);
        return escaped;
    }

    private static void updateTfPackageSanitizedKeyValue(JsonSimple tfpackage, String sanitized, String keyToUpdate, String text) {
        if (!text.equals(sanitized)) {
            LOG.debug("updating key: {} to post-sanitized value: {}", (Object)keyToUpdate, (Object)sanitized);
            tfpackage.getJsonObject().put((Object)keyToUpdate, (Object)sanitized);
        }
    }

    public static String sanitizeHtml(String value) {
        return OwaspSanitizer.sanitizeCustomHtml(StringUtils.defaultIfEmpty((String)value, (String)""), OwaspSanitizer.getDefaultPolicy());
    }

    public static String sanitizeCustomHtml(String value, PolicyFactory sanitizer) {
        LOG.debug("pre-sanitized: {}", (Object)value);
        String sanititized = sanitizer.sanitize(StringUtils.defaultIfEmpty((String)value, (String)""));
        if (!value.equals(sanititized)) {
            LOG.info("post-sanitized: {}", (Object)sanititized);
        }
        return sanititized;
    }

    public static PolicyFactory getDefaultPolicy() {
        return Sanitizers.FORMATTING.and(Sanitizers.BLOCKS).and(Sanitizers.IMAGES).and(Sanitizers.LINKS).and(Sanitizers.STYLES).and(Sanitizers.TABLES);
    }
}

