/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal;

import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.PluginManager;
import com.googlecode.fascinator.api.harvester.Harvester;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class HarvestContent
extends JsonSimpleConfig {
    private File jsonFile;

    public HarvestContent(File jsonFile) throws IOException {
        super(jsonFile);
        this.jsonFile = jsonFile;
    }

    public String getId() {
        return FilenameUtils.getBaseName((String)this.jsonFile.getName());
    }

    public String getDescription() {
        return this.getString(null, new Object[]{"content", "description"});
    }

    public Map<String, Object> getIndexerParams() {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        JsonObject object = this.getObject(new Object[]{"indexer", "params"});
        for (Object key : object.keySet()) {
            response.put(key.toString(), object.get(key));
        }
        return response;
    }

    public String getIndexerParam(String name) {
        return this.getIndexerParams().get(name).toString();
    }

    public void setIndexerParam(String name, String value) {
        JsonObject object = this.getObject(new Object[]{"indexer", "params"});
        if (object != null) {
            object.put((Object)name, (Object)value);
        }
    }

    public File getRulesFile() {
        return new File(this.getString(null, new Object[]{"indexer", "script", "rules"}));
    }

    public Harvester getHarvester() {
        Storage storage = PluginManager.getStorage((String)this.getString(null, new Object[]{"storage", "type"}));
        Harvester harvester = PluginManager.getHarvester((String)this.getString(null, new Object[]{"harvester", "type"}), (Storage)storage);
        if (harvester != null) {
            try {
                harvester.init(this.jsonFile);
            }
            catch (PluginException e) {
                e.printStackTrace();
            }
        }
        return harvester;
    }
}

