/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.cache;

import com.googlecode.fascinator.portal.services.PortalManager;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import com.googlecode.fascinator.portal.services.VelocityService;
import com.googlecode.fascinator.portal.services.cache.JythonCacheEntryFactory;
import com.googlecode.fascinator.portal.velocity.JythonLogger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonCacheEntryFactory
implements CacheEntryFactory {
    private Logger log = LoggerFactory.getLogger(JythonCacheEntryFactory.class);
    private VelocityService velocityService;
    private ScriptingServices scriptingServices;
    private String portalPath;
    private String defaultPortal;
    private List<String> skinPriority;

    public JythonCacheEntryFactory(PortalManager portalManager, VelocityService velocityService, ScriptingServices scriptingServices) {
        this.velocityService = velocityService;
        this.scriptingServices = new DeprecatedServicesWrapper(this, scriptingServices);
        this.defaultPortal = portalManager.getDefaultPortal();
        this.portalPath = portalManager.getHomeDir().toString();
        this.skinPriority = portalManager.getSkinPriority();
    }

    public Object createEntry(Object key) throws Exception {
        String path = key.toString();
        int qmarkPos = path.lastIndexOf("?");
        if (qmarkPos != -1) {
            path = path.substring(0, qmarkPos);
        }
        int slashPos = path.indexOf("/");
        String portalId = path.substring(0, slashPos);
        PyObject scriptObject = null;
        InputStream in = this.velocityService.getResource(path);
        if (in == null) {
            this.log.debug("Failed to load script: '{}'", (Object)path);
        } else {
            this.addSysPaths(portalId, Py.getSystemState());
            PythonInterpreter python = PythonInterpreter.threadLocalStateInterpreter(null);
            python.set("Services", (Object)this.scriptingServices);
            JythonLogger jythonLogger = new JythonLogger(path);
            python.setOut((OutputStream)jythonLogger);
            python.setErr((OutputStream)jythonLogger);
            python.execfile(in, path);
            String scriptClassName = StringUtils.capitalize((String)FilenameUtils.getBaseName((String)path)) + "Data";
            PyObject scriptClass = python.get(scriptClassName);
            if (scriptClass != null) {
                scriptObject = scriptClass.__call__();
            } else {
                this.log.debug("Failed to find class '{}'", (Object)scriptClassName);
            }
            python.cleanup();
        }
        return scriptObject;
    }

    private void addSysPaths(String portalId, PySystemState sys) {
        for (String skin : this.skinPriority) {
            String sysPath = this.portalPath + "/" + portalId + "/" + skin + "/scripts";
            sys.path.append((PyObject)Py.newString((String)sysPath));
        }
        if (!this.defaultPortal.equals(portalId)) {
            this.addSysPaths(this.defaultPortal, sys);
        }
    }

    static /* synthetic */ Logger access$000(JythonCacheEntryFactory x0) {
        return x0.log;
    }
}

