/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.lookup;

import com.googlecode.fascinator.common.BasicHttpClient;
import com.googlecode.fascinator.common.JsonSimple;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MintLookupHelper {
    private static Logger log = LoggerFactory.getLogger(MintLookupHelper.class);

    public static JsonSimple get(JsonSimple systemConfig, String urlName, Map<String, String> reqData) throws Exception {
        String url = systemConfig.getString("http://localhost:9001/mint", new Object[]{"proxy-urls", urlName});
        StringBuilder reqStr = new StringBuilder();
        reqStr.append(url);
        if (urlName.endsWith("Detail") && !reqData.containsKey("id")) {
            throw new Exception("Invalid request - please provide ID(s) to lookup.");
        }
        for (String key : reqData.keySet()) {
            String data = reqData.get(key);
            if (reqStr.indexOf("?") == -1) {
                reqStr.append("?");
            } else {
                reqStr.append("&");
            }
            reqStr.append(key);
            reqStr.append("=");
            reqStr.append(URLEncoder.encode(data, "utf-8"));
        }
        url = reqStr.toString();
        log.debug("Hitting URL: " + url);
        BasicHttpClient client = new BasicHttpClient(url);
        GetMethod get = new GetMethod(url);
        client.executeMethod((HttpMethodBase)get);
        JsonSimple mintResult = new JsonSimple(get.getResponseBodyAsString());
        return mintResult;
    }
}

