/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.sso;

import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.sso.OpenIDUser;
import com.googlecode.fascinator.portal.sso.SSOInterface;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.expressme.openid.Association;
import org.expressme.openid.Authentication;
import org.expressme.openid.Endpoint;
import org.expressme.openid.OpenIdException;
import org.expressme.openid.OpenIdManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenID
implements SSOInterface {
    private Logger log = LoggerFactory.getLogger(OpenID.class);
    private HttpServletRequest request;
    private OpenIdManager manager;
    private byte[] oidAssocicationMac;
    private String oidEndpointAlias;
    private String oidRemoteLogonUrl;
    private String oidReturnAddress;
    private String portalUrl;
    private String oidProvider;

    public String getId() {
        return "OpenID";
    }

    public String getLabel() {
        return "Login via OpenID";
    }

    public String getInterface(String ssoUrl) {
        String html = "";
        html = html + "<a href=\"" + ssoUrl + "&provider=Google\">" + "<img title=\"Google\" src=\"" + this.portalUrl + "/images/google.png\"/ alt=\"Google\"></a>";
        html = html + "&nbsp;&nbsp;&nbsp; OR &nbsp;&nbsp;&nbsp;";
        html = html + "<a href=\"" + ssoUrl + "&provider=Yahoo\">" + "<img title=\"Yahoo\" src=\"" + this.portalUrl + "/images/yahoo.png\" alt=\"Yahoo\"/></a>";
        html = html + "<hr/>OR<br/>";
        String txt = " My own OpenID provider ";
        html = html + "<img title=\"OpenID\" src=\"" + this.portalUrl + "/images/openid.png\" alt=\"OpenID\"/> " + "<input class=\"custom\" type=\"text\" id=\"ssoProvider\"" + " onblur=\"blurOpenId(this);\" onfocus=\"focusOpenId(this);\"" + " value=\"" + txt + "\"/> " + "<input type=\"hidden\" id=\"ssoUrl\" value=\"" + ssoUrl + "&provider=\"/>" + "<input type=\"button\" name=\"openIdGo\"" + " onclick=\"doSso();\" value=\"GO\"/>" + "<br/>eg. 'http://yourname.myopenid.com'";
        html = html + "<script type=\"text/javascript\">function focusOpenId(obj) {if (obj.value == \"" + txt + "\") {obj.value = \"\";}}" + "function blurOpenId(obj) {" + "if (obj.value == \"\") {obj.value = \"" + txt + "\";}}" + "function doSso() {" + "var ssoUrl = document.getElementById('ssoUrl').value;" + "var provider = document.getElementById('ssoProvider').value;" + "location.href=ssoUrl + provider;}" + "</script>";
        return html;
    }

    public User getUserObject(JsonSessionState session) {
        String username = (String)session.get("oidSsoIdentity");
        String fullname = (String)session.get("oidSsoDisplayName");
        String email = (String)session.get("oidSsoEmail");
        if (username == null) {
            return null;
        }
        OpenIDUser user = new OpenIDUser();
        user.setUsername(username);
        user.setSource("OpenID");
        user.set("name", fullname);
        user.set("email", email);
        return user;
    }

    public void logout(JsonSessionState session) {
        session.remove((Object)"oidAssocicationMac");
        session.remove((Object)"oidEndpointAlias");
        session.remove((Object)"oidRemoteLogonUrl");
        session.remove((Object)"oidReturnAddress");
        session.remove((Object)"oidSsoIdentity");
        session.remove((Object)"oidSsoEmail");
        session.remove((Object)"oidSsoName");
        session.remove((Object)"oidProvider");
    }

    public void ssoInit(JsonSessionState session, HttpServletRequest request) throws Exception {
        this.request = request;
        this.manager = new OpenIdManager();
        String provider = request.getParameter("provider");
        if (provider != null) {
            this.oidProvider = provider;
            session.set("oidProvider", (Object)this.oidProvider);
        }
        this.oidProvider = (String)session.get("oidProvider");
        this.portalUrl = (String)session.get("ssoPortalUrl");
    }

    public void ssoPrepareLogin(JsonSessionState session, String returnAddress, String server) throws Exception {
        this.manager.setReturnTo(returnAddress);
        this.manager.setRealm(server);
        session.set("oidReturnAddress", (Object)returnAddress);
    }

    public String ssoGetRemoteLogonURL(JsonSessionState session) {
        if (this.oidProvider == null) {
            return null;
        }
        try {
            Endpoint endpoint = this.manager.lookupEndpoint(this.oidProvider);
            Association association = this.manager.lookupAssociation(endpoint);
            this.oidAssocicationMac = association.getRawMacKey();
            this.oidEndpointAlias = endpoint.getAlias();
            this.oidRemoteLogonUrl = this.manager.getAuthenticationUrl(endpoint, association);
            this.log.info("OpenID Logon URL: '{}'", (Object)this.oidRemoteLogonUrl);
            session.set("oidAssocicationMac", (Object)this.oidAssocicationMac);
            session.set("oidEndpointAlias", (Object)this.oidEndpointAlias);
            session.set("oidRemoteLogonUrl", (Object)this.oidRemoteLogonUrl);
        }
        catch (OpenIdException ex) {
            this.log.error("OpenID Error: ", (Object)ex.getMessage());
            return null;
        }
        return this.oidRemoteLogonUrl;
    }

    public void ssoCheckUserDetails(JsonSessionState session) {
        String username = (String)session.get("oidSsoIdentity");
        if (username != null) {
            return;
        }
        this.oidReturnAddress = (String)session.get("oidReturnAddress");
        this.oidAssocicationMac = (byte[])session.get("oidAssocicationMac");
        this.oidEndpointAlias = (String)session.get("oidEndpointAlias");
        if (this.oidAssocicationMac == null || this.oidEndpointAlias == null) {
            return;
        }
        try {
            this.manager.setReturnTo(this.oidReturnAddress);
            Authentication authentication = this.manager.getAuthentication(this.request, this.oidAssocicationMac, this.oidEndpointAlias);
            String identity = authentication.getIdentity();
            String name = authentication.getFullname();
            String email = authentication.getEmail();
            this.log.debug("=== SSO: Provider: '{}', Data: '{}'", (Object)this.oidProvider, (Object)authentication.toString());
            if (identity != null) {
                session.set("oidSsoIdentity", (Object)identity);
            }
            if (email != null && !email.equals("null")) {
                session.set("oidSsoEmail", (Object)email);
            }
            if (name != null && !name.equals("nullnull")) {
                session.set("oidSsoName", (Object)name);
                session.set("oidSsoDisplayName", (Object)name);
            } else if (email != null && !email.equals("null")) {
                session.set("oidSsoDisplayName", (Object)email);
            } else {
                session.set("oidSsoDisplayName", (Object)identity);
            }
        }
        catch (OpenIdException ex) {
            this.log.error("Login event expected, but not found: '{}'", (Object)ex.getMessage());
        }
    }

    public List<String> getRolesList(JsonSessionState session) {
        return new ArrayList<String>();
    }
}

