/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.tapestry5.services.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormData {
    private Logger log = LoggerFactory.getLogger(FormData.class);
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private Map<String, String> headers;
    private HttpServletRequest hsr;

    public FormData() {
    }

    public FormData(Request request) {
        this(request, null);
    }

    public FormData(Request request, HttpServletRequest hsr) {
        for (String name : request.getParameterNames()) {
            List<String> values = Arrays.asList(request.getParameters(name));
            this.parameters.put(name, values);
        }
        this.hsr = hsr;
    }

    public void set(String name, String value) {
        String[] values = new String[]{value};
        this.setValues(name, Arrays.asList(values));
    }

    public void setValues(String name, List<String> values) {
        this.parameters.put(name, values);
    }

    public String get(String name) {
        List<String> values = this.getValues(name);
        return values == null ? null : values.get(0);
    }

    public String get(String name, String defaultValue) {
        String val = this.get(name);
        return val == null ? defaultValue : val;
    }

    public Set<String> getFormFields() {
        return this.parameters.keySet();
    }

    public List<String> getValues(String name) {
        return this.parameters.get(name);
    }

    public InputStream getInputStream() {
        ServletInputStream iStream = null;
        try {
            iStream = this.hsr.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return iStream;
    }

    public void clear() {
        this.parameters.clear();
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            Enumeration e = this.hsr.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement().toString();
                String value = this.hsr.getHeader(name);
                this.headers.put(name, value);
            }
        }
        return this.headers;
    }

    public String toString() {
        return this.parameters.toString();
    }
}

