/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.report;

import com.googlecode.fascinator.portal.report.BarChartData;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class ChartGenerator {
    public static JFreeChart getBarChart(OutputStream out, BarChartData data) throws IOException {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (BarChartData.DataEntry entry : data.getEntries()) {
            dataset.addValue(entry.getValue(), (Comparable)((Object)entry.getRowKey()), (Comparable)((Object)entry.getColKey()));
        }
        JFreeChart chart = null;
        chart = data.isStacked() ? ChartFactory.createStackedBarChart((String)data.getTitle(), (String)data.getColLabel(), (String)data.getRowLabel(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (!data.getColLegendPos().equals((Object)BarChartData.LabelPos.HIDDEN) ? 1 : 0) != 0, (boolean)false, (boolean)false) : ChartFactory.createBarChart((String)data.getTitle(), (String)data.getColLabel(), (String)data.getRowLabel(), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (!data.getColLegendPos().equals((Object)BarChartData.LabelPos.HIDDEN) ? 1 : 0) != 0, (boolean)false, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint((Paint)new Color(55, 52, 80));
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        renderer.setItemMargin(0.1);
        if (!data.getColLegendPos().equals((Object)BarChartData.LabelPos.HIDDEN)) {
            chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
        }
        if (!data.isUseSeriesColor()) {
            renderer.setBasePaint((Paint)data.getBaseSeriesColor());
            renderer.setAutoPopulateSeriesPaint(false);
        } else {
            int curSeries = 0;
            for (BarChartData.DataEntry entry : data.getEntries()) {
                renderer.setSeriesPaint(curSeries++, (Paint)entry.getSeriesColor());
            }
        }
        if (data.getColLegendPos() == BarChartData.LabelPos.LEFT) {
            chart.getLegend().setPosition(RectangleEdge.LEFT);
        }
        if (data.getColLegendPos() == BarChartData.LabelPos.RIGHT) {
            chart.getLegend().setPosition(RectangleEdge.RIGHT);
        }
        renderer.setItemLabelsVisible(true);
        if (data.getColLabelPos().equals((Object)BarChartData.LabelPos.SLANTED)) {
            ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.CENTER_RIGHT, TextAnchor.CENTER_RIGHT, -1.5707963267948966);
            renderer.setPositiveItemLabelPosition(p);
            ItemLabelPosition p2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.CENTER_LEFT, TextAnchor.CENTER_LEFT, -1.5707963267948966);
            renderer.setPositiveItemLabelPositionFallback(p2);
            CategoryAxis domainAxis = plot.getDomainAxis();
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        }
        if (data.getColLabelPos().equals((Object)BarChartData.LabelPos.VERTICAL)) {
            CategoryAxis domainAxis = plot.getDomainAxis();
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        }
        return chart;
    }

    public static void renderCSV(OutputStream out, ArrayList<BarChartData> barChartDataList) {
    }

    public static void renderPNGBarChart(OutputStream out, BarChartData data) throws IOException {
        JFreeChart chart = ChartGenerator.getBarChart(out, data);
        ChartUtilities.writeBufferedImageAsPNG((OutputStream)out, (BufferedImage)chart.createBufferedImage(data.getImgW(), data.getImgH()));
    }
}

