/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.api.storage.DigitalObject;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.common.IndexAndPayloadComposite;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.StorageDataUtil;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.portal.FormData;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.guitoolkit.GUIToolkit;
import com.googlecode.fascinator.portal.services.DynamicPageCache;
import com.googlecode.fascinator.portal.services.DynamicPageService;
import com.googlecode.fascinator.portal.services.HouseKeepingManager;
import com.googlecode.fascinator.portal.services.PortalManager;
import com.googlecode.fascinator.portal.services.PortalSecurityManager;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import com.googlecode.fascinator.portal.services.VelocityService;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Response;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.python.core.Py;
import org.python.core.PyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingDynamicPageServiceImpl
implements DynamicPageService {
    private static final String DEFAULT_LAYOUT = "layout";
    private static final String AJAX_EXT = ".ajax";
    private static final String SCRIPT_EXT = ".script";
    private static final String SCRIPT_ACTIVATE_METHOD = "__activate__";
    private Logger log = LoggerFactory.getLogger(CachingDynamicPageServiceImpl.class);
    @Inject
    private RequestGlobals requestGlobals;
    @Inject
    private Request request;
    @Inject
    private Response response;
    @Inject
    private ScriptingServices scriptingServices;
    @Inject
    private HouseKeepingManager houseKeeping;
    @Inject
    private PortalSecurityManager security;
    @Inject
    private DynamicPageCache pageCache;
    private VelocityService velocityService;
    private JsonSimpleConfig config;
    private String layoutName;
    private String urlBase;
    private String portalPath;
    private GUIToolkit toolkit;
    private String defaultPortal;
    private String defaultDisplay;
    private String versionString;

    public CachingDynamicPageServiceImpl(PortalManager portalManager, VelocityService velocityService) {
        this.velocityService = velocityService;
        try {
            this.config = new JsonSimpleConfig();
            this.layoutName = this.config.getString(DEFAULT_LAYOUT, new Object[]{"portal", DEFAULT_LAYOUT});
            this.urlBase = this.config.getString(null, new Object[]{"urlBase"});
            this.versionString = this.config.getString(null, new Object[]{"version.string"});
            this.toolkit = new GUIToolkit();
            this.portalPath = portalManager.getHomeDir().getAbsolutePath();
            this.defaultPortal = portalManager.getDefaultPortal();
            this.defaultDisplay = portalManager.getDefaultDisplay();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Deprecated
    public InputStream getResource(String resourcePath) {
        this.log.warn("getResource() is deprecated, use VelocityService.getResource()  ({})", (Object)resourcePath);
        return this.velocityService.getResource(resourcePath);
    }

    @Override
    @Deprecated
    public InputStream getResource(String portalId, String resourceName) {
        this.log.warn("getResource() is deprecated, use VelocityService.getResource()  ({}/{})", (Object)portalId, (Object)resourceName);
        return this.velocityService.getResource(portalId, resourceName);
    }

    @Override
    @Deprecated
    public String resourceExists(String portalId, String resourceName) {
        String resourcePath = this.velocityService.resourceExists(portalId, resourceName);
        this.log.warn("resourceExists() is deprecated, use VelocityService.resourceExists() ({})", (Object)resourcePath);
        return resourcePath;
    }

    @Override
    public String render(String portalId, String pageName, OutputStream out, FormData formData, JsonSessionState sessionState) {
        boolean committed;
        boolean isAjax = pageName.endsWith(AJAX_EXT);
        boolean isScript = pageName.endsWith(SCRIPT_EXT);
        if (isAjax || isScript) {
            pageName = FilenameUtils.removeExtension((String)pageName);
        }
        String contextPath = this.request.getContextPath();
        int serverPort = this.requestGlobals.getHTTPServletRequest().getServerPort();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("systemConfig", this.config);
        bindings.put("Services", this.scriptingServices);
        bindings.put("systemProperties", System.getProperties());
        bindings.put("request", this.request);
        bindings.put("httpServletRequest", this.requestGlobals.getHTTPServletRequest());
        bindings.put("response", this.response);
        bindings.put("formData", formData);
        bindings.put("sessionState", sessionState);
        bindings.put("security", this.security);
        bindings.put("contextPath", contextPath);
        bindings.put("scriptsPath", this.portalPath + "/" + portalId + "/scripts");
        bindings.put("portalDir", this.portalPath + "/" + portalId);
        bindings.put("portalId", portalId);
        String urlBase = this.urlBase;
        if (StringUtils.isEmpty((String)urlBase)) {
            urlBase = CachingDynamicPageServiceImpl.getURL(this.requestGlobals.getHTTPServletRequest(), this.config);
        } else if (this.config.getString(null, new Object[]{"portal", "urlBases", portalId}) != null) {
            urlBase = this.config.getString(null, new Object[]{"portal", "urlBases", portalId});
        }
        bindings.put("urlBase", urlBase);
        if (this.versionString == null) {
            bindings.put("portalPath", urlBase + portalId);
        } else {
            bindings.put("portalPath", urlBase + "verNum" + this.versionString + "/" + portalId);
        }
        bindings.put("defaultPortal", this.defaultPortal);
        bindings.put("pageName", pageName);
        bindings.put("serverPort", serverPort);
        bindings.put("toolkit", this.toolkit);
        bindings.put("log", this.log);
        bindings.put("notifications", this.houseKeeping.getUserMessages());
        bindings.put("bindings", bindings);
        StorageDataUtil dataUtil = new StorageDataUtil();
        bindings.put("jsonUtil", dataUtil);
        HashSet<String> messages = new HashSet<String>();
        bindings.put("page", this.evalScript(portalId, this.layoutName, bindings, messages));
        bindings.put("StringUtils", StringUtils.class);
        bindings.put("StringEscapeUtils", StringEscapeUtils.class);
        bindings.put("self", this.evalScript(portalId, pageName, bindings, messages));
        String mimeType = "text/html";
        Object mimeTypeAttr = this.request.getAttribute("Content-Type");
        if (mimeTypeAttr != null) {
            mimeType = mimeTypeAttr.toString();
        }
        if (committed = this.response.isCommitted()) {
            return mimeType;
        }
        if (this.velocityService.resourceExists(portalId, pageName + ".vm") != null) {
            VelocityContext vc = new VelocityContext();
            for (String key : bindings.keySet()) {
                vc.put(key, bindings.get(key));
            }
            vc.put("velocityContext", (Object)vc);
            if (!messages.isEmpty()) {
                vc.put("renderMessages", messages);
            }
            try {
                this.log.debug("Rendering page {}/{}.vm...", (Object)portalId, (Object)pageName);
                StringWriter pageContentWriter = new StringWriter();
                this.velocityService.renderTemplate(portalId, pageName, (Context)vc, pageContentWriter);
                if (isAjax || isScript) {
                    out.write(pageContentWriter.toString().getBytes("UTF-8"));
                } else {
                    vc.put("pageContent", (Object)pageContentWriter.toString());
                }
            }
            catch (Exception e) {
                ByteArrayOutputStream eOut = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(eOut));
                String eMsg = eOut.toString();
                this.log.error("Failed to render page ({})!\n=====\n{}\n=====", (Object)(isAjax ? "ajax" : (isScript ? "script" : "html")), (Object)eMsg);
                String errorMsg = "<pre>Page content template error: " + pageName + "\n" + eMsg + "</pre>";
                if (isAjax || isScript) {
                    try {
                        out.write(errorMsg.getBytes());
                    }
                    catch (Exception e2) {
                        this.log.error("Failed to output error message!");
                    }
                }
                vc.put("pageContent", (Object)errorMsg);
            }
            if (!isAjax && !isScript) {
                try {
                    this.log.debug("Rendering layout {}/{}.vm for page {}.vm...", new Object[]{portalId, this.layoutName, pageName});
                    OutputStreamWriter pageWriter = new OutputStreamWriter(out, "UTF-8");
                    this.velocityService.renderTemplate(portalId, this.layoutName, (Context)vc, pageWriter);
                    ((Writer)pageWriter).close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return mimeType;
    }

    @Override
    public String renderObject(Context context, String template, IndexAndPayloadComposite metadata) {
        context.put("metadata", (Object)metadata);
        return this.renderObject(context, template, metadata.getIndexedData());
    }

    @Override
    public String renderObject(Context context, String template, SolrDoc metadata) {
        IndexAndPayloadComposite compositeData;
        String previewType;
        String portalId = context.get("portalId").toString();
        String displayType = metadata.getString(this.defaultDisplay, new Object[]{"display_type"});
        if ("".equals(displayType)) {
            displayType = this.defaultDisplay;
        }
        if (template.startsWith("detail") && (previewType = metadata.getString(null, new Object[]{"preview_type"})) != null && !"".equals(previewType)) {
            this.log.debug("Preview template found: '{}'", (Object)previewType);
            displayType = previewType;
        }
        String templateName = "display/" + displayType + "/" + template;
        Object parentPageObject = null;
        VelocityContext objectContext = new VelocityContext(context);
        parentPageObject = objectContext.containsKey((Object)"parent") ? objectContext.get("parent") : objectContext.get("self");
        HashSet<String> messages = null;
        if (objectContext.containsKey((Object)"renderMessages")) {
            messages = (Set)objectContext.get("renderMessages");
        } else {
            messages = new HashSet();
            context.put("renderMessages", messages);
        }
        Storage storage = this.scriptingServices.getStorage();
        JsonSimple tfpackage = null;
        IndexAndPayloadComposite indexAndPayloadComposite = compositeData = objectContext.get("metadata") instanceof IndexAndPayloadComposite ? (IndexAndPayloadComposite)objectContext.get("metadata") : null;
        if (compositeData == null) {
            compositeData = this.loadComposite(storage, compositeData, metadata, templateName, messages);
        } else {
            if (compositeData.getPayloadData() == null) {
                this.loadComposite(storage, compositeData, metadata, templateName, messages);
            }
            tfpackage = compositeData.getPayloadData();
        }
        objectContext.put("pageName", (Object)template);
        objectContext.put("displayType", (Object)displayType);
        objectContext.put("parent", parentPageObject);
        objectContext.put("indexedData", (Object)metadata);
        objectContext.put("metadata", (Object)compositeData);
        objectContext.put("tfpackage", (Object)tfpackage);
        Map bindings = (Map)objectContext.get("bindings");
        bindings.put("metadata", compositeData);
        bindings.put("indexedData", metadata);
        bindings.put("tfpackage", tfpackage);
        objectContext.put("self", (Object)this.evalScript(portalId, templateName, bindings, messages));
        String content = "";
        try {
            this.log.debug("Rendering display page {}/{}.vm...", (Object)portalId, (Object)templateName);
            StringWriter pageContentWriter = new StringWriter();
            this.velocityService.renderTemplate(portalId, templateName, (Context)objectContext, pageContentWriter);
            content = pageContentWriter.toString();
        }
        catch (Exception e) {
            this.log.error("Failed rendering display page: {}", (Object)templateName);
            ByteArrayOutputStream eOut = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(eOut));
            String eMsg = eOut.toString();
            messages.add("Page content template error: " + templateName + "\n" + eMsg);
        }
        return content;
    }

    private IndexAndPayloadComposite loadComposite(Storage storage, IndexAndPayloadComposite compositeData, SolrDoc metadata, String templateName, Set<String> messages) {
        DigitalObject obj = null;
        JsonSimple tfpackage = null;
        try {
            obj = storage.getObject(metadata.get("id"));
            if (obj != null) {
                for (String payloadId : obj.getPayloadIdList()) {
                    if (!payloadId.endsWith("tfpackage")) continue;
                    tfpackage = new JsonSimple(obj.getPayload(payloadId).open());
                    break;
                }
                if (compositeData == null) {
                    compositeData = new IndexAndPayloadComposite(metadata, tfpackage);
                } else {
                    compositeData.setPayloadData(tfpackage);
                }
            } else {
                this.log.error("Failed rendering display page: {}", (Object)templateName);
                messages.add("DigitalObject not found in storage!");
            }
        }
        catch (Exception e) {
            this.log.error("Failed rendering display page: {}", (Object)templateName);
            ByteArrayOutputStream eOut = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(eOut));
            String eMsg = eOut.toString();
            messages.add("Page content template error: " + templateName + "\n" + eMsg);
        }
        return compositeData;
    }

    private PyObject evalScript(String portalId, String pageName, Map<String, Object> context, Set<String> messages) {
        PyObject scriptObject = null;
        String scriptName = "scripts/" + pageName + ".py";
        try {
            String path = this.velocityService.resourceExists(portalId, scriptName);
            if (path == null) {
                this.log.debug("No script for portalId:'{}' scriptName:'{}'", (Object)portalId, (Object)scriptName);
            } else {
                scriptObject = this.pageCache.getScriptObject(path);
                if (scriptObject.__findattr__(SCRIPT_ACTIVATE_METHOD) != null) {
                    scriptObject.invoke(SCRIPT_ACTIVATE_METHOD, Py.java2py(context));
                } else {
                    this.log.warn("{} method not found for scriptPath:'{}'", (Object)SCRIPT_ACTIVATE_METHOD, (Object)path);
                }
            }
        }
        catch (Exception e) {
            ByteArrayOutputStream eOut = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(eOut));
            String eMsg = eOut.toString();
            this.log.warn("Failed to run script!\n=====\n{}\n=====", (Object)eMsg);
            messages.add("Script error: " + scriptName + "\n" + eMsg);
        }
        return scriptObject;
    }

    public static String getURL(HttpServletRequest req, JsonSimpleConfig config) {
        String scheme = config.getString(req.getScheme(), new Object[]{"urlSchemeName"});
        String serverName = req.getServerName();
        int serverPort = req.getServerPort();
        String contextPath = req.getContextPath();
        StringBuilder url = new StringBuilder();
        url.append(scheme).append("://").append(serverName);
        if (serverPort != 80 && serverPort != 443) {
            url.append(":").append(serverPort);
        }
        url.append(contextPath).append("/");
        return url.toString();
    }
}

