/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.storage.Storage;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.portal.services.ByteRangeRequestCache;
import com.googlecode.fascinator.portal.services.DatabaseServices;
import com.googlecode.fascinator.portal.services.DynamicPageService;
import com.googlecode.fascinator.portal.services.FascinatorService;
import com.googlecode.fascinator.portal.services.HarvestManager;
import com.googlecode.fascinator.portal.services.HouseKeepingManager;
import com.googlecode.fascinator.portal.services.LanguageServiceMXBean;
import com.googlecode.fascinator.portal.services.PortalManager;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import com.googlecode.fascinator.portal.services.VelocityService;
import com.googlecode.fascinator.portal.services.impl.LanguageServiceMXBeanImpl;
import com.googlecode.fascinator.spring.ApplicationContextProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="scriptingServices")
public class ScriptingServicesImpl
implements ScriptingServices {
    @Inject
    private DatabaseServices database;
    @Inject
    private DynamicPageService pageService;
    @Inject
    @Autowired
    @Qualifier(value="fascinatorIndexer")
    private Indexer indexerService;
    @Inject
    @Autowired
    @Qualifier(value="fascinatorStorage")
    private Storage storageService;
    @Inject
    private HarvestManager harvestManager;
    @Inject
    private HouseKeepingManager houseKeeping;
    @Inject
    private PortalManager portalManager;
    @Inject
    private ByteRangeRequestCache byteRangeCache;
    @Inject
    private VelocityService velocityService;
    @Autowired
    private LanguageServiceMXBean languageServiceMXBean;
    private Map<String, FascinatorService> services;
    private Logger log = LoggerFactory.getLogger(ScriptingServicesImpl.class);

    public ScriptingServicesImpl() {
        try {
            this.services = new HashMap<String, FascinatorService>();
            JsonSimpleConfig config = new JsonSimpleConfig();
            List serviceConfigs = config.getJsonSimpleList(new Object[]{"services"});
            if (serviceConfigs != null) {
                for (JsonSimple serviceConfig : serviceConfigs) {
                    String srvId = serviceConfig.getString(null, new Object[]{"id"});
                    String srvClass = serviceConfig.getString(null, new Object[]{"className"});
                    this.log.debug("Creating FascinatorService with ID:" + srvId + ", using class:" + srvClass);
                    FascinatorService service = (FascinatorService)Class.forName(srvClass).newInstance();
                    service.setConfig(serviceConfig);
                    service.init();
                    this.services.put(srvId, service);
                }
            } else {
                this.log.debug("No Fascinator services defined.");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.languageServiceMXBean == null) {
            this.languageServiceMXBean = (LanguageServiceMXBean)ApplicationContextProvider.getApplicationContext().getBean("languageServiceMXBean");
            ((LanguageServiceMXBeanImpl)this.languageServiceMXBean).setTapestryScriptingService(this);
        }
    }

    @Override
    public DatabaseServices getDatabase() {
        return this.database;
    }

    @Override
    public DynamicPageService getPageService() {
        return this.pageService;
    }

    @Override
    public Indexer getIndexer() {
        return this.indexerService;
    }

    @Override
    public Storage getStorage() {
        return this.storageService;
    }

    @Override
    public HarvestManager getHarvestManager() {
        return this.harvestManager;
    }

    @Override
    public HouseKeepingManager getHouseKeepingManager() {
        return this.houseKeeping;
    }

    @Override
    public PortalManager getPortalManager() {
        return this.portalManager;
    }

    @Override
    public ByteRangeRequestCache getByteRangeCache() {
        return this.byteRangeCache;
    }

    @Override
    public VelocityService getVelocityService() {
        return this.velocityService;
    }

    @Override
    public FascinatorService getService(String serviceName) {
        return this.services.get(serviceName);
    }
}

