/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.api.impl;

import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.portal.api.APICallHandler;
import com.googlecode.fascinator.portal.services.ScriptingServices;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.tapestry5.services.Request;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishedRecordsByTypeAPICallHandlerImpl
implements APICallHandler {
    private ScriptingServices scriptingServices;
    private Logger log = LoggerFactory.getLogger(PublishedRecordsByTypeAPICallHandlerImpl.class);

    public String handleRequest(Request request) throws Exception {
        String dateFromString = request.getParameter("dateFrom");
        String dateToString = request.getParameter("dateTo");
        HashSet<String> publishedOidSet = new HashSet<String>();
        Indexer indexer = this.scriptingServices.getIndexer();
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        String eventLogQuery = "context:\"Curation\" AND eventType:\"Curation completed.\" AND eventTime:[" + dateFromString + "T00:00:00.000Z TO " + dateToString + "T23:59:59.999Z]";
        SearchRequest searchRequest = new SearchRequest(eventLogQuery);
        int start = 0;
        int pageSize = 10;
        searchRequest.setParam("start", "" + start);
        searchRequest.setParam("rows", "" + pageSize);
        indexer.searchByIndex(searchRequest, (OutputStream)result, "eventLog");
        SolrResult resultObject = new SolrResult(result.toString());
        int numFound = resultObject.getNumFound();
        while (true) {
            List results = resultObject.getResults();
            for (SolrDoc docObject : results) {
                String oid = docObject.getString(null, new Object[]{"oid"});
                if (oid == null) continue;
                publishedOidSet.add(oid);
            }
            if ((start += pageSize) > numFound) break;
            searchRequest.setParam("start", "" + start);
            result = new ByteArrayOutputStream();
            indexer.searchByIndex(searchRequest, (OutputStream)result, "eventLog");
            resultObject = new SolrResult(result.toString());
        }
        HashMap<String, Integer> typeCountMap = new HashMap<String, Integer>();
        typeCountMap.put("Activities", 0);
        typeCountMap.put("Parties_People", 0);
        typeCountMap.put("Parties_Groups", 0);
        typeCountMap.put("Services", 0);
        if (publishedOidSet.size() > 0) {
            StringBuilder query = new StringBuilder();
            query.append("id:(");
            for (String publishedOid : publishedOidSet) {
                if (query.length() > 4) {
                    query.append(" OR ");
                }
                query.append(publishedOid);
            }
            query.append(" )");
            searchRequest = new SearchRequest(query.toString());
            result = new ByteArrayOutputStream();
            start = 0;
            pageSize = 10;
            searchRequest.setParam("start", "" + start);
            searchRequest.setParam("rows", "" + pageSize);
            indexer.search(searchRequest, (OutputStream)result);
            resultObject = new SolrResult(result.toString());
            numFound = resultObject.getNumFound();
            while (true) {
                List results = resultObject.getResults();
                for (SolrDoc docObject : results) {
                    JSONArray oaiSetArr = docObject.getArray(new Object[]{"oai_set"});
                    if (oaiSetArr != null && oaiSetArr.size() > 0) {
                        String oaiSet = (String)oaiSetArr.get(0);
                        this.log.debug("OAI Set for " + docObject.getString("<>", new Object[]{"id"}) + " is:" + oaiSet);
                        if (oaiSet == null) continue;
                        Integer curCount = (Integer)typeCountMap.get(oaiSet);
                        if (curCount != null) {
                            this.log.debug("CurCount is:" + curCount);
                            typeCountMap.put(oaiSet, new Integer(curCount + 1));
                            continue;
                        }
                        this.log.debug("CurCount is NULL");
                        continue;
                    }
                    this.log.debug("NULL OAISET");
                }
                if ((start += pageSize) > numFound) break;
                searchRequest.setParam("start", "" + start);
                result = new ByteArrayOutputStream();
                indexer.search(searchRequest, (OutputStream)result);
                resultObject = new SolrResult(result.toString());
            }
        }
        return new JsonObject(typeCountMap).toJSONString();
    }

    public void setScriptingServices(ScriptingServices scriptingServices) {
        this.scriptingServices = scriptingServices;
    }
}

