/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.pages;

import com.googlecode.fascinator.HarvestClient;
import com.googlecode.fascinator.api.PluginException;
import com.googlecode.fascinator.api.authentication.AuthenticationException;
import com.googlecode.fascinator.api.authentication.User;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import com.googlecode.fascinator.common.MimeTypeUtil;
import com.googlecode.fascinator.portal.FormData;
import com.googlecode.fascinator.portal.JsonSessionState;
import com.googlecode.fascinator.portal.services.DynamicPageService;
import com.googlecode.fascinator.portal.services.GenericStreamResponse;
import com.googlecode.fascinator.portal.services.HttpStatusCodeResponse;
import com.googlecode.fascinator.portal.services.PortalManager;
import com.googlecode.fascinator.portal.services.PortalSecurityManager;
import com.googlecode.fascinator.portal.services.VelocityService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.util.TimeInterval;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.RequestGlobals;
import org.apache.tapestry5.services.Response;
import org.apache.tapestry5.upload.services.MultipartDecoder;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

public class Dispatch {
    private static final String AJAX_EXT = ".ajax";
    private static final String POST_EXT = ".post";
    private static final String SCRIPT_EXT = ".script";
    public static final String DEFAULT_RESOURCE = "home";
    @Inject
    private Logger log;
    @SessionState
    private JsonSessionState sessionState;
    @Inject
    private DynamicPageService pageService;
    @Inject
    private PortalManager portalManager;
    @Inject
    private PortalSecurityManager security;
    @Inject
    private VelocityService velocityService;
    @Inject
    private Request request;
    @Inject
    private Response response;
    @Inject
    private MultipartDecoder decoder;
    @Inject
    private RequestGlobals rg;
    private FormData formData;
    private String resourceName;
    private String portalId;
    private String defaultPortal;
    private String requestUri;
    private String[] path;
    private HttpServletRequest hsr;
    private boolean isFile;
    private boolean isSpecial;
    private String mimeType;
    private InputStream stream;
    private JsonSimpleConfig sysConfig;

    public StreamResponse onActivate(Object ... params) {
        boolean redirected;
        try {
            this.sysConfig = new JsonSimpleConfig();
            this.defaultPortal = this.sysConfig.getString("default", new Object[]{"portal", "defaultView"});
        }
        catch (IOException ex) {
            this.log.error("Error accessing system config", (Throwable)ex);
            return new HttpStatusCodeResponse(500, "Sorry, an internal server error has occured");
        }
        this.resourceName = this.resourceProcessing();
        if (this.resourceName == null) {
            if (this.response.isCommitted()) {
                return GenericStreamResponse.noResponse();
            }
            return new HttpStatusCodeResponse(404, "Page not found: " + this.requestUri);
        }
        this.prepareFormData();
        int timeoutMins = this.sysConfig.getInteger(Integer.valueOf(120), new Object[]{"portal", "sessionTimeout"});
        this.hsr.getSession().setMaxInactiveInterval(timeoutMins * 60);
        if (!this.isSpecial && this.security.testForSso(this.sessionState, this.resourceName, this.requestUri) && (redirected = this.security.runSsoIntegration(this.sessionState, this.formData))) {
            return GenericStreamResponse.noResponse();
        }
        if (this.resourceName.indexOf(".") != -1 && !this.isSpecial) {
            this.response.setHeader("Cache-Control", "public");
            this.response.setDateHeader("Expires", System.currentTimeMillis() + new TimeInterval("10y").milliseconds());
        }
        this.isFile = ServletFileUpload.isMultipartContent((HttpServletRequest)this.hsr);
        if (this.isFile) {
            this.fileProcessing();
        }
        this.renderProcessing();
        return new GenericStreamResponse(this.mimeType, this.stream);
    }

    private void prepareFormData() {
        this.hsr = this.rg.getHTTPServletRequest();
        if ((this.resourceName.indexOf(".") == -1 || this.isSpecial) && this.formData == null) {
            this.formData = new FormData(this.request, this.hsr);
        }
    }

    private void fileProcessing() {
        UploadedFile uploadedFile = null;
        String workflowId = null;
        String username = (String)this.sessionState.get("username");
        String userSource = (String)this.sessionState.get("source");
        List<String> roles = null;
        try {
            User user = this.security.getUser(this.sessionState, username, userSource);
            String[] roleArray = this.security.getRolesList(this.sessionState, user);
            roles = Arrays.asList(roleArray);
        }
        catch (AuthenticationException ex) {
            this.log.error("Error retrieving user data.");
            return;
        }
        List reqParams = this.request.getParameterNames();
        this.log.info("REQUEST {}", (Object)this.request);
        this.log.info("reqParams {}", (Object)reqParams);
        if (reqParams.contains("upload-file-workflow")) {
            workflowId = this.request.getParameter("upload-file-workflow");
        }
        if (workflowId == null) {
            this.log.error("No workflow provided with form data.");
            return;
        }
        String uploadContext = "";
        if (reqParams.contains("upload-file-context")) {
            uploadContext = this.request.getParameter("upload-file-context");
        }
        JsonSimple workflowConfig = (JsonSimple)this.sysConfig.getJsonSimpleMap(new Object[]{"uploader"}).get(workflowId);
        boolean security_check = false;
        for (String role : workflowConfig.getStringList(new Object[]{"security"})) {
            if (!roles.contains(role)) continue;
            security_check = true;
        }
        if (!security_check) {
            this.log.error("Security error, current user not allowed to upload.");
            return;
        }
        String file_path = workflowConfig.getString(null, new Object[]{"upload-path"});
        for (String param : reqParams) {
            UploadedFile tmpFile = this.decoder.getFileUpload(param);
            if (tmpFile == null) continue;
            uploadedFile = tmpFile;
        }
        if (uploadedFile == null) {
            this.log.error("No uploaded file found!");
            return;
        }
        file_path = uploadContext == null || "".equals(uploadContext) ? file_path + "/" + uploadedFile.getFileName() : file_path + "/" + uploadContext + "/" + uploadedFile.getFileName();
        File file = new File(file_path);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                this.log.error("Failed writing file", (Throwable)ex);
                return;
            }
        }
        uploadedFile.write(file);
        String configPath = workflowConfig.getString(null, new Object[]{"json-config"});
        if (configPath == null) {
            this.log.error("No harvest configuration file provided!");
            return;
        }
        File harvestFile = new File(configPath);
        String template = "";
        try {
            JsonSimple harvestConfig = new JsonSimple(harvestFile);
            List stages = harvestConfig.getJsonSimpleList(new Object[]{"stages"});
            if (stages.size() > 0) {
                template = ((JsonSimple)stages.get(0)).getString(null, new Object[]{"template"});
            }
        }
        catch (IOException ex) {
            this.log.error("Unable to access workflow config : ", (Throwable)ex);
        }
        HarvestClient harvester = null;
        String oid = null;
        String error = null;
        try {
            harvester = new HarvestClient(harvestFile, file, username);
            harvester.start();
            oid = harvester.getUploadOid();
            harvester.shutdown();
        }
        catch (PluginException ex) {
            error = "File upload failed : " + ex.getMessage();
            this.log.error(error);
            harvester.shutdown();
        }
        catch (Exception ex) {
            this.log.error("Failed harvest", (Throwable)ex);
            return;
        }
        boolean success = file.delete();
        if (!success) {
            this.log.error("Error deleting uploaded file from cache: " + file.getAbsolutePath());
        }
        LinkedHashMap<String, String> file_details = new LinkedHashMap<String, String>();
        file_details.put("name", uploadedFile.getFileName());
        if (error != null) {
            Pattern pattern = Pattern.compile("au\\..+Exception:");
            Matcher matcher = pattern.matcher(error);
            file_details.put("error", matcher.replaceAll(""));
        }
        file_details.put("workflow", workflowId);
        file_details.put("template", template);
        file_details.put("location", file_path);
        file_details.put("size", String.valueOf(uploadedFile.getSize()));
        file_details.put("type", uploadedFile.getContentType());
        if (oid != null) {
            file_details.put("oid", oid);
        }
        this.sessionState.set("fileName", (Object)uploadedFile.getFileName());
        this.sessionState.set(uploadedFile.getFileName(), file_details);
        this.formData.set("fileProcessing", "true");
        this.formData.set("oid", oid);
        this.sessionState.set("uploadFormData", (Object)this.formData);
    }

    private void renderProcessing() {
        if (this.resourceName.indexOf(".") == -1 || this.isSpecial) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.mimeType = this.pageService.render(this.portalId, this.resourceName, (OutputStream)out, this.formData, this.sessionState);
            this.stream = new ByteArrayInputStream(out.toByteArray());
        } else {
            this.mimeType = MimeTypeUtil.getMimeType((String)this.resourceName);
            this.stream = this.velocityService.getResource(this.portalId, this.resourceName);
        }
    }

    private String resourceProcessing() {
        this.requestUri = this.request.getAttribute("RequestURI").toString();
        this.path = this.requestUri.split("/");
        if ("".equals(this.requestUri) || this.path.length == 1) {
            this.portalId = "".equals(this.path[0]) ? this.defaultPortal : this.path[0];
            String url = this.sysConfig.getString(null, new Object[]{"urlBase"});
            url = url != null ? url + this.portalId + "/" + DEFAULT_RESOURCE : this.request.getContextPath() + "/" + this.portalId + "/" + DEFAULT_RESOURCE;
            try {
                this.log.debug("REDIRECT : '{}'", (Object)url);
                this.response.sendRedirect(url);
            }
            catch (IOException ioe) {
                this.log.error("Failed to redirect to default URL: {}", (Object)url);
            }
            return null;
        }
        this.portalId = (String)this.sessionState.get("portalId", (Object)this.defaultPortal);
        this.resourceName = DEFAULT_RESOURCE;
        if (this.path.length > 1) {
            this.portalId = this.path[0];
            this.resourceName = StringUtils.join((Object[])this.path, (String)"/", (int)1, (int)this.path.length);
        }
        if (!this.portalManager.exists(this.portalId)) {
            return null;
        }
        this.isSpecial = false;
        String match = this.getBestMatchResource(this.resourceName);
        return match;
    }

    public String getBestMatchResource(String resource) {
        String searchable = resource;
        String ext = "";
        if (resource.endsWith(AJAX_EXT)) {
            this.isSpecial = true;
            ext = AJAX_EXT;
        }
        if (resource.endsWith(SCRIPT_EXT)) {
            this.isSpecial = true;
            ext = SCRIPT_EXT;
        }
        if (this.isSpecial) {
            searchable = resource.substring(0, resource.lastIndexOf(ext));
        }
        if (this.velocityService.resourceExists(this.portalId, searchable) != null) {
            return resource;
        }
        int slash = resource.lastIndexOf(47);
        if (slash != -1) {
            return this.getBestMatchResource(resource.substring(0, slash));
        }
        return null;
    }
}

