/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.process;

import com.googlecode.fascinator.api.indexer.Indexer;
import com.googlecode.fascinator.api.indexer.IndexerException;
import com.googlecode.fascinator.api.indexer.SearchRequest;
import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.StorageDataUtil;
import com.googlecode.fascinator.common.solr.SolrDoc;
import com.googlecode.fascinator.common.solr.SolrResult;
import com.googlecode.fascinator.portal.process.Processor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.activation.DataSource;
import javax.mail.Authenticator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.mail.ByteArrayDataSource;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.MultiPartEmail;
import org.apache.commons.mail.SimpleEmail;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.json.simple.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailNotifier
implements Processor {
    private Logger log = LoggerFactory.getLogger(EmailNotifier.class);
    private String host;
    private String port;
    private String tls;
    private String ssl;
    private String username;
    private String password;
    private boolean isVariableNameHiddenIfEmpty;

    private void init(JsonSimple config) {
        this.host = config.getString("", new Object[]{"host"});
        this.port = config.getString("", new Object[]{"port"});
        this.username = config.getString("", new Object[]{"username"});
        this.password = config.getString("", new Object[]{"password"});
        this.tls = config.getString("false", new Object[]{"tls"});
        this.ssl = config.getString("false", new Object[]{"ssl"});
        this.isVariableNameHiddenIfEmpty = Boolean.parseBoolean(config.getString("false", new Object[]{"isVariableNameHiddenIfEmpty"}));
        Properties props = System.getProperties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", this.tls);
    }

    private void initVars(SolrDoc solrDoc, List<String> vars, JsonSimple config, VelocityContext context) {
        for (String var : vars) {
            String varField = config.getString("", new Object[]{"mapping", var});
            String replacement = this.getCollectionValues(config, (JsonSimple)solrDoc, varField);
            if (StringUtils.isBlank((String)replacement)) {
                replacement = this.isVariableNameHiddenIfEmpty ? solrDoc.getString("", new Object[]{varField}) : solrDoc.getString(var, new Object[]{varField});
            }
            if (replacement == null || "".equals(replacement)) {
                JSONArray arr = solrDoc.getArray(new Object[]{varField});
                if (arr != null) {
                    replacement = (String)arr.get(0);
                    if (replacement == null) {
                        replacement = this.isVariableNameHiddenIfEmpty ? "" : var;
                    }
                } else {
                    replacement = this.isVariableNameHiddenIfEmpty ? "" : var;
                }
            }
            this.log.debug("Getting variable value '" + var + "' using field '" + varField + "', value:" + replacement);
            context.put(var.replace("$", ""), (Object)replacement);
        }
    }

    public String getCollectionValues(JsonSimple emailConfig, JsonSimple tfPackage, String varField) {
        String formattedCollectionValues = "";
        JSONArray subKeys = emailConfig.getArray(new Object[]{"collections", varField, "subKeys"});
        String tfPackageField = emailConfig.getString("", new Object[]{"collections", varField, "payloadKey"});
        if (StringUtils.isNotBlank((String)tfPackageField) && subKeys instanceof JSONArray) {
            List jsonList = new StorageDataUtil().getJavaList(tfPackage, tfPackageField);
            this.log.debug("Collating collection values for email template...");
            JSONArray fieldSeparators = emailConfig.getArray(new Object[]{"collections", varField, "fieldSeparators"});
            String recordSeparator = emailConfig.getString(IOUtils.LINE_SEPARATOR, new Object[]{"collections", varField, "recordSeparator"});
            String nextDelimiter = " ";
            for (JsonObject collectionRow : jsonList) {
                if (fieldSeparators instanceof JSONArray && fieldSeparators.size() > 0) {
                    Object nextFieldSeparator = fieldSeparators.remove(0);
                    if (nextFieldSeparator instanceof String) {
                        nextDelimiter = (String)nextFieldSeparator;
                    } else {
                        this.log.warn("Unable to retrieve String value from fieldSeparator: " + fieldSeparators.toString());
                    }
                }
                ArrayList<String> collectionValuesList = new ArrayList<String>();
                for (Object requiredKey : subKeys) {
                    Object rawKeyValue = collectionRow.get(requiredKey);
                    if (rawKeyValue instanceof String) {
                        String keyValue = StringUtils.trim((String)((String)rawKeyValue));
                        if (StringUtils.isNotBlank((String)keyValue)) {
                            collectionValuesList.add(keyValue);
                            continue;
                        }
                        if (!this.isVariableNameHiddenIfEmpty) {
                            collectionValuesList.add("$" + requiredKey);
                            continue;
                        }
                        this.log.info("blank variable name will be hidden: " + keyValue);
                        continue;
                    }
                    this.log.warn("No string value returned from: " + requiredKey);
                }
                formattedCollectionValues = formattedCollectionValues + StringUtils.join(collectionValuesList, (String)nextDelimiter) + recordSeparator;
            }
            formattedCollectionValues = StringUtils.chomp((String)formattedCollectionValues, (String)recordSeparator);
            this.log.debug("email formatted collection values: " + formattedCollectionValues);
        }
        return formattedCollectionValues;
    }

    public String sanitizeAndEvaluateStr(String source, VelocityContext context) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException {
        String result = this.preEvaluateAndSanitizeTemplate(source);
        result = this.evaluateStr(result, context);
        result = this.postEvaluateAndSanitizeTemplate(result);
        return result;
    }

    private String preEvaluateAndSanitizeTemplate(String template) {
        String quietVelocityPattern = "(\\$)(?=([^\\d\\!]))";
        String quietVelocityReplacement = "$1!";
        String result = template.replaceAll(quietVelocityPattern, quietVelocityReplacement);
        result = result.replaceAll("\\$!hashString", "\\$hashString");
        return result;
    }

    private String evaluateStr(String source, VelocityContext context) throws ParseErrorException, MethodInvocationException, ResourceNotFoundException, IOException {
        StringWriter writer = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)writer, (String)"evaluateStr", (String)source);
        return writer.toString();
    }

    private String postEvaluateAndSanitizeTemplate(String template) {
        String result = template.replaceAll(",[ \t]*,", "");
        result = result.replaceAll("\\([ \t]*\\)", "");
        return result;
    }

    public boolean process(String id, String inputKey, String outputKey, String stage, String configFilePath, HashMap<String, Object> dataMap) throws Exception {
        this.log.debug("Email notifier starting:" + id);
        JsonSimple config = new JsonSimple(new File(configFilePath));
        this.init(config);
        Indexer indexer = (Indexer)dataMap.get("indexer");
        HashSet failedOids = (HashSet)dataMap.get(outputKey);
        if (failedOids == null) {
            failedOids = new HashSet();
        }
        Collection oids = (Collection)dataMap.get(inputKey);
        JSONArray emailConfigBlocks = config.getArray(new Object[]{id});
        if (emailConfigBlocks != null) {
            for (Object configBlockObj : emailConfigBlocks) {
                JsonSimple emailConfig = new JsonSimple((JsonObject)configBlockObj);
                this.doEmail(outputKey, dataMap, emailConfig, indexer, failedOids, oids);
            }
        } else {
            this.doEmail(outputKey, dataMap, config, indexer, failedOids, oids);
        }
        dataMap.put(outputKey, failedOids);
        return true;
    }

    private void doEmail(String outputKey, HashMap dataMap, JsonSimple config, Indexer indexer, HashSet<String> failedOids, Collection<String> oids) throws IndexerException, IOException {
        String subjectTemplate = config.getString("", new Object[]{"subject"});
        String bodyTemplate = config.getString("", new Object[]{"body"});
        List vars = config.getStringList(new Object[]{"vars"});
        this.log.debug("Email step with subject template:" + subjectTemplate);
        for (String oid : oids) {
            String body;
            String subject;
            this.log.debug("Sending email notification for oid:" + oid);
            SearchRequest searchRequest = new SearchRequest("id:" + oid);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            indexer.search(searchRequest, (OutputStream)result);
            SolrResult resultObject = new SolrResult(result.toString());
            List results = resultObject.getResults();
            SolrDoc solrDoc = (SolrDoc)results.get(0);
            VelocityContext context = new VelocityContext();
            this.initVars(solrDoc, vars, config, context);
            if (this.isVariableNameHiddenIfEmpty) {
                subject = this.sanitizeAndEvaluateStr(subjectTemplate, context);
                body = this.sanitizeAndEvaluateStr(bodyTemplate, context);
            } else {
                subject = this.evaluateStr(subjectTemplate, context);
                body = this.evaluateStr(bodyTemplate, context);
            }
            String to = config.getString("", new Object[]{"to"});
            String from = config.getString("", new Object[]{"from"});
            String recipient = this.evaluateStr(to, context);
            if (recipient.startsWith("$")) {
                this.log.error("Failed to build the email recipient:'" + recipient + "'. Please check the mapping field and verify that it exists and is populated in Solr.");
                failedOids.add(oid);
                continue;
            }
            if (this.email(oid, from, recipient, subject, body)) continue;
            failedOids.add(oid);
        }
    }

    public boolean email(String oid, String from, String recipient, String subject, String body) {
        try {
            SimpleEmail email = new SimpleEmail();
            this.log.debug("Email host: " + this.host);
            this.log.debug("Email port: " + this.port);
            this.log.debug("Email username: " + this.username);
            this.log.debug("Email from: " + from);
            this.log.debug("Email to: " + recipient);
            this.log.debug("Email Subject is: " + subject);
            this.log.debug("Email Body is: " + body);
            email.setHostName(this.host);
            email.setSmtpPort(Integer.parseInt(this.port));
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.username, this.password));
            email.setSSL("true".equalsIgnoreCase(this.ssl));
            email.setTLS("true".equalsIgnoreCase(this.tls));
            email.setFrom(from);
            email.setSubject(subject);
            email.setMsg(body);
            if (recipient.indexOf(",") >= 0) {
                String[] recs;
                for (String rec : recs = recipient.split(",")) {
                    email.addTo(rec);
                }
            } else {
                email.addTo(recipient);
            }
            email.send();
        }
        catch (Exception ex) {
            this.log.debug("Error sending notification mail for oid:" + oid, (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean emailAttachment(String from, String recipient, String subject, String body, byte[] attachData, String attachDataType, String attachFileName, String attachDesc) throws Exception {
        MultiPartEmail email = new MultiPartEmail();
        email.attach((DataSource)new ByteArrayDataSource(attachData, attachDataType), attachFileName, attachDesc, "attachment");
        this.log.debug("Email host: " + this.host);
        this.log.debug("Email port: " + this.port);
        this.log.debug("Email username: " + this.username);
        this.log.debug("Email from: " + from);
        this.log.debug("Email to: " + recipient);
        this.log.debug("Email Subject is: " + subject);
        this.log.debug("Email Body is: " + body);
        email.setHostName(this.host);
        email.setSmtpPort(Integer.parseInt(this.port));
        email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.username, this.password));
        email.setSSL("true".equalsIgnoreCase(this.ssl));
        email.setTLS("true".equalsIgnoreCase(this.tls));
        email.setFrom(from);
        email.setSubject(subject);
        email.setMsg(body);
        if (recipient.indexOf(",") >= 0) {
            String[] recs;
            for (String rec : recs = recipient.split(",")) {
                email.addTo(rec);
            }
        } else {
            email.addTo(recipient);
        }
        email.send();
        return true;
    }
}

