/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.quartz;

import com.googlecode.fascinator.common.JsonObject;
import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.portal.process.Processor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessingSetJob
implements StatefulJob {
    private Logger log = LoggerFactory.getLogger(ProcessingSetJob.class);
    private String name;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.name = context.getJobDetail().getName();
        this.log.debug("ProcessingSetJob executing:" + this.name);
        JobDataMap dataMap = context.getJobDetail().getJobDataMap();
        JsonSimple jobConfig = (JsonSimple)dataMap.get((Object)"jobConfig");
        String configPath = jobConfig.getString("", new Object[]{"configFile"});
        JsonSimple procConfig = null;
        try {
            File procConfigFile = new File(configPath);
            if (!procConfigFile.exists()) {
                this.log.error("Config file does not exist: " + configPath);
                throw new JobExecutionException("Config file does not exist:" + configPath);
            }
            procConfig = new JsonSimple(procConfigFile);
        }
        catch (IOException e) {
            this.log.error("Error loading config file: {}", (Object)configPath, (Object)e);
            throw new JobExecutionException((Throwable)e);
        }
        String setId = jobConfig.getString("", new Object[]{"setId"});
        this.log.debug("Using setId: " + setId);
        for (Object procObj : procConfig.getJsonArray()) {
            JsonSimple pconfig = new JsonSimple((JsonObject)procObj);
            String procId = pconfig.getString("", new Object[]{"id"});
            HashMap<String, Object> procDataMap = new HashMap<String, Object>();
            procDataMap.put("indexer", dataMap.get((Object)"indexer"));
            try {
                if ("".equals(setId)) {
                    this.execProc(procId, pconfig, procDataMap);
                    continue;
                }
                if (!setId.equalsIgnoreCase(procId)) continue;
                this.execProc(procId, pconfig, procDataMap);
            }
            catch (Exception e) {
                this.log.error("Error executing processing set:" + procId, (Throwable)e);
                throw new JobExecutionException((Throwable)e);
            }
        }
    }

    private void execProc(String procId, JsonSimple config, HashMap<String, Object> dataMap) throws Exception {
        this.execProcStage(procId, config, dataMap, "pre");
        this.execProcStage(procId, config, dataMap, "main");
        this.execProcStage(procId, config, dataMap, "post");
    }

    private void execProcStage(String procId, JsonSimple configJson, HashMap<String, Object> dataMap, String stageName) throws Exception {
        for (Object procObj : configJson.getArray(new Object[]{stageName})) {
            JsonSimple procJson = new JsonSimple((JsonObject)procObj);
            String procClassName = procJson.getString("", new Object[]{"class"});
            String procConfigPath = procJson.getString("", new Object[]{"config"});
            String procInputKey = procJson.getString("", new Object[]{"inputKey"});
            String procOutputKey = procJson.getString("", new Object[]{"outputKey"});
            this.log.debug("Executing procId: " + procId + ", using class: " + procClassName + ", with stage: " + stageName);
            Class<?> procClass = Class.forName(procClassName);
            Processor procInst = (Processor)procClass.newInstance();
            dataMap.put(procClassName, procInst);
            procInst.process(procId, procInputKey, procOutputKey, stageName, procConfigPath, dataMap);
        }
    }
}

