/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.services.impl;

import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.portal.services.LanguageService;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionSpecificJavaPropertiesLanguageService
implements LanguageService {
    private Logger log = LoggerFactory.getLogger(RegionSpecificJavaPropertiesLanguageService.class);
    private JsonSimple config;
    private Map<String, Properties> propertiesFiles = new HashMap();

    public JsonSimple getConfig() {
        return this.config;
    }

    public void setConfig(JsonSimple config) {
        this.config = config;
    }

    public void init() {
        this.log.debug("Initializing RegionSpecificJavaPropertiesLanguageService ...");
        this.reloadLanguageFiles();
    }

    public String displayMessage(String messageCode, String region) {
        Properties regionProperties = (Properties)this.propertiesFiles.get(region);
        if (regionProperties != null && regionProperties.get(messageCode) != null) {
            return (String)regionProperties.get(messageCode);
        }
        regionProperties = (Properties)this.propertiesFiles.get("default");
        if (regionProperties != null && regionProperties.get(messageCode) != null) {
            return (String)regionProperties.get(messageCode);
        }
        return messageCode;
    }

    public String displayMessage(String messageCode) {
        return this.displayMessage(messageCode, "default");
    }

    public void reloadLanguageFiles() {
        File[] file;
        this.propertiesFiles.clear();
        File propertiesDir = new File(this.config.getString(null, new Object[]{"config", "propertiesDir"}));
        if (!propertiesDir.exists()) {
            this.log.error("Can't find properties directory " + propertiesDir.getPath());
            return;
        }
        this.log.debug("Loading from {} ", (Object)propertiesDir.getPath());
        for (File propertyFileDirectory : file = propertiesDir.listFiles()) {
            if (!propertyFileDirectory.isDirectory()) continue;
            String regionName = propertyFileDirectory.getName();
            Properties mergedProperties = new Properties();
            for (File propertyFile : propertyFileDirectory.listFiles()) {
                try {
                    Properties properties = new Properties();
                    FileInputStream propertyFileInputStream = new FileInputStream(propertyFile);
                    properties.load(propertyFileInputStream);
                    propertyFileInputStream.close();
                    mergedProperties.putAll((Map<?, ?>)properties);
                }
                catch (Exception e) {
                    this.log.error("Can't find properties properties file " + propertyFile.getPath(), (Throwable)e);
                }
            }
            this.propertiesFiles.put(regionName, mergedProperties);
        }
    }
}

