/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.portal.security.filter;

import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.filters.SecurityWrapperResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class FascinatorOwaspInterceptorFilter
extends OncePerRequestFilter {
    private static Logger LOG = LoggerFactory.getLogger(FascinatorOwaspInterceptorFilter.class);
    private JsonSimpleConfig config = new JsonSimpleConfig();

    public FascinatorOwaspInterceptorFilter() throws IOException {
        LOG.info("starting filter for owasp...");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.checkConfigReload();
        SecurityWrapperResponse securityWrapperResponse = new SecurityWrapperResponse(response, "sanitize");
        this.checkHttpOnly(request, securityWrapperResponse);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void checkConfigReload() {
        if (this.config.getBoolean(Boolean.valueOf(false), new Object[]{"reload"}).booleanValue()) {
            try {
                this.config = new JsonSimpleConfig();
            }
            catch (IOException e) {
                LOG.warn("Problem with configuration loading. Reloading disabled.");
            }
        }
    }

    private void checkHttpOnly(HttpServletRequest request, SecurityWrapperResponse securityWrapperResponse) {
        if (this.config.getBoolean(Boolean.valueOf(false), new Object[]{"owasp", "httponly"}).booleanValue()) {
            List cookies = CollectionUtils.arrayToList((Object)request.getCookies());
            for (Cookie cookie : cookies) {
                if (!ESAPI.securityConfiguration().getHttpSessionIdName().equals(cookie.getName())) continue;
                securityWrapperResponse.addCookie(cookie);
            }
        }
    }
}

