/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.fascinator.sequences;

import com.googlecode.fascinator.common.JsonSimple;
import com.googlecode.fascinator.common.JsonSimpleConfig;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="sequenceService")
public class SequenceService {
    private final Logger log = LoggerFactory.getLogger(SequenceService.class);
    private static String DERBY_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    private static String DERBY_PROTOCOL = "jdbc:derby:";
    private static String SEQUENCE_DATABASE = "sequence";
    private static String SEQUENCE_TABLE = "sequences";
    private String derbyHome;
    private Connection connection;

    @PostConstruct
    public void init() throws IOException, SQLException {
        JsonSimpleConfig config = new JsonSimpleConfig();
        this.init((JsonSimple)config);
    }

    public void init(JsonSimple config) throws IOException, SQLException {
        this.derbyHome = config.getString(null, new Object[]{"database-service", "derbyHome"});
        String oldHome = System.getProperty("derby.system.home");
        if (oldHome != null) {
            if (this.derbyHome != null) {
                this.log.warn("Using previously specified data directory: '{}', provided value has been ignored: '{}'", (Object)oldHome, (Object)this.derbyHome);
            } else {
                this.log.info("Using existing data directory: '{}'", (Object)oldHome);
            }
        } else {
            if (this.derbyHome == null) {
                this.log.error("No database home directory configured!");
                return;
            }
            File file = new File(this.derbyHome);
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IOException("Database home '" + this.derbyHome + "' is not a directory!");
                }
            } else {
                file.mkdirs();
                if (!file.exists()) {
                    throw new IOException("Database home '" + this.derbyHome + "' does not exist and could not be created!");
                }
            }
            System.setProperty("derby.system.home", this.derbyHome);
        }
        try {
            this.checkTable(SEQUENCE_TABLE);
        }
        catch (SQLException ex) {
            this.log.error("Error during database preparation:", (Throwable)ex);
            throw new SQLException("Error during database preparation:", ex);
        }
        this.log.debug("Derby security database online!");
    }

    private Connection connection() throws SQLException {
        if (this.connection == null || !this.connection.isValid(1)) {
            if (this.connection != null) {
                this.log.error("!!! Database connection has failed, recreating.");
                try {
                    this.connection.close();
                }
                catch (SQLException ex) {
                    this.log.error("Error closing invalid connection, ignoring: {}", (Object)ex.getMessage());
                }
            }
            Properties props = new Properties();
            try {
                Class.forName(DERBY_DRIVER).newInstance();
            }
            catch (Exception ex) {
                this.log.error("Driver load failed: ", (Throwable)ex);
                throw new SQLException("Driver load failed: ", ex);
            }
            this.connection = DriverManager.getConnection(DERBY_PROTOCOL + SEQUENCE_DATABASE + ";create=true", props);
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws SQLException {
        String threadedShutdownMessage = DERBY_DRIVER + " is not registered with the JDBC driver manager";
        try {
            DriverManager.getConnection(DERBY_PROTOCOL + ";shutdown=true");
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == 50000 && ex.getSQLState().equals("XJ015")) {
            } else if (!ex.getMessage().equals(threadedShutdownMessage)) {
                this.log.error("Error during database shutdown:", (Throwable)ex);
                throw new SQLException("Error during database shutdown:", ex);
            }
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (SQLException ex) {
                this.log.error("Error closing connection:", (Throwable)ex);
            }
        }
    }

    private void checkTable(String table) throws SQLException {
        boolean tableFound = this.findTable(table);
        if (!tableFound) {
            this.log.debug("Table '{}' not found, creating now!", (Object)table);
            this.createTable(table);
            if (!this.findTable(table)) {
                this.log.error("Unknown error creating table '{}'", (Object)table);
                throw new SQLException("Could not find or create table '" + table + "'");
            }
        }
    }

    private boolean findTable(String table) throws SQLException {
        boolean tableFound = false;
        DatabaseMetaData meta = this.connection().getMetaData();
        ResultSet result = meta.getTables(null, null, null, null);
        while (result.next() && !tableFound) {
            if (!result.getString("TABLE_NAME").equalsIgnoreCase(table)) continue;
            tableFound = true;
        }
        this.close(result);
        return tableFound;
    }

    private void createTable(String table) throws SQLException {
        if (table.equals(SEQUENCE_TABLE)) {
            Statement sql = this.connection().createStatement();
            sql.execute("CREATE TABLE " + SEQUENCE_TABLE + "(sequence_name VARCHAR(255) NOT NULL, " + "counter INTEGER NOT NULL," + "PRIMARY KEY (sequence_name))");
            this.close(sql);
            return;
        }
        throw new SQLException("Unknown table '" + table + "' requested!");
    }

    private void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException ex) {
                this.log.error("Error closing result set: ", (Throwable)ex);
            }
        }
        resultSet = null;
    }

    private void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException ex) {
                this.log.error("Error closing statement: ", (Throwable)ex);
            }
        }
        statement = null;
    }

    public synchronized Integer getSequence(String sequenceName) throws SQLException {
        Integer sequenceCount = null;
        PreparedStatement sql = this.connection().prepareStatement("SELECT * FROM " + SEQUENCE_TABLE + " WHERE sequence_name = ?");
        sql.setString(1, sequenceName);
        ResultSet result = sql.executeQuery();
        while (result.next()) {
            sequenceCount = result.getInt("counter");
        }
        this.close(result);
        this.close(sql);
        if (sequenceCount == null) {
            sequenceCount = 1;
            this.createNewSequence(sequenceName);
        }
        this.incrementSequence(sequenceName, sequenceCount + 1);
        return sequenceCount;
    }

    private void incrementSequence(String sequenceName, Integer sequenceCount) throws SQLException {
        PreparedStatement sql = this.connection().prepareStatement("UPDATE " + SEQUENCE_TABLE + " SET counter = ? WHERE sequence_name = ?");
        sql.setInt(1, sequenceCount);
        sql.setString(2, sequenceName);
        sql.executeUpdate();
        this.close(sql);
    }

    private void createNewSequence(String sequenceName) throws SQLException {
        PreparedStatement sql = this.connection().prepareStatement("INSERT INTO " + SEQUENCE_TABLE + " VALUES (?, ?)");
        sql.setString(1, sequenceName);
        sql.setInt(2, 1);
        sql.executeUpdate();
        this.close(sql);
    }
}

